/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.taujava.popup.actions;

import edu.uoregon.tau.taujava.TaujavaPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RunTauJava
implements IObjectActionDelegate {
    IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        IJavaElement element = (IJavaElement)this.selection.getFirstElement();
        if (element.getElementType() != 5) {
            return;
        }
        ICompilationUnit jfile = (ICompilationUnit)element;
        try {
            this.launcher(jfile);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void launcher(ICompilationUnit jfile) throws CoreException {
        boolean para;
        IType jtype = jfile.findPrimaryType();
        if (jtype == null) {
            return;
        }
        IMethod[] seeker = jtype.getMethods();
        String main = null;
        int i = 0;
        while (i < seeker.length) {
            if (seeker[i].isMainMethod()) {
                IPackageDeclaration[] pdecs = jfile.getPackageDeclarations();
                main = jtype.getElementName();
                String pacname = ".";
                if (pdecs.length <= 0) break;
                pacname = String.valueOf(pdecs[0].getElementName()) + pacname;
                main = String.valueOf(pacname) + main;
                break;
            }
            ++i;
        }
        if (main == null) {
            return;
        }
        IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
        String lpath = pstore.getString("tauDirPathPreference");
        if (lpath == null) {
            lpath = "";
        }
        if (lpath.equals("")) {
            return;
        }
        IJavaProject proj = jfile.getJavaProject();
        String cfg = String.valueOf(proj.getElementName()) + "(TAU)";
        DebugPlugin plugin = DebugPlugin.getDefault();
        ILaunchManager lm = plugin.getLaunchManager();
        ILaunchConfigurationType t = lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy wc = t.newInstance(null, cfg);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, proj.getElementName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, main);
        HashMap<String, String> appMap = new HashMap<String, String>();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-XrunTAU:nomethods");
        boolean iswin = System.getProperty("os.name", "").toLowerCase().indexOf("windows") != -1;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IResource resource = root.findMember(proj.getPath());
        File tauout = resource.getLocation().toFile();
        String builddir = !pstore.getBoolean("defaultOutputRoot") ? tauout.getPath() : pstore.getString("outputRoot");
        builddir = String.valueOf(builddir) + File.separator + "TAU_Output" + File.separator + main + File.separator;
        Calendar timer = Calendar.getInstance();
        SimpleDateFormat timestamp = new SimpleDateFormat("yyyy_MMMMM_dd(hh_mm_ssaaa)");
        Date time = timer.getTime();
        String ftime = timestamp.format(time);
        int toutput = -1;
        File pdir = new File(String.valueOf(builddir) + "fault");
        File tdir = new File(String.valueOf(builddir) + "fault");
        File predir = new File(String.valueOf(builddir) + "fault");
        File tredir = new File(String.valueOf(builddir) + "fault");
        if (iswin) {
            String taudll = pstore.getString("tauWinDLLPreference");
            if (taudll.equals("tau-profile.dll")) {
                pdir = new File(String.valueOf(builddir) + "profile" + File.separator + ftime);
                pdir.mkdirs();
                appMap.put("PROFILEDIR", pdir.getPath());
                predir = new File(String.valueOf(pdir.getPath()) + File.separator + "Re-Run");
                predir.mkdirs();
                toutput = 2;
            } else if (taudll.equals("tau-callpath.dll")) {
                pdir = new File(String.valueOf(builddir) + "callpath" + File.separator + ftime);
                pdir.mkdirs();
                appMap.put("PROFILEDIR", pdir.getPath());
                predir = new File(String.valueOf(pdir.getPath()) + File.separator + "Re-Run");
                predir.mkdirs();
                toutput = 3;
            } else if (taudll.equals("tau-trace.dll")) {
                tdir = new File(String.valueOf(builddir) + "trace" + File.separator + ftime);
                tdir.mkdirs();
                appMap.put("TRACEDIR", tdir.getPath());
                tredir = new File(String.valueOf(tdir.getPath()) + File.separator + "Re-Run");
                tredir.mkdirs();
                toutput = 1;
            }
            lpath = String.valueOf(lpath.substring(0, lpath.lastIndexOf("lib"))) + "JavaDLL";
            try {
                File source = new File(String.valueOf(lpath) + "\\" + taudll);
                File dest = new File(String.valueOf(lpath) + "\\TAU.dll");
                FileChannel c1 = new RandomAccessFile(source, "r").getChannel();
                FileChannel c2 = new RandomAccessFile(dest, "rw").getChannel();
                long tCount = 0L;
                long size = c1.size();
                while ((tCount += c2.transferFrom(c1, 0L, size - tCount)) < size) {
                }
                c2.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            appMap.put("PATH", lpath);
        } else {
            appMap.put("LD_LIBRARY_PATH", lpath);
            pdir = new File(String.valueOf(builddir) + "profile" + File.separator + ftime);
            tdir = new File(String.valueOf(builddir) + "trace" + File.separator + ftime);
            predir = new File(String.valueOf(pdir.getPath()) + File.separator + "Re-Run");
            tredir = new File(String.valueOf(tdir.getPath()) + File.separator + "Re-Run");
            pdir.mkdirs();
            predir.mkdirs();
            tdir.mkdirs();
            tredir.mkdirs();
            appMap.put("TRACEDIR", tdir.getPath());
            appMap.put("PROFILEDIR", pdir.getPath());
            toutput = 4;
        }
        wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, appMap);
        ILaunchConfiguration config = wc.doSave();
        ILaunch x = config.launch("run", null);
        switch (toutput) {
            case 1: {
                appMap.put("TRACEDIR", tredir.getPath());
                break;
            }
            case 2: {
                appMap.put("PROFILEDIR", predir.getPath());
                break;
            }
            case 3: {
                appMap.put("PROFILEDIR", predir.getPath());
                break;
            }
            case 4: {
                appMap.put("PROFILEDIR", predir.getPath());
                appMap.put("TRACEDIR", tredir.getPath());
                break;
            }
            case 5: {
                appMap.put("PROFILEDIR", predir.getPath());
                appMap.put("TRACEDIR", tredir.getPath());
            }
        }
        wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, appMap);
        config = wc.doSave();
        try {
            while (!x.isTerminated()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (!iswin) {
            File[] plist = pdir.listFiles();
            File[] tlist = tdir.listFiles();
            if (plist.length == 1) {
                plist[0].delete();
                pdir.delete();
            }
            if (tlist.length == 1) {
                tlist[0].delete();
                tdir.delete();
            }
        }
        if ((para = pstore.getBoolean("runParaProf")) && toutput > 1) {
            if (iswin) {
                try {
                    String tbpath = String.valueOf(lpath.substring(0, lpath.lastIndexOf("JavaDLL"))) + "bin";
                    File taubin = new File(tbpath);
                    Runtime.getRuntime().exec("cmd /c start paraprof.bat \"" + pdir.getPath() + "\"", null, taubin);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    String paracmd = String.valueOf(lpath.substring(0, lpath.lastIndexOf("lib"))) + "bin" + File.separator + "paraprof ";
                    Runtime.getRuntime().exec(String.valueOf(paracmd) + pdir.getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }
}

