/* This file is part of TCD 2.0.
   tcd.h - Header file for Curses interface.

   Copyright (C) 1997-98 Tim P. Gerla <timg@rrv.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
                   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
                                               
   Tim P. Gerla
   RR 1, Box 40
   Climax, MN  56523
   timg@rrv.net
*/

#ifndef TCD_TCD_H
#define TCD_TCD_H

#include <SDL/SDL.h>

#define lengthof(m_arr) (sizeof(m_arr) / sizeof((m_arr)[0]))

typedef enum {
    PLAY_METHOD_FIRST,
    REPEAT_CD = PLAY_METHOD_FIRST,
    REPEAT_TRK,
    NORMAL,
    PLAY_METHOD_LAST = NORMAL
} PlayMethod;

struct cd_track {
    char name[256];
    char extra_data[256];
};

struct cd_info {
    struct cd_track trk[SDL_MAX_TRACKS];
    char disc_title[256];
    char extra_data[256];
    int modified;
};

struct tcd_state {
    volatile int quit_requested;

    PlayMethod play_method;

    struct cd_info cd_info;
    SDL_CD *cdrom;
    unsigned long current_discid;
};

#endif /* TCD_TCD_H */
