[manpage_begin base64 n 2.3.2]
[copyright {2000, Eric Melski}]
[copyright {2001, Miguel Sofer}]
[moddesc   {Text encoding & decoding binary data}]
[titledesc {base64-encode/decode binary data}]
[require Tcl 8]
[require base64 [opt 2.3.2]]
[description]
[para]

This package provides procedures to encode binary data into base64 and back.

[list_begin definitions]

[call [cmd ::base64::encode] [opt "-maxlen [arg maxlen]"] [opt "-wrapchar [arg wrapchar]"] [arg string]]

Base64 encodes the given binary [arg string] and returns the encoded
result. Inserts the character [arg wrapchar] every [arg maxlen]
characters of output. [arg wrapchar] defaults to newline. [arg maxlen]
defaults to [const 60].

[para]

[emph {Note well}]: If your string is not simple ascii you should fix
the string encoding before doing base64 encoding. See the examples.


[call [cmd ::base64::decode] [arg "string"]]

Base64 decodes the given [arg "string"] and returns the binary data.
The decoder ignores whitespace in the string.

[list_end]

[section {EXAMPLES}]

[example {
% base64::encode "Hello, world"
SGVsbG8sIHdvcmxk
}]

[example {
% base64::encode [string repeat xyz 20]
eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6
eHl6eHl6eHl6
% base64::encode -wrapchar "" [string repeat xyz 20]
eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6eHl6
}]

[example {
# NOTE: base64 encodes BINARY strings.
% set chemical [encoding convertto utf-8 "C\u2088H\u2081\u2080N\u2084O\u2082"]
% set encoded [base64::encode $chemical]
Q+KCiEjigoHigoBO4oKET+KCgg==
% set caffeine [encoding convertfrom utf-8 [base64::decode $encoded]]
}]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph base64] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords encoding base64]
[manpage_end]
