'\" 
'\" Copyright (c) 2001 by Andreas Kupries <a.kupries@westend.com>
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: fileutil.n,v 1.7 2002/01/18 20:51:15 andreas_kupries Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH fileutil n 1.1 Fileutil "file utilities"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
::fileutil \- Procedures implementing some file utilities
.SH SYNOPSIS
\fBpackage require Tcl 8\fR
.sp
\fBpackage require fileutil ?1.3?\fR
.sp
\fB::fileutil::cat\fR \fIfilename\fR
.sp
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??
.sp
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fI-regexp\fI|\fI-glob\fR? ?\fI\--\fR? \fIpatterns\fR
.sp
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR
.sp
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?
.sp
\fB::fileutil::touch\fR ?\fI-a\fR? ?\fI-c\fR? ?\fI-m\fR? ?\fI-r ref_file\fR? ?\fI-t time\fR? \fIfilename\fR ?\fI...\fR?
.BE
.SH DESCRIPTION
.PP
This package provides implementations of standard unix utilities
.TP
\fB::fileutil::cat\fR \fIfilename\fR
A tcl implementation of the UNIX "cat" command.  Returns the contents
of the specified file. The first argument is the name of the file to
read.
.TP
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??
An implementation of the unix command \fBfind\fR. Adapted from the
Tcler's Wiki. Takes at most two arguments, the path to the directory
to start searching from and a command to use to evaluate interest in
each file. The path defaults to \fB.\fR, i.e. the current
directory. The command defaults to the empty string, which means that
all files are of interest. The command takes care \fBnot\fR to loose
itself in infinite loops upon encountering circular link structures.
The result of the command is a list containing the paths to the
interesting files.
.TP
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fI-regexp\fI|\fI-glob\fR? ?\fI\--\fR? \fIpatterns\fR
This command is based upon the TclX command \fBrecursive_glob\fR,
except that it doesn't allow recursion over more than one directory at
a time. It uses \fB::fileutil::find\fR internally and is thus able to
and does follow symbolic links, something the TclX command does not
do. First argument is the directory to start the search in, second
argument is a list of \fIpatterns\fR. The command returns a list of
all files reachable through \fIbasedir\fR whose names match at least
one of the patterns. The options before the pattern-list determine the
style of matching, either regexp or glob. glob-style matching is the
default if no options are given. Usage of the option \fI--\fR stops
option processing. This allows the use of a leading '-' in the
patterns.
.TP
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR
The command reads the file \fIfilename\fR and executes the script
\fIcmd\fR for every line in the file. During the execution of the
script the variable \fIvar\fR is set to the contents of the current
line. The return value of this command is the result of the last
invocation of the script \fIcmd\fR or the empty string if the file was
empty.
.TP
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?
Implementation of grep. Adapted from the Tcler's Wiki. The first
argument defines the \fIpattern\fR to search for. This is followed by
a list of \fIfiles\fR to search through. The list is optional and
\fBstdin\fR will be used if is missing. The result of the procedures
is a list containing the matches. Each match is a single element of
the list and contains filename, number and contents of the matching
line, separated by a colons.
.TP
\fB::fileutil::touch\fR ?\fI-a\fR? ?\fI-c\fR? ?\fI-m\fR? ?\fI-r ref_file\fR? ?\fI-t time\fR? \fIfilename\fR ?\fI...\fR?
Implementation of touch. Alter the atime and mtime of the specified
files. If \fI-c\fR, do not create files if they do not already
exist. If \fI-r\fR, use the atime and mtime from \fIref_file\fR. If
\fI-t\fR, use the integer clock value \fItime\fR. It is illegal to 
specify both \fI-r\fR and \fI-t\fR. If \fI-a\fR, only change the 
atime. If \fI-m\fR, only change the mtime. 

.SH KEYWORDS
file utilities
