# -*- Mode: ruby; indent-tabs-mode: nil -*-
#
#  $Id: source_container.rb,v 1.1 2003/09/23 01:20:40 hisa Exp $
#
#  Copyright (c) 2003 FUJIMOTO Hisakuni <hisa@fobj.com>
#
#  This program is free software.
#  You can distribute/modify this program under the terms of
#  the GNU Lesser General Public License version 2.
#
require 'tempura/source'

module Tempura

  class SourceContainer

    def initialize
      @sources = {}
    end

    def [](key)
      @sources[key] || @sources[nil]
    end

    def []=(key,val)
      raise ArgumentError, "Tempura::Source required" unless val.is_a? Tempura::Source
      @sources[key] = val
    end

    def default
      return self[nil]
    end

    def default=(val)
      self[nil] = val
    end

    def set(key, path, charconv = nil)
      self[key] = Tempura::Source.new(path, charconv)
    end

    def set_as_string(key, string, charconv = nil)
      self[key] = Tempura::Source.new_with_string(string, charconv)
    end

    def reload
      @sources.values.each do |src|
        src.reload
      end
    end

  end

end
