
###############################################################################
# SVNINFO.PERL
# Copyright 1995 Dr. Juergen Vollmer <Juergen.Vollmer@acm.org>
# Copyright 2003-2005 Achim D. Brucker <brucker@freiburg.linux.de>
#
# Extension to LaTeX2HTML to translate LaTeX commands of the
#               svninfo
# package to equivalent HTML commands.
#
# This is file `svninfo.perl',
# generated with the docstrip utility.
#
# The original source files were:
#
# svninfo.dtx  (with options: `perl')
#
# IMPORTANT NOTICE:
#
# For the copyright see the source file.
#
# Any modified versions of this file must be renamed
# with new filenames distinct from svninfo.perl.
#
# For distribution of the original source see the terms
# for copying and modification in the file svninfo.dtx.
#
# This generated file may be distributed as long as the
# original source files, as listed above, are part of the
# same distribution. (The sources need not necessarily be
# in the same archive or directory.)
#
# $Id: svninfo.dtx 1168 2005-04-08 06:18:47Z brucker $
#
###############################################################################

package svninfo;

($Dummy1,$PackageVersionDate,$PackageVersionTime,$Dummy2) =
        split (/ /,'$Date: 2005-04-08 08:18:47 +0200 (Fr, 08 Apr 2005) $');

print "\n\t svninfo style interface for LaTeX2HTML, $PackageVersionDate\n";

# set defaults options
$OptionFancy = 1;
$OptionToday = 1;
$OptionLong  = 1;

# set default values
$Date     = `date '+%Y/%m/%d'`;
$Time     = `date '+%H:%M:%S'`;
$File     = "--sourcefile--";
$Revision = "--revision--";
$Owner    = "--owner--";
$Year     = `date '+%Y'`;
$Month    = `date '+%m'`;
$Day      = `date '+%d'`;
$LongDate = $Date;

sub SetAddress
{
    $main::address_data[1] = "Revision: $svninfo::Revision, $svninfo::LongDate";
    # Supply your own string if you don't like the default <Name> <Date>
    $main::ADDRESS = "<I>$main::address_data[0] <BR>\n$main::address_data[1]</I>";
}
if ($SetAddressProc == "") {
  $SetAddressProc = \&svninfo::SetAddress;
}
sub make_cmds
{
  my $cmd;
  foreach $cmd (File,Revision,Date,Time,Owner,Year,Month,Day,LongDate) {
        eval "sub main::do_cmd_svnInfo$cmd { "
            . 'my $val = $svninfo::' . "$cmd; "
#           . 'printf STDERR "\ndo_cmd_svnInfo%s=%s\n", ' . $cmd .', $val;'
            . "join('',\$val,\$_[0]);"
            . "}";
  }
}

@GermanMonthName  = ('','Januar','Februar','M&auml;rz','April','Mai','Juni','Juli',
                    'August','September','Oktober','November','Dezember');
@EnglishMonthName = ('','January','February','March','April','May','June','July',
                    'August','September','October','November','December');
@FrenchMonthName  = ('','Janvier','F&eacute;vrier','Mars','Avril','Mai','Juin',
                     'Juillet','Ao&ucirc;t','Septembre','Octobre','Novembre',
                     'D&eacute;cembre');

###############################################################################

package main;

# handling package options
sub do_svninfo_fancyhdr { $svninfo::OptionFancy = 1; }
sub do_svninfo_fancy    { $svninfo::OptionFancy = 1; }
sub do_svninfo_nofancy  { $svninfo::OptionFancy = 0; }
sub do_svninfo_today    { $svninfo::OptionToday = 1; }
sub do_svninfo_notoday  { $svninfo::OptionToday = 0; }
sub do_svninfo_short    { $svninfo::OptionLong  = 0; }
sub do_svninfo_long     { $svninfo::OptionLong  = 1; }

# handling of LaTeX commands
sub do_cmd_svnInfo
{

    local ($_) = @_;

    # printf STDERR "\ndo_cmd_svnInfo\n";

    # see latex2html, procedure: substitute_meta_cmds, process_body_newcommand
    # the format of the variable $new_command{cmd} is:
    #   $new_command{$cmd} = join(':!:',$argn,$body,$opt);
    # note: opt = "}" means:  Flag for no optional arg
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoFILE};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoREVISION};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoYEAR};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoMONTH};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoDAY};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoTIME};
    # printf STDERR "xxxxxxxxxxx `%s'\n", $new_command{svnInfoOWNER};

    # the following assumes: LaTeX2HTML Version 99.1 release (March 30, 1999)
    # may be later
    my ($argn, $opt);
    if (exists $new_command{svnInfoFILE}) {
        ($argn, $svninfo::File, $opt) = split(/:!:/, $new_command{svnInfoFILE});
    } else {
         $svninfo::File = $File
    }
    if (exists $new_command{svnInfoREVISION}) {
        ($argn, $svninfo::Revision, $opt) = split(/:!:/, $new_command{svnInfoREVISION});
    } else {
         $svninfo::Revision = $Revision
    }
    if (exists $new_command{svnInfoYEAR}) {
        ($argn, $svninfo::Year, $opt) = split(/:!:/, $new_command{svnInfoYEAR});
    } else {
         $svninfo::Year = $Year
    }
    if (exists $new_command{svnInfoMONTH}) {
        ($argn, $svninfo::Month, $opt) = split(/:!:/, $new_command{svnInfoMONTH});
    } else {
         $svninfo::Month = $Month
    }
    if (exists $new_command{svnInfoDAY}) {
        ($argn, $svninfo::Day, $opt) = split(/:!:/, $new_command{svnInfoDAY});
    } else {
         $svninfo::Day = $Day
    }
    if (exists $new_command{svnInfoTIME}) {
        ($argn, $svninfo::Time, $opt) = split(/:!:/, $new_command{svnInfoTIME});
    } else {
         $svninfo::Time = $Time
    }
    if (exists $new_command{svnInfoOWNER}) {
        ($argn, $svninfo::Owner, $opt) = split(/:!:/, $new_command{svnInfoOWNER});
    } else {
         $svninfo::Owner = $Owner
    }

    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::File;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Revision;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Year;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Month;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Day;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Time;
    # printf STDERR "yyyyyyyyyyy `%s'\n",  $svninfo::Owner;

    # the following code is for oldfashioned latex2hmtl, not anymore supported
    # format of $_:
    #                  vvvvvv that's text following the SVN-Id-string
    # <#nr#>.....<#nr>......
    #       ^ ^ ^  that's the SVN-Id-string
#    my ($Nr,$IdString,$Rest) = /(<#\d+#>)(.*)\1(.*)/s ;

    # The Id-String  may contain various tags, remove them
#    $IdString =~ s/<[^>]*>//g;

     # The Id-String  may contain various tags, remove them
#    $IdString =~ s/<[^>]*>//g;

    # split the Id-string
#    my ($id,$file,$revision,$date,$time,$owner) = split(/\s/,$IdString);

    # remove trailing ,v
#    $file =~ s/,v$//;

    # split date
#    ($svninfo::Year,$svninfo::Month,$svninfo::Day) = split (/\//,$date);

#    $svninfo::Revision = $revision;
#    $svninfo::File     = $file;
#    $svninfo::Date     = $date;
#    $svninfo::Time     = $time;
#    $svninfo::Owner    = $owner;

    if ($default_language eq 'german' || $default_language eq 'austrian') {
        $svninfo::LongDate = $svninfo::Day . '.&nbsp;' .
                 $svninfo::GermanMonthName[$svninfo::Month] . '&nbsp;' .
                 $svninfo::Year;
        $svnInfo::Date = $svninfo::Day . '.&nbsp;' . $svninfo::Month . '.&nbsp;' . $svninfo::Year;
    } elsif ($default_language eq 'french') {
        $svninfo::LongDate = $svninfo::Day . '.&nbsp;' .
                 $svninfo::FrenchMonthName[$svninfo::Month] . '&nbsp;' .
                 $svninfo::Year;
        $svnInfo::Date = $svninfo::Day . '.&nbsp;' .$svninfo::Month . '.&nbsp;' . $svninfo::Year;
    } else { # english is the default
        $svninfo::LongDate = $svninfo::EnglishMonthName[$svninfo::Month] . '&nbsp;' .
                 $svninfo::Day . ',&nbsp;' .
                 $svninfo::Year;
        $svnInfo::Date = $svninfo::Year . '/' .$svninfo::Month . '/' . $svninfo::Day;
    }

    if ($svninfo::OptionFancy == 1) {
       &$svninfo::SetAddressProc;
    }
    svninfo::make_cmds();

    # printf STDERR "xxx $HTML_VERSION, $HTML_OPTIONS\n";
    # remove stuff generated for the $Id: svninfo.dtx 1168 2005-04-08 06:18:47Z brucker $-string
    # we assume that noting follows the "\svnInfo $Id....$"
    if ($HTML_VERSION >= 3.2) {
        /^<tex2html_verbatim_mark>[^\n]*/;
        return $';
    } elsif ($HTML_VERSION == 3.1 || $HTML_VERSION == 2.1) {
        /^<tex2html_image_mark>[^\n]*/;
        return $';
    } else {
        if ($HTML_OPTIONS =~ /math/) {
            /^<tex2html_verbatim_mark>[^\n]*/;
            return $';
        } else {
            /^<tex2html_image_mark>[^\n]*/;
            return $';
        }
    }
}

# Replace do_cmd_today (\today) using the SVN date.
sub do_cmd_today {
    local($today);
    if ($svninfo::OptionToday == 1) {
        $today = $svninfo::LongDate;
    } else {
        if ($default_language eq 'german' || $default_language eq 'austrian') {
            $today = (`date "+%m:%d, 20%y"`);
            $today =~ s/(\d{1,2}):0?(\d{1,2}),/$2. $svninfo::GermanMonthName[$1]/o;
            $today =~ s/20([7|8|9]\d{1})/19$1/o;
        } elsif ($default_language eq 'french') {
            $today = (`date "+%m:%d, 20%y"`);
            $today =~ s/(\d{1,2}):0?(\d{1,2}),/$2 $svninfo::FrenchMonthName[$1]/o;
            $today =~ s/20([7|8|9]\d{1})/19$1/o;
        } else { # english is the default
            $today = (`date "+%m:%d, 20%y"`);
            $today =~ s/(\d{1,2}):0?/$svninfo::EnglishMonthName[$1] /o;
            $today =~ s/20([7|8|9]\d{1})/19$1/o;
        }
    }
    join('',$today,$_[0]);
}

1;

###############################################################################
