
/******************************************************************************
* MODULE     : array
* DESCRIPTION: fixed size arrays with reference counting and
*              pointer copying
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>

#module array (T)
#import tree

class array_rep<T>: concrete_struct {
  int n;
  T* a;

public:
  inline array_rep<T> (): n(0), a(NULL) {}
         array_rep<T>(int n);
  inline ~array_rep<T> () { if (n!=0) delete[] a; }
  void resize (int n);
  friend class array<T>;
  friend inline int N (array<T> a);
  friend inline array<T> copy (array<T> a);
};

class array<T> {
#import concrete (array<T>, array_rep<T>)
  inline array<T> (int n=0): rep (new array_rep<T>(n)) {}
  array<T> (T *a, int n);
  inline T& operator [] (int i) { return rep->a[i]; }
  operator tree ();
};
#import code_concrete (array<T>, array_rep<T>)

extern inline int N (array<T> a) { return a->n; }
inline array<T> copy (array<T> a) { return array<T> (a->a, a->n); }

ostream& operator << (ostream& out, array<T> a);
array<T>& operator << (array<T>& a, T x);
array<T>& operator << (array<T>& a, array<T> b);
bool operator == (array<T> a, array<T> b);
bool operator != (array<T> a, array<T> b);

#endmodule // array (T)
