/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef COVMAT_SEEN
#define COVMAT_SEEN

#include "pdbMalloc.h"

void
PrintCovMatGnuPlot(const double **mat, const int dim, char *outfile);

void
SetupCovWeighting(CoordsArray *cdsA);

int
CheckZeroVariances(CoordsArray *cdsA);

void
CalcBfactC(CoordsArray *cdsA);

void
CalcCovariances(CoordsArray *scratchA);

void
mlMatNormCovMats(CoordsArray *cdsA, const double precision, const int iterate);

void
mlMatNormCovMats2(CoordsArray *cdsA, const double precision, const int iterate);

void
mlMatNormCovMatsConstVar(CoordsArray *cdsA, const double precision, const int iterate);

void
MVCovMat(CoordsArray *cdsA);

void
CalcAxCovMat(CoordsArray *cdsA);

void
CalcAxCovMat1(CoordsArray *cdsA);

void
CalcAxCovMat2(CoordsArray *cdsA);

void
PrincAxesAxCovMat(CoordsArray *cdsA, double **rotmat, double * evals);

void
CalcCovMat(CoordsArray *cdsA);

void
CalcCovMatFullAx(CoordsArray *cdsA);

void
CalcCovMatOcc(CoordsArray *cdsA);

void
CalcStructCovMat(CoordsArray *cdsA);

void
CalcFullCovMat(CoordsArray *cdsA);

void
CalcCovCoords(Coords *coords, const double **covmat);

int
CovInvWeightLAPACK(CoordsArray *cdsA);

void
CovMat2CorMat(double **CovMat, const int size);

void
CorMat2CovMat(double **CovMat, const double *vars, const int size);

double
NormalizeCovMat(double **mat, const int size);

void
PrintCovMat(CoordsArray *cdsA);

void
InvgaussFitVars(CoordsArray *cdsA, double *mean, double *lambda);

void
InvgaussAdjustVars(CoordsArray *cdsA,
                   const double mean, const double lambda);

void
LognormalFitVars(CoordsArray *cdsA, double *zeta, double *sigma);

void
LognormalAdjustVars(CoordsArray *cdsA, double zeta, double sigma);

void
InvGammaFitVars(CoordsArray *cdsA, int iterate);

void
InvGammaFitVars_c1(CoordsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_GaussVarVar(CoordsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_Mode(CoordsArray *cdsA, double *b, double *c, const double mode);

void
InvGammaStacyFitVars(CoordsArray *cdsA, double *b, double *c);

void
InvGammaMMFitVars(CoordsArray *cdsA, double *b, double *c);

void
InvGammaAdjustVars(CoordsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCov(CoordsArray *cdsA, const double b, const double c);

void
RecipInvGaussFitVars(CoordsArray *cdsA, double *mu, double *lambda);

void
RecipInvGaussAdjustVars(CoordsArray *cdsA,
                            const double mu, const double lambda);

#endif
