/*
 * pluginlistmodel.h
 * Copyright 2015, Thorbjørn Lindeijer <bjorn@lindeijer.nl>
 *
 * This file is part of Tiled.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TILED_INTERNAL_PLUGINLISTMODEL_H
#define TILED_INTERNAL_PLUGINLISTMODEL_H

#include <QAbstractListModel>
#include <QIcon>

namespace Tiled {
namespace Internal {

class PluginListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    PluginListModel(QObject *parent = nullptr);

    int rowCount(const QModelIndex &parent) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    Qt::ItemFlags flags(const QModelIndex &index) const override;
    bool setData(const QModelIndex &index, const QVariant &value, int role) override;

signals:
    void setPluginEnabled(const QString &fileName, bool enabled);

private:
    QIcon mPluginIcon;
    QIcon mPluginErrorIcon;
};

} // namespace Internal
} // namespace Tiled

#endif // TILED_INTERNAL_PLUGINLISTMODEL_H
