#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "advanced_cb.h"
#include "advanced_dbox.h"
#include "support.h"

#include "tilibs.h"
#include "struct.h"

static gint tmp_timeout;
static gint tmp_delay;

gint display_advanced_dbox()
{
  GtkWidget *dbox;
  gpointer user_data;

  dbox = create_advanced_dbox();
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "spinbutton1");
  tmp_timeout = options.lp.timeout;
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(user_data), options.lp.timeout);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "spinbutton2");
  tmp_delay = options.lp.delay;
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(user_data), options.lp.delay);

  gtk_widget_show_all(dbox);
  return 0;
}


void
on_timeout_spinbutton1_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  tmp_timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (user_data));
}


void
on_delay_spinbutton2_changed           (GtkEditable     *editable,
                                        gpointer         user_data)
{
  tmp_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (user_data));
}

void
on_timeout_ok_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  options.lp.timeout = tmp_timeout;
  options.lp.delay = tmp_delay;

  ticable_set_delay(options.lp.delay);
  ticable_set_timeout(options.lp.timeout);

  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_timeout_cancel_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}

/**/



