#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "gfm_cb.h"
#include "gfm_dbox.h"
#include "support.h"

#include "about_cb.h"
#include "manpage_dbox.h"
#include "manpage_cb.h"
#include "help_cb.h"
#include "thanks_cb.h"
#include "startup_dbox.h"
#include "startup_cb.h"
#include "struct.h"
#include "tilibs.h"
#include "ctree.h"
#include "xpm.h"
#include "msg_cb.h"


/**************/
/* Ctree dbox */
/**************/

static gint window_number = 0;
static GList *window_list = NULL;

static GtkWidget *ctree = NULL;  /* current ctree  */
static GtkWidget *window = NULL; /* current window */

int display_ti_file(gchar *filename);
int display_gfm_fsel_dbox(const gchar *pattern);

int display_gfm_dbox(gchar *filename)
{
  GtkWidget *dbox;
  gpointer user_data;
  gchar tempstr[128];

  window = dbox = create_gfm_dbox();
  window_list = g_list_append(window_list, dbox);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "gfm_dbox");
  g_snprintf(tempstr, sizeof(tempstr), "%s (%i): %s",
	     _("Group File Manager"),
	     window_number++, filename);
  gtk_window_set_title(GTK_WINDOW(user_data), tempstr);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "ctree1");
  ctree = GTK_WIDGET(user_data);
  gtk_clist_set_column_width(GTK_CLIST (ctree), 0, 135); //varname
  gtk_clist_set_column_width(GTK_CLIST (ctree), 1, 25);  //attributes
  gtk_clist_set_column_width(GTK_CLIST (ctree), 2, 60);  //type
  gtk_clist_set_column_width(GTK_CLIST (ctree), 3, 20);  //size
  //gtk_ctree_set_indent (GTK_CTREE (ctree), 17);
  gtk_clist_set_row_height(GTK_CLIST (ctree), 16);

  gtk_widget_show_all(dbox);

  if(strcmp(filename, ""))
    display_ti_file(filename);

  return 0;
}

void
on_gfm_dbox_show                       (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_gfm_dbox_destroy                    (GtkObject       *object,
                                        gpointer         user_data)
{
  /*
    gint ret;
  ret = user2_box(_("Question"), _("Are you sure you want to quit ?"),
		  _("OK"), _("Cancel"));
  */
}


void
on_gfm_new1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_gfm_dbox("");
}


void
on_gfm_open1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_gfm_fsel_dbox("*.89*");
}


void
on_gfm_save1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_save_as1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_close1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  window_list = g_list_remove(window_list, user_data);
  gtk_widget_destroy(user_data);
}


void
on_gfm_quit1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  window_number = 0;
  g_list_foreach(window_list, (GFunc)gtk_widget_destroy, NULL);
  g_list_free(window_list);
  window_list = NULL;
}


void
on_gfm_cut1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_copy1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_paste1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_new_folder1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_ungroup1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_group1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_send_variable1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_receive_variable1_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_gfm_help2_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_help_dbox();
}


void
on_gfm_manpage1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_manpage_dbox();
}


void
on_gfm_changelog1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_startup_dbox();
}


void
on_gfm_thanks1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_thanks_dbox();
}


void
on_gfm_about1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_about_dbox();
}


void
on_ctree2_click_column                 (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


gboolean
on_ctree2_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_ctree2_tree_expand                  (GtkCTree        *ctree,
                                        GList           *node,
                                        gpointer         user_data)
{

}


void
on_ctree2_tree_collapse                (GtkCTree        *ctree,
                                        GList           *node,
                                        gpointer         user_data)
{

}


void
on_ctree2_tree_select_row              (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{

}


void
on_ctree2_tree_unselect_row            (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{

}


void
on_ctree1_drag_begin                   (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data)
{

}


void
on_ctree1_drag_data_delete             (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data)
{

}


void
on_ctree1_drag_data_get                (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{

}


void
on_ctree1_drag_data_received           (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{

}


gboolean
on_ctree1_drag_drop                    (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        guint            time,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_ctree1_drag_end                     (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data)
{

}


void
on_ctree1_drag_leave                   (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        guint            time,
                                        gpointer         user_data)
{

}


gboolean
on_ctree1_drag_motion                  (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        guint            time,
                                        gpointer         user_data)
{

  return FALSE;
}

/********************/
/* Filesection dbox */
/********************/

int display_gfm_fsel_dbox(const gchar *pattern)
{
  GtkWidget *dbox;
  gpointer user_data;
  gchar buffer[8];

  dbox = create_gfm_fileselection_open();

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "gfm_fileselection_open");
  strcpy(buffer, "*.");
  strcat(buffer, ticalc_group_file_ext(options.lp.calc_type));
  gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), buffer);

  gtk_widget_show_all(dbox);
  return 0;
}

void
on_ok_gfm_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *selected_filename;

  selected_filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
  display_ti_file(selected_filename);

  gtk_widget_destroy(user_data);
}


void
on_cancel_gfm_button1_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(user_data);
}

int display_ti_file(gchar *filename)
{
  GdkPixmap *pixmap1, *pixmap2, *pixmap3, *pixmap4, *pixmap5;
  GdkBitmap *mask1, *mask2, *mask3, *mask4, *mask5;
  GtkCTreeNode *tifs_node, *parent_node, *child_node;
  GtkStyle *style;
  gchar *tab[4] = { 0 };
  gchar *tifs[] = { N_("filename"), N_(""), N_(""), N_("") };
  int i;
  GdkFont *font;

#ifdef HAVE_LIBTIFFEP
  GList *vl = NULL;
  GList *dl = NULL;
  TiffepFileInfo *fi = NULL;
  TiffepVarInfo  *vi = NULL;
  TiffepFolderInfo  *di = NULL;

  if(tiffep_load_file_content(filename, &fi) != 0)
    {
      msg_box(_("Error"), _("Unable to load the file."));
      return -1;
    }  

  style = gtk_style_copy(GTK_WIDGET(window)->style);
  font = load_ti_font();
  if(font != NULL)
    style->font = font;
  else
    fprintf(stdout, _("** Warning: unable to load the TIcalc font. Use default font instead.\n"));

  gtk_clist_freeze(GTK_CLIST(ctree));
  gtk_clist_clear(GTK_CLIST(ctree));
  //gtk_widget_realize(window);

  open_xpm("dir_closed.xpm",    window, &pixmap1, &mask1);
  open_xpm("dir_opened.xpm",    window, &pixmap3, &mask3);
  open_xpm("doc.xpm",           window, &pixmap2, &mask2);
  open_xpm("locked.xpm",        window, &pixmap4, &mask4);
  open_xpm("archived.xpm",      window, &pixmap5, &mask5);
  
  tifs[0] = g_strdup(filename);
  tifs_node=gtk_ctree_insert_node(GTK_CTREE(ctree), NULL, NULL, tifs, 
				   5, pixmap1, mask1, pixmap2, mask2, 
				   FALSE, TRUE);
  gtk_ctree_node_set_row_data(GTK_CTREE(ctree), tifs_node, 
			      (gpointer)NULL);
  gtk_ctree_node_set_selectable(GTK_CTREE(ctree), tifs_node, 0);
  
  vl = FILEINFO_VARLIST(fi);
  dl = FILEINFO_DIRLIST(fi);
  parent_node = tifs_node;
  
  while((dl != NULL) && (vl != NULL))
    {
      di = (TiffepFolderInfo *)(dl->data);
      vi = (TiffepVarInfo *)(vl->data);

      tab[0] = g_strdup(DIRINFO_NAME(di));
      tab[2] = NULL;
      tab[3] = g_strdup_printf("%u", DIRINFO_SIZE(di));
      
      parent_node=gtk_ctree_insert_node (GTK_CTREE(ctree), tifs_node,
					 NULL, tab, 5, 
					 pixmap1, mask1, pixmap3, mask3, 
					 FALSE, TRUE);
      gtk_ctree_node_set_row_data (GTK_CTREE(ctree), parent_node, 
				   (gpointer)di);
      gtk_ctree_node_set_selectable(GTK_CTREE(ctree), parent_node, 1);
      for(i=0; i<4; i++) g_free(tab[i]);
      
      while(!strcmp(VARINFO_PATH(vi), DIRINFO_NAME(di)) && (vl != NULL))
	{ 
	  /*
	  fprintf(stdout, "foldername\\varname = <%s\\%s>\n", 
		  VARINFO_PATH(vi),
		  VARINFO_REALNAME(vi));
	  */
	  tab[0] = g_strdup(VARINFO_REALNAME(vi));
	  tab[2] = g_strdup_printf("%s", tiffep_var_type_to_string(VARINFO_TYPE(vi)));
	  tab[3] = g_strdup_printf("%u", VARINFO_SIZE(vi));
	  child_node=gtk_ctree_insert_node(GTK_CTREE (ctree), parent_node,
					   NULL, tab, 5, 
					   pixmap1, mask1, pixmap2, mask2, 
					   FALSE, TRUE);
	  for(i=0; i<4; i++) g_free(tab[i]);
	  switch(VARINFO_ATTRIBUTE(vi))
	    {
	    case 1:
	    case 3:
	      gtk_ctree_node_set_pixmap(GTK_CTREE (ctree), 
					child_node, 1, pixmap4, mask4);
	      break;
	    case 2:
	      gtk_ctree_node_set_pixmap(GTK_CTREE (ctree), 
					child_node, 1, pixmap5, mask5);
	      break;
	    }
	  gtk_ctree_node_set_row_data (GTK_CTREE(ctree), 
				       child_node, (gpointer)vi);
	  gtk_ctree_node_set_cell_style(GTK_CTREE(ctree), 
					child_node, 0, style);

	  vl = g_list_next(vl);
	  if(vl != NULL)
	    vi = (TiffepVarInfo *)(vl->data);
	}
      
      dl = g_list_next(dl);
    }

  tiffep_free_fi_struct(&fi); // vi is implicitely freed
#endif

  gdk_pixmap_unref(pixmap1);
  gdk_pixmap_unref(pixmap2);
  gdk_pixmap_unref(pixmap3);
  gdk_pixmap_unref(pixmap4);
  gdk_pixmap_unref(pixmap5);

  gtk_clist_thaw(GTK_CLIST(ctree));

  return 0;
}

/**/

