#ifndef INDII_TINT_OBSERVER_HPP
#define INDII_TINT_OBSERVER_HPP

namespace indii {
  namespace tint {

/**
 * Abstract observer.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
template<class T>
class Observer {
public:
  /**
   * Constructor.
   */
  Observer();

  /**
   * Destructor. Object will automatically call unsubscribe() on any watched
   * Observable object if necessary.
   */
  virtual ~Observer();

  /**
   * Observe an object.
   */
  void watch(T* o);
   
  /**
   * Stop observing the object.
   */
  void ignore();
   
  /**
   * Notify of change.
   */
  virtual void notify();
  
  /**
   * Notify of destruction.
   */
  void notifyDestroy();
  
private:
  /**
   * Observed object.
   */
  T* o;

  /**
   * Are we currently observing an object?
   */
  bool watching;

};
 
  }
}

template <class T>
indii::tint::Observer<T>::Observer() : watching(false) {
  //
}

template <class T>
indii::tint::Observer<T>::~Observer() {
  ignore();
}

template <class T>
void indii::tint::Observer<T>::watch(T* o) {
  o->subscribe(this);

  this->o = o;
  this->watching = true;
}

template <class T>
void indii::tint::Observer<T>::ignore() {
  if (watching) {
    o->unsubscribe(const_cast<Observer<T>*>(this));
  }

  this->watching = false;
}

template <class T>
inline void indii::tint::Observer<T>::notify() {
  //
}

template <class T>
inline void indii::tint::Observer<T>::notifyDestroy() {
  this->watching = false;
}

#endif

