#ifndef INDII_TINT_GUI_CHANNELMIXERPANE_HPP
#define INDII_TINT_GUI_CHANNELMIXERPANE_HPP

#include "TintPane.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/slider.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Greyscale channel mixing pane.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class ChannelMixerPane : public TintPane, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param model Cluster model.
   */
  ChannelMixerPane(wxWindow* parent, ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifyGreyscaleChange();

  /*
   * Slider control events.
   */
  void OnSlide(wxScrollEvent& evt);
  
private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /*
   * Slider controls.
   */ 
  wxSlider *slideRed, *slideGreen, *slideBlue;

  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_RED,
    ID_SLIDE_GREEN,
    ID_SLIDE_BLUE
  };

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif

