/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ClassSelectDlg.H"
#include <wx/statline.h>

BEGIN_EVENT_TABLE(ClassSelectDlg, wxDialog)
  EVT_BUTTON(NEW_B, ClassSelectDlg::OnNewClass)
  EVT_BUTTON(SEL_B, ClassSelectDlg::OnButtonActivated)
  EVT_LIST_ITEM_SELECTED(LC, ClassSelectDlg::OnSelection)
  EVT_LIST_ITEM_ACTIVATED(LC, ClassSelectDlg::OnDClickActivated)
END_EVENT_TABLE()

ClassSelectDlg::ClassSelectDlg (wxWindow* parent)
  : wxDialog(parent,-1, wxString(_("Class selection")),
	     wxDefaultPosition, wxDefaultSize,
	     wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER),
    selected(0)
{
  this->listDisplay = getListCtrl(LC);
  this->listDisplay->SetToolTip(_("Choose the class that you would like to continue with"));
  this->dataDisplay = new LessonStatusSizer(this);
  this->btnSel = new wxButton(this,SEL_B, _("Load class"));
  this->btnNew = new wxButton(this,NEW_B, _("New class"));
  this->btnCancel = new wxButton(this,wxID_CANCEL, _("Cancel"));

  this->sb = new wxStaticBox(this, -1, _("Statistics"));
  wxStaticBoxSizer* sbSizer = new wxStaticBoxSizer(sb,wxVERTICAL);
  sbSizer->Add(this->dataDisplay);

  wxBoxSizer* subSizer = new wxBoxSizer(wxHORIZONTAL);
  subSizer->Add(this->listDisplay,1,wxEXPAND);
  subSizer->Add(new wxStaticLine(this,-1,wxDefaultPosition,
				 wxDefaultSize,wxLI_VERTICAL),
		0,wxEXPAND|wxLEFT|wxRIGHT,10);
  subSizer->Add(sbSizer,0,wxALIGN_CENTRE);


  wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
  buttonSizer->Add(this->btnSel,1,wxEXPAND|wxALIGN_CENTER|wxRIGHT,10);
  buttonSizer->Add(this->btnNew,1,wxEXPAND|wxALIGN_CENTER|wxRIGHT,10);
  buttonSizer->Add(this->btnCancel,1,wxEXPAND|wxALIGN_CENTER);

  wxBoxSizer* topSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(subSizer,1,wxEXPAND|wxALL,10);
  topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND|wxLEFT|wxRIGHT,10);
  topSizer->Add(buttonSizer,0,wxALIGN_CENTRE|wxALL,10);

  if (this->entries->size() > 0) {
    this->listDisplay->SetItemState(0,wxLIST_STATE_SELECTED,
				    wxLIST_STATE_SELECTED);
  }

  topSizer->SetSizeHints(this);
  SetSizer(topSizer);
  Centre();
}

ClassSelectDlg::~ClassSelectDlg () {
  delete entries;
}

int ClassSelectDlg::ShowModal() {
  if (this->entries->size() == 0) {
    return NEW_B;
  } else {
    return wxDialog::ShowModal();
  }
}

void ClassSelectDlg::OnDClickActivated (wxListEvent& event) {
  this->selected = &(*this->entries)[event.GetIndex()];
  EndModal(SEL_B);
}

void ClassSelectDlg::OnButtonActivated (wxCommandEvent& WXUNUSED(e)) {
  unsigned int i;
  for (i=0;i<this->entries->size();++i) {
    if (this->listDisplay->GetItemState(i,wxLIST_STATE_SELECTED) != 0) {
      this->selected=&(*this->entries)[i];
    }
  }  
  if (this->selected == 0) {
    ::wxLogError(_("No class selected!"));
  } else {
    EndModal(SEL_B);
  }
}

void ClassSelectDlg::OnSelection (wxListEvent& event) {
  this->selected = &(*this->entries)[event.GetIndex()];
  std::vector<LEntry>* results;
  results=TtConfigFile::getPtr()->loadKursDaten (this->selected->name,
						 this->selected->key);
  int richtig=0;
  int fehler=0;
  int zeit=0;
  unsigned int i;
  for (i=0; i < results->size(); ++i) {
    richtig += (*results)[i].getRichtig();
    fehler += (*results)[i].getFehler();
    zeit += (*results)[i].getZeit();
  }
  LEntry e(fehler,richtig,zeit);
  
  this->dataDisplay->setStatus(e);
  delete results;
  event.Skip();
}

void ClassSelectDlg::OnNewClass (wxCommandEvent& WXUNUSED(e)) {
  this->selected=0;
  EndModal(NEW_B);
}

wxListCtrl* ClassSelectDlg::getListCtrl (int id) {
  wxListCtrl* listingCtrl;
  listingCtrl = new wxListCtrl(this,id,
			       wxDefaultPosition,
			       wxDefaultSize,
			       wxLC_REPORT
			       |wxLC_VRULES
			       |wxLC_SINGLE_SEL
			       |wxSUNKEN_BORDER);
  wxListItem item;
  item.m_mask = wxLIST_MASK_TEXT;
  //inserting the column headers
  item.m_text = _("class");
  listingCtrl->InsertColumn(0,item);
  item.m_text = _("lesson");
  listingCtrl->InsertColumn(1,item);

  this->entries = TtConfigFile::getPtr()->getKursList();
  std::vector<KursName>::const_iterator runner;
  long index = 0;
  item.m_mask = wxLIST_MASK_TEXT|wxLIST_MASK_FORMAT;
  item.m_format=wxLIST_FORMAT_LEFT;
  wxListItem item2;
  item2.m_mask = wxLIST_MASK_TEXT|wxLIST_MASK_FORMAT;
  item2.m_format=wxLIST_FORMAT_RIGHT;
  item2.m_col=1;
  wxString s;
  int i = 0;
  KursName* k;
  std::vector<LEntry>* lentry;
  for (runner=this->entries->begin();runner<this->entries->end();++runner) {
    item.m_text=runner->name;
    if (i%2) {
      item.SetBackgroundColour(*wxLIGHT_GREY);
      item2.SetBackgroundColour(*wxLIGHT_GREY);
    } else {
      item.SetBackgroundColour(listingCtrl->GetBackgroundColour());
      item2.SetBackgroundColour(listingCtrl->GetBackgroundColour());
    }
    item.m_itemId=i;
    index=listingCtrl->InsertItem(item);
    if (index!=-1) {
      item2.m_itemId=index;
      k= &(*this->entries)[i++];
      s.Empty();
      lentry=TtConfigFile::getPtr()->loadKursDaten(k->name,k->key);
      s << lentry->size()+1;
      delete lentry;
      item2.m_text=s;
      listingCtrl->SetItem(item2);
    }
  }

  //setting the column widths
  listingCtrl->SetColumnWidth(0,wxLIST_AUTOSIZE);
  listingCtrl->SetColumnWidth(1,wxLIST_AUTOSIZE_USEHEADER);

  //setting the control's width
  wxSize listingSize = listingCtrl->GetSize();
  int viewRows = 10;
  if (listingCtrl->GetItemCount() <= viewRows) {
    listingSize.SetWidth(listingSize.GetWidth()
			 - wxSystemSettings::GetMetric(wxSYS_VSCROLL_X));
    viewRows = listingCtrl->GetItemCount();
  }
  for (i=0;i<listingCtrl->GetColumnCount();++i) {
    listingSize.SetWidth(listingSize.GetWidth()
#ifdef __WXMSW__
                         +2
#endif
                         +listingCtrl->GetColumnWidth(i));
  }
  listingCtrl->SetSize(listingSize);

  //setting the control's height
  while (listingCtrl->GetCountPerPage() < viewRows){
    listingSize.SetHeight(listingSize.GetHeight()+2);
    listingCtrl->SetSize(listingSize);
  }

  return listingCtrl;
}
