/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ContestWizard.H"
#include "commonElements.H"
#include "Contest.H"

ContestWizard::ContestWizard(wxWindow* parent, const wxString& title,
			     UrlFile* picture, UrlFile* text)
  : wxWizard()
{
  wxString wtitle = _("Tipptrainer contest");
  if (title.Len()) {
    wtitle += _T(": ") + title;
  }

  if (picture!=0) {
    wxBitmap* bmp = common::getBitmap(*picture);
    if (bmp != 0) {
      Create(parent, -1, wtitle, *bmp);
    } else {
      ::wxLogError(_("Cannot load file %s"),picture->getFullFileName().c_str());
      Create(parent, -1, wtitle);
    }
  } else {
    Create(parent, -1, wtitle);
  }

  this->p1 = 0; //needed for a later check
  if (text != 0) {
    this->p1 = new wxWizardPageSimple(this);

    wxURL* u = text->getURL();
    wxInputStream* stream = common::getInputStream(*u);
    if (stream != 0) {
      wxString t = common::readTextAll(*stream,text->getCharset());
      delete stream;
      delete u;
      this->p1text = new wxTextCtrl(this->p1,-1,t,wxDefaultPosition,
				    wxSize(300,200),wxTE_READONLY|wxTE_MULTILINE);
      wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
      sizer->Add(this->p1text,1,wxEXPAND);
      this->p1->SetSizer(sizer);
      sizer->SetSizeHints(this->p1);
    } else {
      ::wxLogError(_("Cannot load file %s"),text->getFullFileName().c_str());
      delete stream;
      delete u;
    }
  }
  this->p2 = new FullNameEnterPage(this);

  if (this->p1 != 0) {
    wxWizardPageSimple::Chain(this->p1, this->p2);
    FitToPage(this->p1);
  } else {
    FitToPage(this->p2);
  }
}

ContestWizard::~ContestWizard () {
  delete p1;
  delete p2;
}

bool ContestWizard::runWizard () {
  if (this->p1 != 0) {
    return RunWizard(this->p1);
  } else {
    return RunWizard(this->p2);
  }
}

wxString ContestWizard::getName () {
  return this->p2->GetName();
}

BEGIN_EVENT_TABLE(FullNameEnterPage,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,FullNameEnterPage::OnPageChanging)
END_EVENT_TABLE()

FullNameEnterPage::FullNameEnterPage (wxWizard* parent)
  : wxWizardPageSimple(parent)
{
  wxStaticText* text = new wxStaticText(this,-1,_("Please enter your name:"));

  wxStaticText* ftext = new wxStaticText(this,-1,_("first name:"));
  this->ftctrl = new wxTextCtrl(this, -1);
  wxStaticText* ltext = new wxStaticText(this,-1,_("last name:"));
  this->ltctrl = new wxTextCtrl(this, -1);

  wxFlexGridSizer* subSizer = new wxFlexGridSizer(2,2,10,10);
  subSizer->AddGrowableCol(1);
  subSizer->Add(ftext,0,wxALIGN_CENTRE_VERTICAL);
  subSizer->Add(ftctrl,0,wxEXPAND);
  subSizer->Add(ltext,0,wxALIGN_CENTRE_VERTICAL);
  subSizer->Add(ltctrl,0,wxEXPAND);

  wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
  pageSizer->Add(0,0,1);
  pageSizer->Add(text,0,wxBOTTOM,5);
  pageSizer->Add(subSizer,0,wxEXPAND);
  pageSizer->Add(0,0,1);

  SetSizer(pageSizer);
  pageSizer->SetSizeHints(this);
}

wxString FullNameEnterPage::GetName () {
  wxString s;
  s << this->firstname
    << _T(" ")
    << this->lastname;
  s.Replace(_T("\""),_T(""));
  return s;
}

void FullNameEnterPage::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->ftctrl->GetValue() == _T("") ||
	this->ltctrl->GetValue() == _T("")) {
      wxMessageBox(_("Your have to enter a name!"),
		   _("Important"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->firstname = this->ftctrl->GetValue();
      this->firstname.Trim(true);
      this->firstname.Trim(false);
      this->lastname = this->ltctrl->GetValue();
      this->lastname.Trim(true);
      this->lastname.Trim(false);
      return;
    }
  } else {
    return;
  }
}
