/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "LEntry.H"
#include "LKrit.H"

LEntry::LEntry (int fehler, int richtig, int zeit) {
  this->falsch = fehler;
  this->richtig = richtig;
  this->zeit = zeit;
  this->line = 0;
  this->line = 0;
}

void LEntry::setZeit(const wxString& zeit) {
  if (zeit.Freq(':')==2) {
    long hours;
    (zeit.BeforeFirst(':')).ToLong(&hours);
    long minutes;
    ((zeit.AfterFirst(':')).BeforeFirst(':')).ToLong(&minutes);
    long seconds;
    (zeit.AfterLast(':')).ToLong(&seconds);
    setZeit((time_t)(hours*60*60 + minutes*60 + seconds));
  }
}

double LEntry::getPromille() const {
  if (getAnschlaege() > 0) {
    return ((double)getFehler() / (double)getAnschlaege()) * 1000.0;
  } else {
    /* There is a problem here: if nothing was typed, it is either
     * totally correct (0.0) or totally incorrect (1000.0). We favour
     * those who did something, so the latter is chosen.
     */
    return 1000.0;
  }
}

double LEntry::getApM() const {
  if (getZeit() > 0) {
    return ((double)(getAnschlaege()*60))/(double)getZeit();
  } else {
    return 0.0;
  }
}

bool operator> (const LEntry& entry, const LKrit& krit) {
  return (entry.getPromille() > krit.getPromille() ||
	  (krit.getZeit() > 0 && entry.getZeit() > krit.getZeit()));
}

bool operator<= (const LEntry& entry, const LKrit& krit) {
  return !(entry>krit);
}
