/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LESSONCONTROLLER_H
#define LESSONCONTROLLER_H

#include <wx/event.h>

/* Warning: there was no real wx documentation to the code below
 * It was created by using wxWiki and the event example and some
 * usenet group chatting :)
 */
//this defines the event type, assigned in the .cpp file
extern const wxEventType ttLESSON_START;
//make the event table makro easier
#define LESSON_START(id, fn) DECLARE_EVENT_TABLE_ENTRY(ttLESSON_START, \
                                                       id, -1, \
                                                       (wxObjectEventFunction) \
                                                       (wxEventFunction) \
                                                       (wxCommandEventFunction) &fn, \
                                                       (wxObject*) NULL),
//derive from wxEvent to create a new event and connect
//to the event type from above
class ttLessonStartEvent : public wxEvent {
public:
  ttLessonStartEvent (int id) : wxEvent(id,ttLESSON_START) {};
  //this is the example Clone implementation from wx documentation
  wxEvent* Clone(void) const { return new ttLessonStartEvent(*this); };
};

extern const wxEventType ttLESSON_ABORT;
#define LESSON_ABORT(id, fn) DECLARE_EVENT_TABLE_ENTRY(ttLESSON_ABORT, \
                                                       id, -1, \
                                                       (wxObjectEventFunction) \
                                                       (wxEventFunction) \
                                                       (wxCommandEventFunction) &fn, \
                                                       (wxObject*) NULL),
class ttLessonAbortEvent : public wxEvent {
public:
  ttLessonAbortEvent (int id) : wxEvent(id,ttLESSON_ABORT) {};
  wxEvent* Clone(void) const { return new ttLessonAbortEvent(*this); };
};

extern const wxEventType ttLESSON_FINISH;
#define LESSON_FINISH(id, fn) DECLARE_EVENT_TABLE_ENTRY(ttLESSON_FINISH, \
                                                       id, -1, \
                                                       (wxObjectEventFunction) \
                                                       (wxEventFunction) \
                                                       (wxCommandEventFunction) &fn, \
                                                       (wxObject*) NULL),
class ttLessonFinishEvent : public wxEvent {
public:
  ttLessonFinishEvent (int id) : wxEvent(id,ttLESSON_FINISH) {};
  wxEvent* Clone(void) const { return new ttLessonFinishEvent(*this); };
};

class Lektion;

class LessonController : public wxEvtHandler {
public:
  LessonController ();
  bool runningLesson();
  Lektion* getLesson () { return lesson; };

  wxString getType () { return controllerName; };

  //call these to process tt*Event and catch it
  //with an event table entry
  //LESSON_* (id, function)

  //WARNING: This one is called by class Lektion during constructor processing.
  //         The pointer that you use in your class is NOT valid at that time!
  virtual void pushStartEvent(int id);
  //The two below can use the pointer safely.
  virtual void pushAbortEvent(int id);
  virtual void pushFinishEvent(int id);

  // Exception for an abort in constructor
  class Abbruch{};

protected:
  Lektion* lesson;
  wxString controllerName;

};

#endif
