# $Id: taskbar.tcl,v 1.16 2006/02/09 20:08:51 aleksey Exp $

# MS Windows taskbar and tray icon support.
# Requires Winico package
# (http://tktable.sourceforge.net/winico/winico.html)

##########################################################################

if {![cequal $::interface tk]} return

if {[catch { package require Winico }]} return

##########################################################################

namespace eval taskbar {
    variable s2p
    array set s2p [list blank       0 \
			available   1 \
			away	    2 \
			chat	    3 \
			dnd	    4 \
			xa	    5 \
		        unavailable 6 \
			invisible   7 \
			browser     8 \
			group       9 \
			browser32   10 \
			group32     11 \
			available32 12 \
			message1    13 \
			message2    14 \
			message3    15]

    variable options

    custom::defvar options(enable) 1 \
	[::msgcat::mc "Enable windows tray icon."] \
	-group Systray -type boolean \
	-command [namespace code enable_disable]
}

##########################################################################
#
# Systray icons
#
##########################################################################

proc taskbar::set_current_theme {} {
    variable icon

    if {[info exists icon]} return

    set icon [winico createfrom [pixmaps::get_filename docking/tkabber]]
}

hook::add set_theme_hook [namespace current]::taskbar::set_current_theme

##########################################################################

proc taskbar::enable_disable {args} {
    variable options

    set m .tray

    if {$options(enable) && ![winfo exists $m]} {
	ifacetk::systray::create $m \
	    -createcommand [namespace code create] \
	    -configurecommand [namespace code configure] \
	    -destroycommand [namespace code destroy]
    } elseif {!$options(enable) && [winfo exists $m]} {
	ifacetk::systray::destroy $m
    }
}

hook::add finload_hook [namespace current]::taskbar::enable_disable

##########################################################################

proc taskbar::create {m} {
    variable icon
    variable s2p

    set m [ifacetk::systray::popupmenu .tray]

    winico taskbar add $icon -pos $s2p(unavailable) \
	   -callback [list [namespace code callback] $m %m %x %y] \
	   -text [ifacetk::systray::balloon_text]
}

##########################################################################

proc taskbar::configure {m status} {
    variable icon
    variable s2p

    winico taskbar modify $icon -pos $s2p($status) \
	   -text [ifacetk::systray::balloon_text]
}

##########################################################################

proc taskbar::destroy {m} {
    variable icon

    if {![cequal $icon ""]} {
	winico taskbar delete $icon
	::destroy $m
    }
}

##########################################################################

proc taskbar::callback {m event x y} {
    switch -- $event {
	WM_LBUTTONUP {
	    ifacetk::systray::toggle_state
	}

	WM_RBUTTONUP {
	    $m post $x $y
	}
    }
}

##########################################################################
#
# Window & taskbar icons
#
##########################################################################

proc taskbar::win_icons {} {
    variable icon
    variable s2p

    winico setwindow . $icon small $s2p(unavailable)
    winico setwindow . $icon big $s2p(available32)

    trace variable ::curuserstatus w [namespace code update]

    foreach tag [list Toplevel Chat JBrowser JDisco] {
	bind $tag <Map> \
	     [list [namespace code win_icon_setup] %W $tag]
    }
}

hook::add finload_hook [namespace current]::taskbar::win_icons

##########################################################################

proc taskbar::win_icon_setup {w tag} {
    variable icon
    variable s2p

    if {[cequal $icon ""]} return
    if {[winfo toplevel $w] != $w} return

    switch -- $tag {
	Chat {
	    winico setwindow $w $icon small $s2p(group)
	    winico setwindow $w $icon big $s2p(group32)
	}
	JBrowser -
	JDisco {
	    winico setwindow $w $icon small $s2p(browser)
	    winico setwindow $w $icon big $s2p(browser32)
	}
	default {
	    winico setwindow $w $icon small $s2p(available)
	    winico setwindow $w $icon big $s2p(available32)
	}
    }
}

##########################################################################

proc taskbar::update {name1 {name2 ""} {op ""}} {
    global curuserstatus
    variable icon
    variable s2p

    winico setwindow . $icon small $s2p($curuserstatus)
}

##########################################################################

