/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gsim.h"

#define BUF_Z	0
#define BUF_I	1

#define BUF_DELAY 0 

static void Buf_processEvent(SGate*,EvQueue*,SEvent*);
static int Buf_checkGate(SGate *g);

static SGateInfo buf_info = {
  0,
  "buf:not",0x1,
  2,{{"Z",GIO_OUT,0},
       {"I",GIO_IN,0}},
  {{"I-Z",bit(1),0},0},

  Generic_copyGate,
  Buf_processEvent,
  Buf_checkGate,
  Nop_initGate,
  Generic_setProp,
  0,
  0,
  Generic_propFrwdDelay,
  Generic_propBackDelay,
  Generic_delay,
};

void init_buf()
{
  SGateInfo_register(&buf_info,0);
}


static void Buf_processEvent(SGate *g,EvQueue *Q,SEvent *E)
{
  SPort *Z   = g->g_ports.port[BUF_Z];
  SState *iS = SGate_allocPortState(g,BUF_I);
  SState *S = alloc_SState();

 SState_reinit(S,Z->p_state.nbits);
  SState_buf(S,iS);
  SState_expandExtend(S,Z->p_net->n_nbits);

  EvQueue_setPort(Q,Z,S,g->g_delayParms[BUF_DELAY]);

  free_SState(iS);
  free_SState(S);
}

int Buf_checkGate(SGate *g)
{
  if (g->g_ports.num != 2) {
    errorGate(g->g_name,"%s gates should have exactly two pins.",g->g_type->gi_name);
    return -1;
  }

  return 0;
}
