/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: bicc.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------
// Branch on Integer Condition Instruction -
//    see p178 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------


#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::branch_icc (const Instruction& inst) {
    int eval_icc; 

    switch (inst.cond()) {   
    case Instruction:: NE: 
	eval_icc = (IU_Z == 0) ? 1 : 0;
	break;

    case Instruction:: E: 
	eval_icc = (IU_Z == 1) ? 1 : 0;
	break;

    case Instruction:: G: 
	eval_icc = ((IU_Z | (IU_N ^ IU_V)) == 0) ? 1 : 0;
	break;

    case Instruction:: LE:
	eval_icc = ((IU_Z | (IU_N ^ IU_V)) == 1) ? 1 : 0;
	break;

    case Instruction:: GE:
	eval_icc = ((IU_N ^ IU_V) == 0) ? 1 : 0;
	break;

    case Instruction:: L:
	eval_icc = ((IU_N ^ IU_V) == 1) ? 1 : 0;
	break;

    case Instruction:: GU:
	eval_icc = ((IU_C == 0) && (IU_Z == 0)) ? 1 : 0;
	break;

    case Instruction:: LEU:
	eval_icc = ((IU_C == 1) || (IU_Z == 1)) ? 1 : 0;
	break;

    case Instruction:: CC:
	eval_icc = (IU_C == 0) ? 1 : 0;
	break;

    case Instruction:: CS:
	eval_icc = (IU_C == 1) ? 1 : 0;
	break;

    case Instruction:: POS:
	eval_icc = (IU_N == 0) ? 1 : 0;
	break;

    case Instruction:: NEG:
	eval_icc = (IU_N == 1) ? 1 : 0;
	break;

    case Instruction:: VC:
	eval_icc = (IU_V == 0) ? 1 : 0;
	break;

    case Instruction:: VS:
	eval_icc = (IU_V == 1) ? 1 : 0;
	break;

    case Instruction:: A:
	eval_icc = 1;
	break;

    case Instruction:: N:
	eval_icc = 0;
	break;

    default:            
	Assert(0, "Unknown integer condition: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }

    UInt32 tempIU_PC = IU_PC;    // save for use in displacement calc for IU_nPC

    IU_PC = IU_nPC;          
    
    if (eval_icc == 1) {
        Int32 disp22 = inst.disp22() << 2;

	if ((disp22 & 0x00800000) != 0)    // sign extended if necessary
	    disp22 |= 0xff000000;

	IU_nPC = tempIU_PC + disp22;       
	
	if ((inst.cond() == Instruction::A) && (inst.a() == 1))           
	    IU_annul = 1;
    }
    else {
	IU_nPC = IU_nPC + 4;
	if (inst.a() == 1) {
	    IU_annul = 1;
	}
    }
}
