// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef WORD_SEG_MEASURER_INC
#define WORD_SEG_MEASURER_INC

#include "Measurer.h"
#include "SpeechHMM.h"

namespace Torch {

/** This class can be used to save the word segmentation of a #SpeechHMM#
    in a file. Optionally, it also prints the corresponding target segmentation.

    @author Samy Bengio (bengio@idiap.ch)
*/
class WordSegMeasurer : public Measurer
{
  public:
    /// the pointer to the SpeechHMM object
    SpeechHMM *shmm;

    /// a boolean stating whether we also print the corresponding targets
    bool print_targets;

    ///
    WordSegMeasurer(SpeechHMM* shmm_, DataSet *data_, FILE *file_, bool print_targets=true);
    ///
    WordSegMeasurer(SpeechHMM* shmm_, DataSet *data_, const char *filename, bool print_targets=true);

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~WordSegMeasurer();
};


}

#endif
