// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "LogSoftmax.h"
#include "log_add.h"

namespace Torch {

LogSoftmax::LogSoftmax(int n_units)
{
  n_inputs = n_units;
  n_outputs = n_units;
}

int LogSoftmax::numberOfParams()
{
  return(0);
}

void LogSoftmax::forward(List *inputs)
{
  real *ptr_out = (real *)outputs->ptr;
  real sum = LOG_ZERO;
  while(inputs)
  {
    real *x = (real *)inputs->ptr;
    for(int j = 0; j < inputs->n; j++)
    {
      real z = *x++;
      *ptr_out++ = z;
      sum = log_add(sum, z);
    }
    inputs = inputs->next;
  }

  ptr_out = (real *)outputs->ptr;
  for(int i = 0; i < n_outputs; i++)
    *ptr_out++ -= sum;
}

void LogSoftmax::backward(List *inputs, real *alpha)
{
  real *ptr_alpha = alpha;
  real sum = 0;
  for(int i = 0; i < n_outputs; i++)
    sum += *ptr_alpha++;

  ptr_alpha = alpha;
  real *ptr_outputs = (real *)outputs->ptr;
  real *ptr_beta = beta;
  for(int i = 0; i < n_outputs; i++)
    *ptr_beta++ = *ptr_alpha++ - exp(*ptr_outputs++) * sum;
}

LogSoftmax::~LogSoftmax()
{
}

}

