// Copyright (C) 2002 Johnny Mariethoz (Johnny.Mariethoz@idiap.ch)
//                and Samy Bengio (bengio@idiap.ch)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef STRING_UTILS_INC
#define STRING_UTILS_INC

#include <string.h>

namespace Torch {

/** Some simple functions for string operations.

    @author Samy Bengio (bengio@idiap.ch)
    @author Johnny Mariethoz (Johnny.Mariethoz@idiap.ch)
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{
/** Returns the name of a file without leading pathname.
    (It's not a new string, but a pointer in the given string)
 */
char *strBaseName(char *filename);

/** Returns a fresh copy of the name of a file without suffix.
    (Trailing chars after c) You have to free the memory!
*/
char *strRemoveSuffix(char *filename, char c='.');

/** Returns the concatenation #n# strings.
    The strings are the parameters given after #n#;
    You have to free the memory!
*/
char *strConcat(int n, ...);

//@}

}

#endif
