#include "tra.h"

/* BUG: there is a copy of this in replthread */
Buf*
replread(Replica *r)
{
	uchar hdr[4];
	int n, nn;
	Buf *b, *bb;

	if(r->err){
	Error:
		werrstr("%s", r->err);
		return nil;
	}

	if(readn(r->rfd, hdr, 4) != 4){
		r->err = "eof reading input";
		goto Error;
	}

	n = LONG(hdr);
	if(n < 6){
		r->err = "short rpc packet";
		goto Error;
	}
	if(n > 1*1024*1024){
		r->err = "implausible rpc packet";
		goto Error;
	}

	b = mkbuf(nil, n);
	if(readn(r->rfd, b->p, n) != n){
		r->err = "eof reading input";
		goto Error;
	}

	// dbg(DbgRpc, "replread %.*H\n", (int)(b->ep-b->p), b->p);
	if(r->inflate){
		inzrpctot += b->ep - b->p;
		nn = readbufl(b);
		if(nn > 1*1024*1024){
			r->err = "implausible rpc packet";
			goto Error;
		}
		bb = mkbuf(nil, nn);
		// dbg(DbgRpc, "inflate %.*H\n", (int)(b->ep-b->p), b->p);
		if(inflateblock(r->inflate, bb->p, nn, b->p, b->ep-b->p) != nn){
			r->err = "error decompressing block";
			goto Error;
		}
		free(b);
		b = bb;
	}
	inrpctot += b->ep - b->p;
	return b;
}

int
replwrite(Replica *r, Buf *b)
{
	int n, nn;
	uchar hdr[8];
	Buf *bb;

	n = b->ep - b->p;
	bb = nil;
	outrpctot += n;
	if(r->deflate){
		// dbg(DbgRpc, "deflate %.*H\n", (int)(b->ep-b->p), b->p);
		bb = mkbuf(nil, n+128);
		writebufl(bb, n);
		nn = deflateblock(r->deflate, bb->p, bb->ep-bb->p, b->p, n);
		if(nn < 0){
			r->err = "error compressing block";
			return -1;
		}
		bb->ep = bb->p+nn;
		bb->p -= 4;
		b = bb;
		// dbg(DbgRpc, " => %.*H\n", (int)(b->ep-b->p), b->p);
		n = b->ep - b->p;
		outzrpctot += n;
	}
	PLONG(hdr, n);
	if(write(r->wfd, hdr, 4) != 4
	|| write(r->wfd, b->p, n) != n){
		free(bb);
		r->err = "write error";
		return -1;
	}
	free(bb);
	return 0;
}

void
replclose(Replica *r)
{
	close(r->rfd);
	if(r->rfd != r->wfd)
		close(r->wfd);
	free(r);
}

Replica*
fd2replica(int fd0, int fd1)
{
	Replica *repl;

	repl = emalloc(sizeof(Replica));
	repl->rfd = fd0;
	repl->wfd = fd1;
	return repl;
}

