#include "tra.h"

Replica *repl;

static Path*
strtopath(char *s)
{
	char *f[20];
	int i, nf;
	Path *p;

	nf = getfields(s, f, nelem(f), 1, "/");
	p = nil;
	for(i=0; i<nf; i++)
		p = mkpath(p, f[i]);
	return p;
}

void
usage(void)
{
	fprint(2, "usage: scan replica [path...]\n");
	exits("usage");
}

void
threadmain(int argc, char **argv)
{
	int i;

	fmtinstall('H', encodefmt);
	fmtinstall('P', pathfmt);
	fmtinstall('$', statfmt);
	fmtinstall('V', vtimefmt);

	ARGBEGIN{
	default:
		usage();
	}ARGEND

	if(argc < 1)
		usage();

	startclient();
	repl = dialreplica(argv[0]);
	threadcreate(replthread, repl);
	
	argc--;
	argv++;
	if(argc == 0){
		if(rpcstat(repl, nil) == nil)
			sysfatal("rpcstat: %s", rpcerror());
	}else{
		for(i=0; i<argc; i++)
			if(rpcstat(repl, strtopath(argv[i])) == nil)
				sysfatal("rpcstat: %s", rpcerror());
	}
	rpchangup(repl);
	replclose(repl);
	exits(nil);
}

