#include "tra.h"

/* XXX: change to use Fdbuf's ? */

enum
{
	BUFSZ = (1<<15)
};

static int
copy(int from, int to, int n)
{
	static char buf[BUFSZ];

	if(n > BUFSZ)
		return -1;

	if(readn(from, buf, n) != n)
		sysfatal("readn: %r");
	if(writen(to, buf, n) != n)
		sysfatal("writen: %r");

	return 0;
}

static void
usage(void)
{
	fprint(2, "usage: stdsplit\n");
}

int
main(int argc, char *argv[])
{
	int n, w, err=0;
	char *p, buf[6];

	if(argc != 1){
		usage();
		return 1;
	}

	memset(buf, 0, sizeof(buf));
	for(;;){
		if(err){
			err = 0;
			memmove(buf, buf+1, 4);
			if(readn(0, buf+4, 1) != 1)
				break;
		}else if(readn(0, buf, 5) != 5)
			break;

		switch(buf[0]){
		case 'o':
			w = 1;
			break;

		case 'e':
			w = 2;
			break;

		default:
			err = 1;
			continue;
		}
		n = strtol(buf+1, &p, 16);
		if(*p != '\0' || copy(0, w, n) < 0)
			err = 1;
	}

	return 0;
}
