#include "tra.h"

Db *db;

static char*
cmdgetmeta(int argc, char **argv)
{
	char *s;
	static char buf[ERRMAX];

	if(argc != 1)
		return "usage: getmeta key";

	if(db == nil)
		return "not open";

	s = dbgetmeta(db, argv[0]);
	if(s == nil){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	print("%s\n", s);
	free(s);
	return nil;
}

static char*
cmdputmeta(int argc, char **argv)
{
	static char buf[ERRMAX];

	if(argc != 2)
		return "usage: putmeta key ptr";

	if(db == nil)
		return "not open";

	if(dbputmeta(db, argv[0], argv[1]) < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmddelmeta(int argc, char **argv)
{
	static char buf[ERRMAX];
	if(argc != 1)
		return "usage: delmeta key";

	if(db == nil)
		return "not open";

	if(dbdelmeta(db, argv[0]) < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmdgetstat(int argc, char **argv)
{
	char *p[16];
	int np;
	Stat *s;
	static char buf[ERRMAX];

	if(argc != 1)
		return "usage: getstat path";

	if(db == nil)
		return "not open";

	np = getfields(argv[0], p, nelem(p), 1, "/");
	np = dbgetstat(db, p, np, &s);
	if(np < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	print("%d: %s %V\n", np, s->uid, s->synctime);
	freestat(s);
	return nil;
}

static char*
cmdgetkids(int argc, char **argv)
{
	char *p[16];
	int i, nk, np;
	Kid *k;
	static char buf[ERRMAX];

	if(argc != 1)
		return "usage: getkids path";

	if(db == nil)
		return "not open";

	np = getfields(argv[0], p, nelem(p), 1, "/");
	nk = dbgetkids(db, p, np, &k);	
	if(nk < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	print("%d kids\n", nk);
	for(i=0; i<nk; i++)
		print("\t%s: %s %V\n", k[i].name, k[i].stat->uid, k[i].stat->synctime);
	return nil;
}

Vtime*
getvtime(char *s)
{
	char *f[16], *g[3];
	int i, nf;
	Vtime *v;

	nf = getfields(s, f, nelem(f), 0, ",");
	v = emalloc(sizeof(*v));
	v->nl = nf;
	v->l = emalloc(nf*sizeof(v->l[0]));
	for(i=0; i<nf; i++){
		if(getfields(f[i], g, 3, 0, ":") != 2){
			free(v->l);
			free(v);
			return nil;
		}
		v->l[i].m = estrdup(g[0]);
		v->l[i].t = atoi(g[1]);
	}
	return v;
}

static char*
cmdputstat(int argc, char **argv)
{
	char *p[16];
	int np;
	static char buf[ERRMAX];
	Stat *s;

	if(argc != 3)
		return "usage: putstat path uid time";

	if(db == nil)
		return "not open";

	s = mkstat();
	s->state = SDir;
	if(strcmp(argv[1], "ghost") == 0)
		s->state = SNonexistent;
	else
		s->uid = estrdup(argv[1]);
	freevtime(s->synctime);
	s->synctime = getvtime(argv[2]);
	if(s->synctime == nil){
		freestat(s);
		return "bad time";
	}
	np = getfields(argv[0], p, nelem(p), 1, "/");
	if(dbputstat(db, p, np, s) < 0){
		freestat(s);
		rerrstr(buf, sizeof buf);
		return buf;
	}
	freestat(s);
	return nil;
}

/*
static char*
cmddelstat(int argc, char **argv)
{
	char *p[16];
	int np;
	static char buf[ERRMAX];

	if(argc != 1)
		return "usage: delstat key";

	if(db == nil)
		return "not open";

	np = getfields(argv[0], p, nelem(p), 1, "/");
	if(dbdelstat(db, p, np) < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}
*/

/*
static char*
cmdshow(int argc, char**)
{
	if(argc != 0)
		return "usage: show";

	if(map == nil)
		return "not open";

	map->dump(map, 1);
	return nil;
}
*/

static char*
cmdclose(int argc, char **argv)
{
	USED(argv);

	if(argc != 0)
		return "usage: close";

	if(db == nil)
		return "not open";

	closedb(db);
	db = nil;
	return nil;
}

static char*
cmdflush(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: flush";

	if(db == nil)
		return "not open";

	flushdb(db);
	db = nil;
	return nil;
}

static char*
cmdopen(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: open";

	if(db != nil)
		return "not closed";

	db = opendb("tmp.testdb");
	if(db==nil){
		fprint(2, "?%r\n");
		return nil;
	}
	db->alwaysflush = 1;
	return nil;
}

static char*
cmdreopen(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: reopen";

	if(db == nil)
		return "not open";

	cmdclose(0, nil);
	cmdopen(0, nil);
	return nil;
}

static char*
cmdnew(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: new";

	if(db)
		cmdclose(0, nil);
	remove("tmp.testdb");
	remove("tmp.testdb.redo");
	remove("tmp.testdb.redo2");
	db = createdb("tmp.testdb", 256);
	if(db==nil){
		fprint(2, "?%r\n");
		return nil;
	}
	db->alwaysflush = 1;
	return nil;
}

static char*
cmdshow(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: show";

	dumpdb(db, 1);
	return nil;
}

static struct {
	char *cmd;
	char *(*fn)(int, char**);
} tab[] = {
	{ "new",	cmdnew, },
	{ "close",	cmdclose, },
	{ "open",	cmdopen, },
	{ "reopen",	cmdreopen, },
	{ "getmeta",	cmdgetmeta, },
	{ "putmeta",	cmdputmeta, },
	{ "delmeta",	cmddelmeta, },
	{ "getstat",	cmdgetstat, },
	{ "putstat",	cmdputstat, },
	{ "getkids",	cmdgetkids, },
	{ "flush",	cmdflush, },
	{ "show",	cmdshow, },
};

void
threadmain(int argc, char **argv)
{
	int i, n;
	char *e, *tok[16], buf[512];

	USED(argc);
	USED(argv);

	fmtinstall('H', encodefmt);
	fmtinstall('P', pathfmt);
	fmtinstall('$', statfmt);
	fmtinstall('V', vtimefmt);

	for(;;){
		print(">>> ");
		n = read(0, buf, sizeof buf);
		if(n <= 0)
			exits(nil);
		buf[n-1] = '\0';
		n = tokenize(buf, tok, nelem(tok));
		if(n <= 0)
			continue;
		for(i=0; i<nelem(tab); i++)
			if(strcmp(tok[0], tab[i].cmd) == 0){
				e = tab[i].fn(n-1, tok+1);
				if(e)
					print("?%s\n", e);
				break;
			}
		if(i==nelem(tab))
			print("?unknown command\n");
	}	
}

int
config(char *s)
{
	USED(s);
	return 0;
}
