#include "tra.h"

int nb;
DBlock *b[10000];
DStore *s;

DBlock*
findblock(u32int addr, int remove)
{	
	int i;
	DBlock *x;

	for(i=0; i<nb; i++){
		if(b[i]->addr == addr){
			x = b[i];
			if(remove)
				b[i] = b[--nb];
			return x;
		}
	}
	return nil;
}

void
addblock(DBlock *x)
{
	b[nb++] = x;
}

static char*
cmdclose(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: close";

	if(s == nil)
		return "not open";

	s->close(s);
	s = nil;
	return nil;
}

static char*
cmdfree(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: free";

	if(s == nil)
		return "not open";

	s->free(s);
	s = nil;
	return nil;
}

static char*
cmdflush(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: flush";

	if(s == nil)
		return "not open";

	s->flush(s);
	return nil;
}

static char*
cmdopen(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: open";

	if(s != nil)
		return "not closed";

	s = opendstore("tmp.testdb");
	return nil;
}

static char*
cmdreopen(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: reopen";

	if(s == nil)
		return "not open";

	cmdclose(0, nil);
	cmdopen(0, nil);
	return nil;
}

static char*
cmdnew(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: new";

	if(s)
		s->close(s);
	remove("tmp.testdb");
	remove("tmp.testdb.redo");
	s = createdstore("tmp.testdb", 256);
	return nil;
}

static char*
cmdalloc(int argc, char **argv)
{
	DBlock *b;
	u32int size;

	if(argc != 1)
		return "usage: alloc size";
	if(s == nil)
		return "no store";

	size = strtol(argv[0], 0, 0);
	b = s->alloc(s, size);
	if(b == nil)
		print("?%r\n");
	else{
		print("0x%ux\n", b->addr);
		addblock(b);
		memset(b->a, 'a', b->n);
	}
	return nil;
}

static char*
cmdread(int argc, char **argv)
{
	u32int addr;
	DBlock *b;

	if(argc != 1)
		return "usage: read addr";
	if(s == nil)
		return "no store";

	addr = strtol(argv[0], 0, 0);
	b = s->read(s, addr);
	if(b == nil)
		print("?%r\n");
	else{
		print("0x%ux\n", b->addr);
		addblock(b);
	}
	return nil;
}

static char*
cmdblockflush(int argc, char **argv)
{
	u32int addr;
	DBlock *b;

	if(argc != 1)
		return "usage: read addr";
	if(s == nil)
		return "no store";

	addr = strtol(argv[0], 0, 0);
	b = findblock(addr, 0);
	if(b == nil)
		return "block not held";
	b->flush(b);
	return nil;
}

static char*
cmdblockclose(int argc, char **argv)
{
	u32int addr;
	DBlock *b;

	if(argc != 1)
		return "usage: read addr";
	if(s == nil)
		return "no store";

	addr = strtol(argv[0], 0, 0);
	b = findblock(addr, 1);
	if(b == nil)
		return "block not held";
	b->close(b);
	return nil;
}

static char*
cmdblockfree(int argc, char **argv)
{
	u32int addr;
	DBlock *b;

	if(argc != 1)
		return "usage: read addr";
	if(s == nil)
		return "no store";

	addr = strtol(argv[0], 0, 0);
	b = findblock(addr, 1);
	if(b == nil)
		return "block not held";
	b->free(b);
	return nil;
}


static struct {
	char *cmd;
	char *(*fn)(int, char**);
} tab[] =
{
	{ "new",	cmdnew, },
	{ "flush",	cmdflush, },
	{ "close",	cmdclose, },
	{ "alloc",	cmdalloc, },
	{ "read",	cmdread, },
	{ "free",	cmdfree, },
	{ "blockclose", cmdblockclose, },
	{ "blockfree",	cmdblockfree, },
	{ "blockflush", cmdblockflush, }
};

void
threadmain(int argc, char **argv)
{
	int i, n;
	char *e, *tok[16], buf[512];

	USED(argc);
	USED(argv);
	for(;;){
		print(">>> ");
		n = read(0, buf, sizeof buf);
		if(n <= 0)
			exits(nil);
		buf[n-1] = '\0';
		n = tokenize(buf, tok, nelem(tok));
		if(n <= 0)
			continue;
		for(i=0; i<nelem(tab); i++)
			if(strcmp(tok[0], tab[i].cmd) == 0){
				e = tab[i].fn(n-1, tok+1);
				if(e)
					print("?%s\n", e);
				break;
			}
		if(i==nelem(tab))
			print("?unknown command\n");
	}	
}
