#ifndef CTRAFSTATS_H
  #define CTRAFSTATS_H

#include <netinet/in.h>
#include <list.h>
#include <string>
class CTrafStatsList;
class CTrafStatsEntry {
friend class CTrafStatsList;
public:
	CTrafStatsEntry(	const struct in_addr source,
				int sport,
				const struct in_addr destination,
				int dport,
				char *timestamp,
				unsigned long amount);
	CTrafStatsEntry(const CTrafStatsEntry& copy);
	~CTrafStatsEntry();

	void print();
	struct in_addr source() const { return iSource; };
	struct in_addr destination() const { return iDestination; };
	int sport() const { return iSport; };
	int dport() const { return iDport; };
	char *timestamp() const { return iTimestamp; };
	unsigned long amount() const { return iAmount; };
	bool matches(const CTrafStatsEntry& match);
	CTrafStatsEntry& operator+=(const CTrafStatsEntry& addee);
	bool operator<(const CTrafStatsEntry& match);
	
	std::string asString() const;
	std::string asQuery() const;

private:

	struct in_addr iSource,iDestination;
	int iSport,iDport;
	unsigned long iAmount;
	char *iTimestamp;

};

inline CTrafStatsEntry& operator+(	const CTrafStatsEntry& lhs,
				const CTrafStatsEntry& rhs) 
		{return CTrafStatsEntry(lhs) += rhs;};

#endif
