/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* main.c by Gopal Narayanan
 * This file containes the main program.
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "transcalc.h"

/*
 * setup_status - this function sets up
 * the status window that indicates 
 * if parameter values are consistent with the 
 * calculated results
 */


/*GtkWidget *setup_status (trans_gui *tg)*/
void
setup_status (GtkWidget *parent,
			 trans_win *tr_win)
{

  /*  GtkWidget *frame; */
  /*  GtkWidget *status_win;*/
  gchar *textentry;

  /*allocate memory for textentry */
  if ((textentry = (char *) malloc(200*sizeof(char)))  == NULL){
    perror("help text error: malloc");
    return;
  }

  tr_win->status_frame = gtk_frame_new("Status");
  gtk_container_add (GTK_CONTAINER (parent), tr_win->status_frame);

  if (statusint == CONSISTENT) {
    sprintf(textentry,"Values are consistent");
  } else {
    sprintf(textentry,"Values are inconsistent");
  }

  tr_win->status = gtk_label_new(textentry);

  gtk_widget_set_usize(tr_win->status,200,-1);
  gtk_label_set_justify (GTK_LABEL (tr_win->status), GTK_JUSTIFY_LEFT);
  /*  gtk_entry_set_text (GTK_ENTRY (tr_win->status), textentry);*/
  gtk_container_add (GTK_CONTAINER (tr_win->status_frame), tr_win->status);
  gtk_widget_show (tr_win->status);
  gtk_widget_show (tr_win->status_frame);

  free(textentry);
  /*  return tr_win->status;*/

}
