#ifndef TTOS2VALS_H__
#define TTOS2VALS_H__

/* values defined for the usWeightClass field of the OS/2 table */
#define TT_FW_THIN        100 /* Thin                      */
#define TT_FW_EXTRALIGHT  200 /* Extra-light (Ultra-light) */
#define TT_FW_LIGHT       300 /* Light                     */
#define TT_FW_NORMAL      400 /* Normal (Regular)          */
#define TT_FW_MEDIUM      500 /* Medium                    */
#define TT_FW_SEMIBOLD    600 /* Semi-bold (Demi-bold)     */
#define TT_FW_BOLD        700 /* Bold                      */
#define TT_FW_EXTRABOLD   800 /* Extra-Bold (Ultra-bold)   */
#define TT_FW_BLACK       900 /* Black (Heavy)             */

/* values defined for the usWidthClass field of the OS/2 table */
#define TT_FWIDTH_ULTRA_CONDENSED 1 /* Ultra-condensed */
#define TT_FWIDTH_EXTRA_CONDENSED 2 /* Extra-condensed */
#define TT_FWIDTH_CONDENSED       3 /* Condensed       */
#define TT_FWIDTH_SEMI_CONDENSED  4 /* Semi-condensed  */
#define TT_FWIDTH_NORMAL          5 /* Medium (normal) */
#define TT_FWIDTH_SEMI_EXPANDED   6 /* Semi-expanded   */
#define TT_FWIDTH_EXPANDED        7 /* Expanded        */
#define TT_FWIDTH_EXTRA_EXPANDED  8 /* Extra-expanded  */
#define TT_FWIDTH_ULTRA_EXPANDED  9 /* Ultra-expanded  */

/* bit mask for fsSelection */
#define TT_SELECTION_ITALIC      (1 << 0) /* Font contains Italic characters,
					     otherwise they are upright. */
#define TT_SELECTION_UNDERSCORE  (1 << 1) /* Characters are underscored. */
#define TT_SELECTION_NEGATIVE    (1 << 2) /* Characters have their foreground
					     and background reversed. */
#define TT_SELECTION_OUTLINED    (1 << 3) /* Outline (hollow) characters,
					     otherwise they are solid. */
#define TT_SELECTION_STRIKEOUT   (1 << 4) /* Characters are overstruck. */
#define TT_SELECTION_BOLD        (1 << 5) /* Characters are emboldened. */
#define TT_SELECTION_REGULAR     (1 << 6) /* Characters are in the standard
					     weight/style for the font. */
#endif /* TTOS2VALS_H__ */
