# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# Author: Florian Evers <florian-evers@gmx.de>
# $Header: $

inherit eutils
 
DESCRIPTION="Amateur Radio VHF contest logbook"
HOMEPAGE="http://tucnak.nagano.cz/tucnak1en.html"
SRC_URI="http://tucnak.nagano.cz/${P}.tar.gz"
LICENSE="GPL-2"

SLOT="0"
KEYWORDS="~x86"
IUSE="sdl"

DEPEND="virtual/libc
	sdl? ( >=media-libs/libsdl-1.1.4 )"
RESTRICT="nomirror"

src_compile() {
        local myconf=""
	use sdl || myconf="${myconf} --disable-sdl"

	econf ${myconf} || die "econf failed"
	emake || die "emake failed"
}

src_install() {
	make DESTDIR=${D} install || die
}

pkg_postinst() {
	einfo "You can emerge the following additional packages:"
	einfo "  media-radio/tucnak1-data  : Graphics for tucnak1"
	einfo "  media-radio/cwdaemon      : A morse daemon"
	einfo "  media-radio/ssbd          : SSB daemon (voice keyer)"
}

