/*
   This program is free software; you can redistribute it and/or                                                        
   modify it under the terms of the GNU General Public License                                                          
   as published by the Free Software Foundation; either version                                                         
   2 of the License, or (at your option) any later version.                                                             
*/

#ifndef __HEADER_H
#define __HEADER_H


#include <glib.h>


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include "../config2.h"

#ifndef __USE_POSIX 
#define __USE_POSIX
#endif
#ifndef __USE_POSIX2
#define __USE_POSIX2
#endif
#ifndef __USE_MISC
#define __USE_MISC
#endif
#ifndef __USE_BSD
#define __USE_BSD
#endif

#ifdef HAVE_MATH_H
#include <math.h>
#endif
 
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <ctype.h>
#include <string.h>
#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "os_dep.h"

#ifdef TIME_WITH_SYS_TIME
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif
#else
#if defined(TM_IN_SYS_TIME) && defined(HAVE_SYS_TIME_H)
#include <sys/time.h>
#elif defined(HAVE_TIME_H)
#include <time.h>
#endif
#endif

#include <sys/stat.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#include <signal.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#else
#ifdef HAVE_NETINET_IN_SYSTEM_H
#include <netinet/in_system.h>
#endif
#endif
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif
#include <utime.h>

#include <pwd.h>
#include <grp.h>
#include <regex.h>


#ifdef HAVE_PTY_H
#include <pty.h>
#endif

#ifdef HAVE_SDL
#include <SDL.h>
#endif

#ifdef HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#endif

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#ifndef HAVE_UINT32_T
#if SIZEOF_CHAR == 4
typedef unsigned char uint32_t;
#elif SIZEOF_SHORT == 4
typedef unsigned short uint32_t;
#elif SIZEOF_INT == 4
typedef unsigned int uint32_t;
#elif SIZEOF_LONG == 4
typedef unsigned long uint32_t;
#elif defined(HAVE_LONG_LONG) && SIZEOF_LONG_LONG == 4
typedef unsigned long long uint32_t;
#else
#error You have no 32-bit integer type. Get in touch with reality.
#endif
#endif

#ifdef HAVE_LONG_LONG
#define longlong long long
#else
#define longlong long
#endif

/* integer type same size as void *   */
#undef vint
#if SIZEOF_SHORT == SIZEOF_VOID_P
typedef short vint;
#elif SIZEOF_INT == SIZEOF_VOID_P
typedef int vint;
#elif SIZEOF_LONG == SIZEOF_VOID_P
typedef long vint;
#elif defined(HAVE_LONG_LONG) && SIZEOF_LONG_LONG == SIZEOF_VOID_P
typedef long long vint;
#else
#error You have no integer type of size void *
#endif

#include <termios.h>

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include "os_depx.h"

#include "setup.h"
#include "interfaces.h"
#include "iarray.h"

#define DUMMY ((void *)-1L)


/* for BSD */
#ifndef SOUND_MIXER_LINE 
#define SOUND_MIXER_LINE 6
#endif

#ifndef SOUND_MIXER_MIC 
#define SOUND_MIXER_MIC 7
#endif

#ifndef HAVE_SOCKLEN_T
typedef unsigned int __socklen_t;
typedef __socklen_t socklen_t;
#define __socklen_t_defined
#endif


/* error.c */

extern int debug_type;
extern char *debug_filename;

void do_not_optimize_here(void *p);
void check_memory_leaks(void);
void error(char *, ...);
void debug_msg(char *, ...);
void int_error( char *, ...);

void init_debug(void);
void free_debug(void);
void dbg(char *m, ...);
void dbg_bcast(char *m, ...);
void dbg_sock(char *m, ...);
void dbg_recv(char *m, ...);
void dbg_send(char *m, ...);
void dbg_qsos(char *m, ...);

void sock_debug(int sock, char *m, ...);
void dbg_str_hash(GHashTable *hash);
extern int errline;
extern char *errfile;

#define internal errfile = __FILE__, errline = __LINE__, int_error
#define debug errfile = __FILE__, errline = __LINE__, debug_msg

/*#ifdef SPECIAL_MALLOC

void *sp_malloc(size_t);
void sp_free(void *);
void *sp_realloc(void *, size_t);

#define xmalloc sp_malloc
#define xfree sp_free
#define xrealloc sp_realloc

#else  */

#define xmalloc malloc
#define xfree free
#define xrealloc realloc

/*#endif*/

#ifdef LEAK_DEBUG

extern long mem_amount;
extern long last_mem_amount;

#ifndef LEAK_DEBUG_LIST
struct alloc_header {
    int size;
};
#else
struct alloc_header {
    struct alloc_header *next;
    struct alloc_header *prev;
    int size;
    int line;
    char *file;
    char *comment;
};
#endif

#define L_D_S ((sizeof(struct alloc_header) + 7) & ~7)

#endif

#ifdef LEAK_DEBUG

void *debug_mem_alloc(char *, int, size_t);
void debug_mem_free(char *, int, void *);
void *debug_mem_realloc(char *, int, void *, size_t);
void set_mem_comment(void *, char *, int);

#define mem_alloc(x) debug_mem_alloc(__FILE__, __LINE__, x)
#define mem_free(x) debug_mem_free(__FILE__, __LINE__, x)
#define mem_realloc(x, y) debug_mem_realloc(__FILE__, __LINE__, x, y)

#else

static inline void *mem_alloc(size_t size)
{
    void *p;
    if (!size) return DUMMY;
    if (!(p = malloc(size))) {
        error("ERROR: out of memory (malloc returned NULL)\n");
        return NULL;
    }
    return p;
}

static inline void mem_free(void *p)
{
    if (p == DUMMY) return;
    if (!p) {
        internal("mem_free(NULL)");
        return;
    }
    free(p);
}

static inline void *mem_realloc(void *p, size_t size)
{
    if (p == DUMMY) return mem_alloc(size);
    if (!p) {
        internal("mem_realloc(NULL, %d)", size);
        return NULL;
    }
    if (!size) {
        mem_free(p);
        return DUMMY;
    }
    if (!(p = realloc(p, size))) {
        error("ERROR: out of memory (realloc returned NULL)\n");
        return NULL;
    }
    return p;
}

static inline void *debug_mem_alloc(char *f, int l, size_t s) { return mem_alloc(s); }
static inline void debug_mem_free(char *f, int l, void *p) { mem_free(p); }
static inline void *debug_mem_realloc(char *f, int l, void *p, size_t s) { return mem_realloc(p, s); }
static inline void set_mem_comment(void *p, char *c, int l) {}

#endif

static inline char upcase(char a)
{
    if (a>='a' && a<='z') a -= 0x20;
    return a;
}

static inline char lowcase(char a)
{
    if (a>='A' && a<='Z') a += 0x20;
    return a;
}

static inline char *lc(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c>='A' && *c<='Z') *c+=0x20;
        c++;
    }
    return str;
}

static inline char *uc(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c>='a' && *c<='z') *c-=0x20;
        c++;
    }
    return str;
}

static inline char *fixsemi(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c==';') *c=':';
        c++;
    }
    return str;
} 

/*static inline int cmpbeg(char *str, char *b)
{
    while (*str && upcase(*str) == upcase(*b)) str++, b++;
    return !!*b;
} */


#if !(defined(LEAK_DEBUG) && defined(LEAK_DEBUG_LIST))

static inline char *memacpy(const char *src, int len)
{
    char *m;
    if ((m = mem_alloc(len + 1))) {
        memcpy(m, src, len);
        m[len] = 0;
    }
    return m;
}

static inline char *stracpy(const char *src)
{
    return src ? memacpy(src, src != DUMMY ? strlen(src) : 0) : NULL;
}

#else

static inline char *debug_memacpy(char *f, int l, char *src, int len)
{
    char *m;
    if ((m = debug_mem_alloc(f, l, len + 1))) {
        memcpy(m, src, len);
        m[len] = 0;
    }
    return m;
}

#define memacpy(s, l) debug_memacpy(__FILE__, __LINE__, s, l)

static inline char *debug_stracpy(char *f, int l, char *src)
{
    return src ? debug_memacpy(f, l, src, src != DUMMY ? strlen((char*)src) : 0) : NULL;
}

#define stracpy(s) debug_stracpy(__FILE__, __LINE__, s)

#endif
  
static inline int snprint(char *s, int n, unsigned num)
{
    int q = 1;
    while (q <= num / 10) q *= 10;
    while (n-- > 1 && q) *(s++) = num / q + '0', num %= q, q /= 10;
    *s = 0;
    return !!q;
}

static inline int snzprint(char *s, int n, int num)
{
    if (n > 1 && num < 0) *(s++) = '-', num = -num, n--;
    return snprint(s, n, num);
}

static inline void add_to_strn(char **s, char *a)
{
    char *p;
    if (!(p = mem_realloc(*s, strlen(*s) + strlen(a) + 1))) return;
    strcat(p, a);
    *s = p;
}

#define ALLOC_GR    0x100       /* must be power of 2 */

#define init_str() init_str_x(__FILE__, __LINE__)

static inline char *init_str_x(char *file, int line)
{
    char *p;
    if ((p = debug_mem_alloc(file, line, ALLOC_GR))) *p = 0;
    return p;
}

static inline void add_to_str(char **s, int *l, char *a)
{
    char *p;
    int ll = strlen(a);
    if ((*l & ~(ALLOC_GR - 1)) != ((*l + ll) & ~(ALLOC_GR - 1)) &&
       (!(p = mem_realloc(*s, (*l + ll + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    strcpy(*s + *l, a); *l += ll;
}

/*static inline void add_bytes_to_str(char **s, int *l, char *a, int ll)
{
    char *p;
    if ((*l & ~(ALLOC_GR - 1)) != ((*l + ll) & ~(ALLOC_GR - 1)) &&
       (!(p = mem_realloc(*s, (*l + ll + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    memcpy(*s + *l, a, ll); (*s)[*l += ll] = 0;
} */

static inline void add_chr_to_str(char **s, int *l, char a)
{
    char *p;
    if ((*l & (ALLOC_GR - 1)) == ALLOC_GR - 1 &&
       (!(p = mem_realloc(*s, (*l + 1 + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    *(*s + *l) = a; *(*s + ++(*l)) = 0;
}

static inline void add_num_to_str(char **s, int *l, int n)
{
    char a[64];
    snzprint(a, 64, n);
    add_to_str(s, l, a);
}

/*static inline void add_knum_to_str(char **s, int *l, int n)
{
    char a[13];
    if (n && n / (1024 * 1024) * (1024 * 1024) == n) snzprint(a, 12, n / (1024 * 1024)), strcat(a, "M");
    else if (n && n / 1024 * 1024 == n) snzprint(a, 12, n / 1024), strcat(a, "k");
    else snzprint(a, 13, n);
    add_to_str(s, l, a);
}  */

/*static inline char *copy_string(char **dst, char *src)
{
    if ((*dst = src) && (*dst = mem_alloc(strlen(src) + 1))) strcpy(*dst, src);
    return *dst;
} */

/* Copies at most dst_size chars into dst. Ensures null termination of dst. */

static inline char *safe_strncpy(char *dst, const char *src, size_t dst_size) {
    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


static inline char *safe_strncpy0(char *dst, const char *src, size_t dst_size) {
    if (!src) {
        *dst='\0';
        return dst;
    }

    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


struct list_head {
    void *next;
    void *prev;
};

#ifndef HAVE_TYPEOF

struct xlist_head {
    struct xlist_head *next;
    struct xlist_head *prev;
};

#endif

#define init_list(x) {(x).next=&(x); (x).prev=&(x);}
#define list_empty(x) ((x).next == &(x))
#define del_from_list(x) {((struct list_head *)(x)->next)->prev=(x)->prev; ((struct list_head *)(x)->prev)->next=(x)->next;}
#define add_at_pos(p,x) do {(x)->next=(p)->next; (x)->prev=(p); (p)->next=(x); (x)->next->prev=(x);} while(0)

#ifdef HAVE_TYPEOF
#define add_to_list(l,x) add_at_pos((typeof(x))&(l),(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(typeof(e))&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(typeof(e))&(l); (e)=(e)->prev)
#else
#define add_to_list(l,x) add_at_pos((struct xlist_head *)&(l),(struct xlist_head *)(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(void *)&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(void *)&(l); (e)=(e)->prev)
#endif
#define free_list(l) {while ((l).next != &(l)) {struct list_head *a=(l).next; del_from_list(a); mem_free(a); }}

/*static inline int isA(char c)
{
    return (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') ||
            c == '_' || c == '-';
} */

static inline int casecmp(char *c1, char *c2, int len)
{
    int i;
    for (i = 0; i < len; i++) if (upcase(c1[i]) != upcase(c2[i])) return 1;
    return 0;
}

static inline int can_write(int fd)
{
    fd_set fds;
    struct timeval tv = {0, 0};
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    return select(fd + 1, NULL, &fds, NULL, &tv);
}

static inline int can_read(int fd)
{
    fd_set fds;
    struct timeval tv = {0, 0};
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    return select(fd + 1, &fds, NULL, NULL, &tv);
}


/* os_dep.c */

struct terminal;

struct open_in_new {
     char *text;
     char *hk;
    void (*fn)(struct terminal *term,  char *,  char *);
};


int get_system_env(void);
int is_xterm(void);
int can_twterm(void);
int get_terminal_size(int, int *, int *);
void handle_terminal_resize(int, void (*)(void));
void unhandle_terminal_resize(int);
void set_bin(int);
int c_pipe(int *);
int get_input_handle(void);
int get_output_handle(void);
int get_ctl_handle(void);
void want_draw(void);
void done_draw(void);
void terminate_osdep(void);
void *handle_mouse(int, void (*)(void *,  char *, int), void *);
void unhandle_mouse(void *);
int check_file_name( char *);
int start_thread(void (*)(void *, int), void *, int);
char *get_clipboard_text(void);
void set_clipboard_text(char *);
void set_window_title_( char *);
 char *get_window_title(void);
int is_safe_in_shell( char);
void check_shell_security( char **);
void block_stdin(void);
void unblock_stdin(void);
int exe(char *);
int resize_window(int, int);
int can_resize_window(int);
int can_open_os_shell(int);
struct open_in_new *get_open_in_new(int);
void disable_screensaver(void);

/* ghash.c */

typedef struct _THashNode      THashNode;
typedef struct _THashTable     THashTable;

struct _THashNode
{
  gpointer key;
  gpointer value;
  THashNode *next;
};

struct _THashTable
{
  gint size;
  gint nnodes;
  guint frozen;
  THashNode **nodes;
  GHashFunc hash_func;
  GCompareFunc key_compare_func;
};

THashTable *t_hash_table_new (GHashFunc hash_func, GCompareFunc key_compare_func);
void t_hash_table_destroy (THashTable *hash_table);
void t_hash_table_foreach (THashTable *hash_table, GHFunc func, gpointer user_data);
void t_hash_table_insert (THashTable *hash_table, gpointer key, gpointer value);
void t_hash_table_remove (THashTable *hash_table, gconstpointer key);
gpointer t_hash_table_lookup (THashTable *hash_table, gconstpointer key);
gboolean t_hash_table_lookup_extended (THashTable *hash_table, gconstpointer lookup_key, gpointer *orig_key, gpointer *value);
guint t_hash_table_foreach_remove (THashTable *hash_table, GHRFunc func, gpointer user_data);
guint t_hash_table_size (THashTable *hash_table);



/* select.c */

#ifndef FD_SETSIZE
#define FD_SETSIZE 1024
#endif

typedef long ttime;
typedef unsigned tcount;

extern int terminate;

/*long select_info(int);*/
void select_loop(void (*)(void));
int register_bottom_half(void (*)(void *), void *);
void check_bottom_halves(void);
int install_timer_(ttime, void (*)(void *), void *);
void kill_timer(int);
ttime get_timer_time(int);
ttime get_time(void);

struct job{
    struct jobs *next;
    struct jobs *prev;
    
    int (*func)(struct job *job);
    struct timeval timeout;
    int max_matches;
    
    GPtrArray *result;
    gchar *str;

    int node_from;
    THashTable *hash_table;
    void *h_func_v;
};


int register_job(struct job *job);
void check_jobs(void);
void abort_jobs(void);
void free_job(struct job *job);

#define H_READ  0
#define H_WRITE 1
#define H_ERROR 2
#define H_DATA  3

void *get_handler(int, int);
void set_handlers(int, void (*)(void *), void (*)(void *), void (*)(void *), void *);
void install_signal_handler(int, void (*)(void *), void *, int);
void set_sigcld(void);

extern struct timeval start;
#define ST_START gettimeofday(&start, NULL)
#define ST_STOP {\
    struct timeval stop;\
    int sec, usec;\
    gettimeofday(&stop, NULL);\
    usec=stop.tv_usec-start.tv_usec;\
    sec=stop.tv_sec-start.tv_sec;\
    if (usec<0){usec+=1000000;sec--;}\
    dbg("stopky: %s: %d.%06d \n", __FUNCTION__, sec,usec);\
}
/* dns.c */

typedef unsigned ip;


/* kbd.c */

#define BM_BUTT     3
#define BM_EBUTT    7
#define B_LEFT      0
#define B_MIDDLE    1
#define B_RIGHT     2
#define B_WHUP      4
#define B_WHDOWN    5
#define BM_ACT      24
#define B_DOWN      0
#define B_UP        8
#define B_DRAG      16

#define KBD_ENTER   0x100
#define KBD_BS      0x101
#define KBD_TAB     0x102
#define KBD_ESC     0x103
#define KBD_LEFT    0x104
#define KBD_RIGHT   0x105
#define KBD_UP      0x106
#define KBD_DOWN    0x107
#define KBD_INS     0x108
#define KBD_DEL     0x109
#define KBD_HOME    0x10a
#define KBD_END     0x10b
#define KBD_PAGE_UP 0x10c
#define KBD_PAGE_DOWN   0x10d

#define KBD_F1      0x120
#define KBD_F2      0x121
#define KBD_F3      0x122
#define KBD_F4      0x123
#define KBD_F5      0x124
#define KBD_F6      0x125
#define KBD_F7      0x126
#define KBD_F8      0x127
#define KBD_F9      0x128
#define KBD_F10     0x129
#define KBD_F11     0x12a
#define KBD_F12     0x12b

#define KBD_CTRL_C  0x200

#define KBD_SHIFT   1
#define KBD_CTRL    2
#define KBD_ALT     4

void handle_trm(int, int, int, int, int, void *, int);
void free_all_itrms(void);
void resize_terminal(void);
void dispatch_special( char *);
void kbd_ctrl_c(void);
int is_blocked(void);

/* terminal.c */

/* UTF-8 */
typedef uint32_t unicode_val;
/* UCS/Unicode replacement character. */
#define UCS_NO_CHAR ((unicode_val) 0xFFFD)

typedef unsigned short chr;

struct event {
    long ev;
    long x;
    long y;
    long b;
};

#define EV_INIT     0
#define EV_KBD      1
#define EV_MOUSE    2
#define EV_REDRAW   3
#define EV_RESIZE   4
#define EV_ABORT    5

struct window {
    struct window *next;
    struct window *prev;
    void (*handler)(struct window *, struct event *, int fwd);
    void *data;
    int xp, yp;
    struct terminal *term;
};

#define MAX_TERM_LEN    16  /* this must be multiple of 8! (alignment problems) */

#define MAX_CWD_LEN 8192    /* this must be multiple of 8! (alignment problems) */  

#define ENV_XWIN    1
#define ENV_SCREEN  2
#define ENV_OS2VIO  4
#define ENV_BE      8
#define ENV_TWIN    16

struct terminal {
    struct terminal *next;
    struct terminal *prev;
    int master;
    int fdin;
    int fdout;
    int x;
    int y;
    int environment;
    char term[MAX_TERM_LEN];
    char cwd[MAX_CWD_LEN];
    unsigned *screen;
    unsigned *last_screen;
    struct term_spec *spec;
    int cx;
    int cy;
    int lcx;
    int lcy;
    int dirty;
    int redrawing;
    int blocked;
    char *input_queue;
    int qlen;
    struct list_head windows;
     char *title;
    /* Something weird regarding the UTF8 I/O. */
    struct {
        unicode_val ucs;
        int len;
        int min;
    } utf_8;
};

extern struct terminal *term;

struct term_spec {
    struct term_spec *next;
    struct term_spec *prev;
    char term[MAX_TERM_LEN];
    int mode;
    int m11_hack;
    int restrict_852;
    int block_cursor;
    int col;
    int utf_8_io;
    int charset;
};

#define TERM_DUMB   0
#define TERM_VT100  1
#define TERM_LINUX  2
#define TERM_KOI8   3

#define ATTR_FRAME  0x8000

extern struct list_head term_specs;

int hard_write(int, char *, int);
int hard_read(int, char *, int);
char *get_cwd(void);
void set_cwd(char *);
struct terminal *init_term(int, int, void (*)(struct window *, struct event *, int));
void sync_term_specs(void);
struct term_spec *new_term_spec(char *);
void free_term_specs(void);
void destroy_terminal(struct terminal *);
void redraw_terminal(struct terminal *);
void redraw_terminal_all(struct terminal *);
void redraw_terminal_cls(struct terminal *);
void redraw_later(struct terminal *term);
void cls_redraw_all_terminals(void);
void redraw_from_window(struct window *);
void redraw_below_window(struct window *);
void add_window(struct terminal *, void (*)(struct window *, struct event *, int), void *);
void add_window_at_pos(struct terminal *, void (*)(struct window *, struct event *, int), void *, struct window *);
void delete_window(struct window *);
void delete_window_ev(struct window *, struct event *ev);
void set_window_ptr(struct window *, int, int);
void get_parent_ptr(struct window *, int *, int *);
struct window *get_root_window(struct terminal *);
void add_empty_window(struct terminal *, void (*)(void *), void *);
void redraw_screen(struct terminal *);
void redraw_all_terminals(void);
void set_char(struct terminal *, int, int, unsigned);
unsigned get_char(struct terminal *, int, int);
void set_color_(struct terminal *, int, int, unsigned);
void set_only_char(struct terminal *, int, int, unsigned);
void set_line(struct terminal *, int, int, int, chr *);
void set_line_color(struct terminal *, int, int, int, unsigned);
void fill_area(struct terminal *, int, int, int, int, unsigned);
void draw_frame(struct terminal *, int, int, int, int, unsigned, int);
void print_text(struct terminal *, int, int, int, char *, unsigned);
void set_cursor(struct terminal *, int, int, int, int);
void destroy_all_terminals(void);
void block_itrm(int);
int unblock_itrm(int);
void exec_thread(char *, int);
void close_handle(void *);
void set_ctest_title(struct terminal *);

#define TERM_FN_TITLE   1
#define TERM_FN_RESIZE  2

void exec_on_terminal(struct terminal *, char *, char *, int);
void set_terminal_title(struct terminal *, char *);
void do_terminal_function(struct terminal *, char, char *);


/*#define FRAME_URDL 0x80c5*/
#define FRAME_UDL  0x80b4
#define FRAME_URD  0x80c3
#define FRAME_URL  0x80c1
#define FRAME_RDL  0x80c2

/* language.c */

#include "language.h"

extern char dummyarray[];

extern int current_language;

void init_trans(void);
void shutdown_trans(void);
char *get_text_translation(char *, struct terminal *term);
char *get_english_translation(char *);
void set_language(int);
int n_languages(void);
char *language_name(int);

#define _(_x_, _y_) get_text_translation(_x_, _y_)
#define CTEXT(x) (dummyarray + x)
#define TEXT(_x_) get_text_translation(CTEXT(_x_),term)

/* main.c */

#define RET_OK      0
#define RET_ERROR   1
#define RET_SIGNAL  2
#define RET_SYNTAX  3
#define RET_FATAL   4

extern int retval;
extern int first_use;

extern char *path_to_exe;

void unhandle_terminal_signals(struct terminal *term);
int attach_terminal(int, int, int, void *, int);
void shrink_memory(int);

/* types.c */


/* session.c */

#define TMPQ aband->tmpqsos[0]

struct inputln;
struct rotar;
struct band; 

struct session {
    struct session *next;
    struct session *prev;
    struct terminal *term;
    struct window *win;
    int id;
    int exit_query;
    
    GPtrArray *subwins; 
    struct subwin *ontop;
    gint focused;
    
    gint timer_id;
};

extern struct session *gses;

struct session *create_session(struct window *win);
void *create_session_info(int, char *, int *);
void rxtx(void);
void esc(void);
void rx(void);
int preferred_func(struct event *ev);
void win_func(struct window *, struct event *, int);

void draw_root_window(struct session *ses);
void send_event(struct session *ses, struct event *ev);
void add_date_time(struct band *band);
void fix_date_time(struct band *band);
void process_input(void *,char *);
void draw_time(void);
void time_func(void *);
void print_tucnak(struct terminal *term, int x, int y);
void timer_redraw(void *);

/* bfu.c */

struct memory_list {
    int n;
    void *p[1];
};

struct memory_list *getml(void *, ...);
void add_to_ml(struct memory_list **, ...);
void freeml(struct memory_list *);

#define MENU_FUNC (void (*)(struct terminal *, void *, void *))

extern char m_bar;

#define M_BAR   (&m_bar)

struct menu_item {
    char *text;
    char *rtext;
    char *hotkey;
    void (*func)(struct terminal *, void *, void *);
    void *data;
    int in_m; /* 0 menu zmizi po vyberu */
    int free_i;
};

struct menu {
    int selected;
    int view;
    int xp, yp;
    int x, y, xw, yw;
    int ni;
    void *data;
    struct window *win;
    struct menu_item *items;
};

struct mainmenu {
    int selected;
    int sp;
    int ni;
    void *data;
    struct window *win;
    struct menu_item *items;
};

struct history_item {
    struct history_item *next;
    struct history_item *prev;
    char d[1];
};

struct history {
    int n;
    struct list_head items;
};

#define D_END       0
#define D_CHECKBOX  1
#define D_FIELD     2
#define D_FIELD_PASS    3
#define D_BUTTON    4
#define D_BOX       5

#define B_ENTER     1
#define B_ESC       2

struct dialog_item_data;
struct dialog_data;

struct dialog_item {
    int type;
    int gid, gnum; /* for buttons: gid - flags B_XXX */ /* for fields: min/max */ /* for box: gid is box height */
    int (*fn)(struct dialog_data *, struct dialog_item_data *);
    struct history *history;
    int dlen;           /* data length */
    int maxl;
    char *data;
    void *udata;        /* for box: holds list */
    char *text;
};

struct dialog_item_data {
    int x, y, l;
    int vpos, cpos;
    int checked;
    struct dialog_item *item;
    struct list_head history;
    struct history_item *cur_hist;
    char *cdata;
};

#define EVENT_PROCESSED     0

struct dialog {
    char *title;
    void (*fn)(struct dialog_data *);
    int (*handle_event)(struct dialog_data *, struct event *);
    void (*abort)(struct dialog_data *);
    void *udata;
    void *udata2;
    int align;
    void (*refresh)(void *);
    void *refresh_data;
    struct dialog_item items[1];
};

struct dialog_data {
    struct window *win;
    struct dialog *dlg;
    int x, y, xw, yw;
    int n;
    int selected;
    struct memory_list *ml;
    struct dialog_item_data items[1];
};

struct menu_item *new_menu(int);
void add_to_menu(struct menu_item **, char *, char *, char *, void (*)(struct terminal *, void *, void *), void *, int);
void do_menu_(struct terminal *, struct menu_item *, void *);
void do_menu_selected(struct terminal *, struct menu_item *, void *, int);
void do_mainmenu(struct terminal *, struct menu_item *, void *, int);
void do_dialog_(struct terminal *, struct dialog *, struct memory_list *);
int check_number(struct dialog_data *, struct dialog_item_data *);
int check_nonempty(struct dialog_data *, struct dialog_item_data *);
void max_text_width(struct terminal *, char *, int *);
void min_text_width(struct terminal *, char *, int *);
void dlg_format_text(struct terminal *, struct terminal *, char *, int, int *, int, int *, int, int);
void max_buttons_width(struct terminal *, struct dialog_item_data *, int, int *);
void min_buttons_width(struct terminal *, struct dialog_item_data *, int, int *);
void dlg_format_buttons(struct terminal *, struct terminal *, struct dialog_item_data *, int, int, int *, int, int *, int);
void checkboxes_width(struct terminal *, char **, int *, void (*)(struct terminal *, char *, int *));
void dlg_format_checkbox(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, char *);
void dlg_format_checkboxes(struct terminal *, struct terminal *, struct dialog_item_data *, int, int, int *, int, int *, char **);
void dlg_format_field(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, int);
void max_group_width(struct terminal *, char **, struct dialog_item_data *, int, int *);
void min_group_width(struct terminal *, char **, struct dialog_item_data *, int, int *);
void dlg_format_group(struct terminal *, struct terminal *, char **, struct dialog_item_data *, int, int, int *, int, int *);
void dlg_format_group1(struct terminal *, struct terminal *, char **, struct dialog_item_data *, int, int, int *, int, int *);
void dlg_format_box(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, int);
void checkbox_list_fn(struct dialog_data *);
void group_fn(struct dialog_data *);
void center_dlg(struct dialog_data *);
void draw_dlg(struct dialog_data *);
void display_dlg_item(struct dialog_data *, struct dialog_item_data *, int);
int ok_dialog(struct dialog_data *, struct dialog_item_data *);
int cancel_dialog(struct dialog_data *, struct dialog_item_data *);
void msg_box(struct terminal *, struct memory_list *, char *, int, ...);
void input_field_fn(struct dialog_data *);
void input_field(struct terminal *, struct memory_list *, char *, char *, char *, char *, void *, struct history *, int, char *, int, int, int (*)(struct dialog_data *, struct dialog_item_data *), void (*)(void *, char *), void (*)(void *));
void add_to_history(struct history *, char *);

void box_sel_move(struct dialog_item_data *, int ); 
void show_dlg_item_box(struct dialog_data *, struct dialog_item_data *);
void box_sel_set_visible(struct dialog_item_data *, int ); 
void errbox(char *text, int errcode, ...); 



/* menu.c */

#define CONDGFREE(item) { if (item) { g_free(item); item=NULL; }}

#define STORE_STR(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); 
    
#define STORE_STR_UC(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    uc(base->item);

#define STORE_STR_FS(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    fixsemi(base->item)    
    
#define STORE_STR_FS_UC(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    fixsemi(base->item); \
    uc(base->item);

#define STORE_STR2(dbase,sbase,item) \
    if (dbase->item) g_free(dbase->item); \
    dbase->item = g_strdup(sbase->item); 

#define STORE_STR2_UC(dbase,sbase,item) \
    if (dbase->item) g_free(dbase->item); \
    dbase->item = g_strdup(sbase->item); \
    uc(dbase->item);

#define STORE_INT(base, item) \
    base->item = item; 

#define STORE_SINT(base, item) \
    base->item = atoi(item##_str); 

#define EQSO_LEN 15


struct qso;
struct tmpqso;
void activate_bfu_technology(struct session *, int);
void free_history_lists(void);
void exit_prog(struct terminal *, void *, struct session *);
void contest_options1_from_menu(struct terminal *, void *, void *);
void contest_options1_from_ctest(struct terminal *, void *, void *);
void contest_options1(struct terminal *, char *title, void *);
void band_settings(struct terminal *term, void *xxx, void *yyy);
void edit_qso(struct terminal *term, struct qso *qso, void *yyy);
void menu_export_edi(struct terminal *term, void *d, struct session *ses);
void menu_export_report(struct terminal *term, void *d, struct session *ses);
void menu_export_html(struct terminal *term, void *d, struct session *ses);
void menu_export_stats(struct terminal *term, void *d, struct session *ses);
void menu_export_titlpage(struct terminal *term, void *d, struct session *ses);
void menu_save_all(struct terminal *term, void *d, struct session *ses);
void menu_add_error(struct terminal *term, void *xxx, struct session *ses);
void do_edit_menu(struct terminal *term, void *xxx, struct session *ses);
void menu_chop(struct terminal *term, void *d, struct session *ses);
void menu_skedqrg(struct terminal *term, void *d, struct session *ses);
void menu_fillop(struct terminal *term, void *d, struct session *ses);
void menu_recalc_qrb(struct terminal *term, void *d, struct session *ses);
void menu_cw_update_contest(struct terminal *term, void *d, struct session *ses);
void menu_cw_update_band(struct terminal *term, void *d, struct session *ses);
void menu_autosave(struct terminal *term, void *xxx, void *yyy);
void menu_add_subwin(struct terminal *term, void *xxx, struct session *ses);
void menu_close_subwin(struct terminal *term, void *xxx, struct session *ses);
void sked_from_qso(struct terminal *term, struct qso *qso, void *yyy);
void sked_from_tmpqso(struct terminal *term, struct tmpqso *tmpqso, void *yyy);
int dlg_pband(struct dialog_data *dlg, struct dialog_item_data *di);
void menu_wizz(struct terminal *term, void *xxx, void *yyy);
void menu_cq_cw(struct terminal *term, void *xxx, struct session *ses);
void menu_cq_ssb(struct terminal *term, void *xxx, struct session *ses);
void menu_cwda(struct terminal *term, void *xxx, struct session *ses);
void menu_ssbd(struct terminal *term, void *xxx, struct session *ses);
void menu_network(struct terminal *term, void *xxx, struct session *ses);
void edi_prop(struct terminal *term, void *xxx, void *yyy);
int dlg_edi_prop(struct dialog_data *dlg, struct dialog_item_data *di);
void contest_def(struct terminal *term, void *xxx, void *yyy);
void menu_contest_open(struct terminal *term, void *ddd, struct session *ses);
void duplicate_callsign(struct terminal *term, struct qso *qso, void *yyy);
void menu_unfinished(struct terminal *term, void *xxx, struct session *ses);
void free_namelist(void);
int save_desc_to_file(gchar *filename);
void menu_responsible_op(struct terminal *term, void *xxx, struct session *ses);
void do_peer_menu(struct terminal *term, void (* func)(struct terminal*, int no, struct session *ses) , struct session *ses);
void do_peer_operators_menu(struct terminal *term, void (* func)(struct terminal*, int no, struct session *ses) , struct session *ses);
void menu_import_ebw(struct terminal *term, void *d, struct session *ses);
void menu_load_from_peer(struct terminal *term, void *fn, struct session *ses);
    

/* charsets.c */

#include "codepage.h"

struct conv_table {
    int t;
    union {
        char *str;
        struct conv_table *tbl;
    } u;
};

/*struct conv_table *get_translation_table(int, int);*/
int get_cp_index(char *n);
char *get_cp_name(int);
/*char *get_cp_mime_name(int);*/
int is_cp_special(int);
void free_conv_table(void);
char *cp2utf_8(int, int);
char *u2cp(unicode_val, int);

#define AL_LEFT     0
#define AL_CENTER   1

#define AL_MASK     0x7f

#define AL_EXTD_TEXT    0x80
    /* DIRTY! for backward compatibility with old menu code */

/* default.c */

#define MAX_STR_LEN 1024

/* Stores display information about a box. Kept in cdata. */
struct dlg_data_item_data_box {
    int sel;    /* Item currently selected */   
    int box_top;    /* Index into items of the item that is on the top line of the box */
    struct list_head items; /* The list being displayed */
    int list_len;   /* Number of items in the list */
};

/* Which fields to free when zapping a box_item. Bitwise or these. */
enum box_item_free {NOTHING = 0, TEXT = 1 , DATA = 2};
/* An item in a box */
struct box_item {
    struct box_item *next;
    struct box_item *prev;
    char *text;    /* Text to display */
    void *data; /* data */
    enum box_item_free free_i;
};


void show_dlg_item_box(struct dialog_data *, struct dialog_item_data *); 

/* kbdbind.c */

#define KM_MAIN     0
#define KM_EDIT     1
#define KM_MENU     2
#define KM_MAX      3

enum {
    ACT_AUTO_COMPLETE,
    ACT_BACKSPACE,
    ACT_CHOP, 
    ACT_CLEAR_TMPQSOS,
    ACT_CLEAR_TMPQSOS_INPUTLINE,
    ACT_CONFIRM_CALL,
    ACT_CONFIRM_WWL,
    ACT_COPY_CLIPBOARD,
    ACT_CQ_0,
    ACT_CQ_1,
    ACT_CQ_2,
    ACT_CQ_3,
    ACT_CQ_4,
    ACT_CQ_5,
    ACT_CUT_CLIPBOARD,
    ACT_DELETE,
    ACT_DOWN,
    ACT_END,
    ACT_ENTER,
    ACT_ESC,
    ACT_FILE_MENU,
    ACT_FIND_NEXT,
    ACT_FIND_NEXT_BACK,
    ACT_FOCUS_SUBWIN,
    ACT_GRAB_BAND,
    ACT_HOME,
    ACT_KILL_LINE,
    ACT_KILL_TO_BOL,
    ACT_KILL_TO_EOL,
    ACT_LEFT,
    ACT_MENU,
    ACT_MODE,
    ACT_NEXT_HISTORY,
    ACT_NEXT_SUBWIN,  
    ACT_PAGE_DOWN,
    ACT_PAGE_UP,
    ACT_PASTE_CLIPBOARD,
    ACT_PREV_HISTORY, 
    ACT_PREV_SUBWIN,
	ACT_POLAR_MAP,
    ACT_QUIT,
    ACT_REALLYQUIT,
    ACT_RIGHT,
    ACT_ROTAR,
    ACT_RX,
    ACT_RXTX, 
    ACT_SAVE_ALL,
/*    ACT_SCROLL_DOWN,*/
    ACT_SCROLL_LEFT,
    ACT_SCROLL_RIGHT,
/*    ACT_SCROLL_UP,*/
    ACT_SEARCH,
    ACT_SEARCH_BACK,
    ACT_SEEK_A,
    ACT_SEEK_B,
    ACT_SHOW_HISTORY,
    ACT_SKED,
    ACT_SKED_QRG,
    ACT_SWAP_CALL,
    ACT_SWAP_WWL,
/*    ACT_TX, */
    ACT_UNFINISHED,
    ACT_UP
};

void init_keymaps(void);
void free_keymaps(void);
int kbd_action(int, struct event *);

/* stats.c */

#define QSONR_WIDTH 20
#define QSONR_HEIGHT 7
#define BAND_WIDTH 16
#define ORIG_Y 1

struct stats{
    gint first_date, last_date; /* 20021115*/
    gint nqsos, nqsop;  /* without errors and dupes */
    gint nwwlp; 
    gint nexcp; 
    gint ndxcp; 
    gint ntotal;

    gint odxqrb_int;
    gchar *odxcall, *odxwwl, *odxoperator;

    GHashTable *wwls, *dxcs, *excs;
    GHashTable *calls;
    
};

struct contest;
struct config_subwin;

char *get_raw_call(char *buf, char *call);
char *get_wwl(char *buf, char *wwl);

void draw_one_bigdigit(struct terminal *term,int x, int y, int num);
void draw_bigdigit(struct terminal *term, int x, int y, int num);

struct stats *init_stats(void);
void free_stats(struct stats *st);
void clear_stats(struct stats *st);
void update_stats(struct stats *st, struct band *b, struct qso *q);
void recalc_stats(struct stats *st, struct band *b);
void recalc_all_stats(struct contest *ctest);
void recalc_all_qrbqtf(struct contest *ctest);
void redraw_stats(struct stats *st);
void recalc_statsfifo(struct band *band);
void export_stats_fifo(void);


/* inputln.c */


struct inputln {
    int (*fn)(struct dialog_data *, struct dialog_item_data *);
    int dlen;           /* data length */
    int x, y, l;
    int vpos, cpos, focused, wasctrlv;
    int upconvert, readonly, allow_ctrlv;
    char *cdata;
    struct terminal *term;
    void *enterdata;
    void (*enter)(void *, gchar *);
    GPtrArray *history;
    int hist_i;
    struct band *band;
};

void il_set_focus(struct inputln *il);
void il_unset_focus(struct inputln *il);
void clear_inputline(struct inputln *il);
int inputln_func(struct inputln *il, struct event *ev);
void il_readonly(struct inputln *il, int ro);
void draw_inputln(struct inputln *il, int sel);

/* rc.c */

struct config_band{
    gchar bandchar; /* 'a' ... */
    gchar *pband;           /* 144 MHz */ 
    gint psect;           /* Single, Multi */
    gint qrv,qrvnow,readonly;
    
    gchar *stxeq,*spowe;        /* TM-255 + gi7b, 300 */ 
    gchar *srxeq,*sante,*santh; /* TM-255, GW4PTS, 60;800 */
    gchar *mope1,*mope2;    /* OK1XDF, OK1MZM, OK1ZIA */
    gchar *remarks;

       /* a little hack for OK  */
    gchar *ok_section_single;  /* 2m=01, 70cm=03, ... */
    gchar *ok_section_multi;   /* 2m=02, 70cm=04, ... */
    gint qrg_min,qrg_max;      /* kHz */
	gchar *adifband;           /* 2m,70cm,23cm... */  
    gchar *skedqrg;
};

struct config_rotar;
struct config {   /* depending on callsign */
    gchar *pcall;
    gchar *pwwlo;
    gchar *pexch;

    gchar *padr1,*padr2,*pclub;
    gchar *rname,*rcall,*radr1,*radr2,*rpoco,*rcity,*rcoun,*rphon,*rhbbs;

    gchar *default_rs,*default_rst;
    gint qsop_method, total_method;
    
    gint as_disk_aq, as_disk_am, as_floppy_aq, as_floppy_am;
    gint as_disk_fsync, as_floppy_fsync, as_mount;
    gchar *as_floppy_path, *as_mount_cmd;

    gchar *net_if_ignore, *net_ip_ignore, *net_ip_announce;
    
    GPtrArray *bands;
    struct config_band *band;  /* active band during loading config */
    GPtrArray *cqs;            /* of struct cq */
    struct cq *cq;
    struct term_spec *ts;
    GPtrArray *sws;            /* of struct config_subwin */
    struct config_subwin *sw;
    
    gchar *cwda_hostname;
    gint cwda_udp_port, cwda_device/*obsolete*/,cwda_port /* obsolete*/, cwda_speaker/*obsolete*/;
    gchar *cwda_device_s;
    gint cwda_speed, cwda_weight, cwda_spkdev, cwda_spkvol, cwda_pttdelay;
    
    gchar *ssbd_hostname;
    gint ssbd_udp_port;
    gchar *ssbd_dsp;
    gint ssbd_record;
    gchar *ssbd_template; 
    gint ssbd_format, ssbd_channels, ssbd_samplerate;
    gchar *ssbd_mixer;
    gint ssbd_recsrc;
    
    gint trace_bcast, trace_sock, trace_recv, trace_send, trace_qsos;
    
   /* gint rota_type,rota_port,rota_saddr,rota_timeout_ms;
    gchar *rota_filename,*rota_hostname;
    
    gint rotb_type,rotb_port,rotb_saddr,rotb_timeout_ms;
    gchar *rotb_filename,*rotb_hostname;*/
    
    GPtrArray *crotars;  /* of struct config_rotar */
    struct config_rotar *crotar;
    int loglines,skedshift;
    gchar *startband;
    GPtrArray *takeoff; /* of struct takeoff */

};


/*struct wiz_ctest{
    gchar *contestname;
    gint wwltype,wwlused,wwlbonu,wwlmult;
    gint excused,excbonu,excmult;
    gint dxcbonu,dxcmult;
    gint rstused,qsop_method,total_method;
};*/

extern struct config *cfg;

gint init_rc(void);
gint free_rc(void);
gint read_rc_line(gchar *str);
gint read_rc_file(gchar *filename);
gint read_rc_files(void);
void save_rc_string(GString *gs); 
gint save_rc_file(gchar *filename);
int term_spec_init(void);
char *parse_options(int argc, char **argv);

/* qsodb.c */

#define STORE_HASH_STR(base, item) {\
    if (base->item) g_free(base->item);\
    base->item = g_strdup(g_hash_table_lookup(hash, #item)); \
}

#define STORE_HASH_INT(base, item) {\
    gchar *c; \
    c = g_hash_table_lookup(hash, #item); \
    if (c) base->item = atoi(c); \
    else base->item = 0; \
}

#define STORE_HASH_CHR(base, item) {\
    gchar *c;\
    c=(char *)g_hash_table_lookup(hash, #item); \
    if (c) base->item = tolower(*c);\
    else c='\0';\
}


#define DIRTY_BAND(band) { \
    dbg_qsos("DIRTY_BAND %c",band->bandchar); \
    band->dirty_save = 1; \
    band->dirty_stats = 1; \
    band->dirty_statsf = 1; \
};

#define NEW_EXC 1
#define NEW_WWL 2
#define NEW_DXC 4

struct qso{
    gchar *source; /* "192.168.0.1:1026" CONSTANT */
    gint  ser_id; /* 0..X in one source  CONSTANT */
    time_t stamp;  /* last modification  VARIABLE */
    
    gchar *operator;
    
    gchar *date_str,*time_str;
    gchar *callsign;
    gint  mode;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark;
    gint error;
   /* computed*/
    gint dupe,qsop,new,qsl;
    gdouble qrb;
    gint qtf;
    gint susploc; /* 1=warn, 2=err */ 
    gint unkcall;
    /* "foreign key", don't dealloc! */
    struct band *band;
#ifdef HAVE_SDL 
    int gfx_x,gfx_y;
#endif
};

struct tmpqso{
    gchar *date_str,*time_str;
    gchar *callsign;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark;
    gint dupe,qsl;
   /* computed*/
    gdouble qrb;
    gint qtf;
    gchar *name;
   /* ultimate values                     */
    gint ucallsign,udummy,ulocator,uexc;
    int uqrb,uqtf;
   /* suspicious */
    gint suspcallsign, susplocator, suspexc, unkcall;
      
};

#define ADD_TMPQSO_STRING(band,item,str,isu,uitem) {\
    int i; \
    if (band->tmpqsos[TMP_QSOS-1].item) { \
        g_free(band->tmpqsos[TMP_QSOS-1].item); \
        band->tmpqsos[TMP_QSOS-1].item = NULL; \
    }\
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=g_strdup(str); \
    band->tmpqsos[0].uitem = isu; \
}

#define CLEAR_TMPQSO_STRING(band,item) {\
    if (band->tmpqsos[i].item) { \
        g_free(band->tmpqsos[i].item); \
        band->tmpqsos[i].item=NULL;\
    } \
}

#define CLEAR_TMPQSO_STRING_UU(band,item, uitem){ \
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem) {\
            g_free(band->tmpqsos[i].item); \
            band->tmpqsos[i].item=NULL;\
        }\
    }\
}
    
#define ADD_TMPQSO_GINT(band,item,num,isu,uitem) {\
    int i; \
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=num; \
    band->tmpqsos[0].uitem = isu; \
}

#define ADD_TMPQSO_GDOUBLE(band,item,num,isu,uitem) {\
    int i; \
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=num; \
    band->tmpqsos[0].uitem = isu; \
}

#define CLEAR_TMPQSO_GINT(band,item) \
        band->tmpqsos[i].item=0

/*#define CLEAR_TMPQSO_GINT_UU(band,item, uitem) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem) {\
            band->tmpqsos[i].item=0;\
        }\
    }\
} */
    
#define CLEAR_TMPQSO_GDOUBLE_UU(band,item, uitem) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem) {\
            band->tmpqsos[i].item=0;\
        }\
    }\
}
    
#define CLEAR_TMPQSO_QTF(band) \
        band->tmpqsos[i].qtf=-1

#define CLEAR_TMPQSO_QTF_UU(band) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uqtf) {\
            band->tmpqsos[i].qtf=-1;\
        }\
    }\
}
    
#define TMP_QSOS 3
#define DISP_QSOS 2

void add_tmpqso_locator(struct band *b,gchar *c,int isu, int isshort); 

/* also used for ctest->cq->type */
enum modes{ /* TX_RX */
    MOD_NONE = 0,
    MOD_SSB_SSB,
    MOD_CW_CW,
    MOD_SSB_CW,
    MOD_CW_SSB,
    MOD_AM_AM,
    MOD_FM_FM,
    MOD_RTTY_RTTY,
    MOD_SSTV_SSTV,
    MOD_ATV_ATV /* 9 */
};
    
enum last_items{
    LI_NONE = 0,
    LI_CALL,
    LI_WWL
};

enum ctrlstates{
    CTRL_RUN = 0,       /* RUN, TX    */
    CTRL_SP = 1,        /* S&P, no TX */
    CTRL_REQR = 2,      /* RUN, TX    */
    CTRL_REQS = 3,      /* S&P, no TX */
    CTRL_RUNING = 4,    /* S&P, TX    */
    CTRL_GIVEN = 5      /* RUN, no TX */
};

enum ccmd{
    CCMD_REQ = 0,       /* S&P->RUN */
    CCMD_ACC,           /* RUN->S&P */
    CCMD_REJ,           /* RUN->S&P */
    CCMD_BACK           /* S&P->RUN */
};
    
enum spymodes{
    /*SM_CALL = 0,*/
    SM_INPUTLINE = 1,
    SM_LAST = 2
};

struct spypeer;

struct band{
    gchar bandchar; /* 'c' ...*/
    gchar *pband;           /* 144 MHz */ 
    
    GPtrArray *qsos;
    struct inputln *il;
    struct tmpqso tmpqsos[TMP_QSOS];
    gchar  *unres, *qrv_str;
    gint   dupe_in_tmpqso;
    gint dirty_save, dirty_stats, dirty_statsf;
    gint readonly;
    enum modes mode;  
    gint bandmulti;
    gchar *operator;

    gint psect;
    gchar *stxeq,*spowe;        /* TM-255 + gi7b, 300 */ 
    gchar *srxeq,*sante,*santh; /* TM-255, GW4PTS, 60;800 */
    gchar *mope1,*mope2;    /* OK1XDF, OK1MZM, OK1ZIA */
    gchar *remarks;

    struct stats *stats;
    /* file */
    FILE *swap;
    gint saveid,ignoreswap;

    struct fifo *swapfifo, *unfi, *statsfifo;
    GPtrArray *qs, *oqs;
    enum last_items last_item;
    gchar *skedqrg;
    enum ctrlstates ctrlstate;
    gchar *ctrlsp;
    enum spymodes spymode;
    GPtrArray *spypeers; /* of struct spypeer */

};


struct contest {
      /* EDI & contest properties */
    gchar *tname;           /* A1 Contest - MMC */
    gchar *tdate;           /* TODO */
    gchar *pcall;           /* DL/OK1KRQ/P */
    gchar *pclub;           /* OK1KRQ */
    gchar *pwwlo;           /* JN69HN12 */
    gchar *pexch;  
    gchar *default_rs,*default_rst;


      /* EDI only properties */
    gchar *padr1,*padr2;    /* Lite */
    gchar *rname;           /* Roman Staif */
    gchar *rcall;           /* OK1XST */
    gchar *radr1,*radr2;  /* Pod svabinami  */ 
    gchar *rpoco,*rcity,*rcoun;  /* 30100, Plzen, CZECHIA */
    gchar *rphon,*rhbbs;    /* 0603123456 , OK0POK */ 
    
      /* contest properties */
    gint  rstused;          /* no,used,optional */
    gint  qsoused;          /* no,used,optional */
    gint  wwlused;          /* no,used,optional */
    gint  wwltype;          /* short,normal,extended */
    gint  excused;          /* no,used,optional */
    
    
      /* points calculation */
    gint qsomult;
    gint wwlbonu,wwlmult;
    gint dxcbonu,dxcmult;  
    gint excbonu,excmult;
    gint qsop_method;            /* 1..12 */
    gint total_method;       /* 1..2 */
    gint modesep;		/* distinguish mode for multiplier calc */
    
    GPtrArray *bands;
    GHashTable *bystamp;  /* key=source, val=GIndexArray */
                          /* GIndexArrays are NOT sorted by ser_id but only by stamp */
    GPtrArray *qs;
   
     /* disk */
    FILE *descfile;     /* ~/tucnak/.../desc */ 
    FILE *logfile;      /* ~/tucnak/.../log */ 
    gchar *directory;   /* /home/ok1zia/tucnak/20021113.2 */
    gchar *cdate;       /* 20021113 without .X */ 
     /* network */
    int redraw_timer_id;
     /* autosave */
    int as_disk_qsonr, as_disk_time, as_floppy_qsonr, as_floppy_time;
    
    int tx;
    
    gint last_cq_timer_id;
    struct cq *last_cq;
    GHashTable *hicalls; /* highlighted callsigns in shell */
    int qrv;             /* bit array of used bands */

};

extern struct contest *ctest;
extern struct band *aband;
struct conn;

int init_ctest(void);
int new_ctest(char *tdate); /* called after filling data members by refresh_... */
void free_ctest(void);
struct band *init_band(struct config_band *, GHashTable *opt_band);
void free_band(struct band *b);
struct band *find_band_by_pband(char *pband);
struct band *find_band_by_bandchar(char bandchar);
struct band *init_qrv_bands(void);
int write_qso_to_swap(struct band *b, struct qso *q);
void add_qso(struct band *b, struct qso *q);
struct qso *get_qso(struct band *b, gint i);
struct qso *get_qso_by_callsign(struct band *b, gchar *callsign);
struct qso *get_qso_by_id(struct band *b, gchar *source, gint ser_id);
struct qso *get_qso_by_qsonr(struct band *b, int qsonr);
void add_error(struct band *b, gchar *remark);
void activate_band(struct session *ses, struct band *b);
int add_tmpxchg(struct band *band, gchar *xchg);
int add_swap(struct band *band, gchar *s);
void clear_tmpqsos(struct band *b);
void default_rst_to_tmpqsos(struct band *b);

int export_all_bands_edi(void);
int export_all_bands_report(void);
int export_all_bands_html(void);
int export_all_bands_titlpage(void);
struct config_band *get_config_band_by_bandchar(char bandchar);
struct config_band *get_config_band_by_pband(char *pband);
struct config_band *get_config_band_by_qrg(int qrg); /* kHz */
void foreach_source_recalc_ser_id(gpointer key, gpointer value, gpointer data);
void foreach_source_qsort_by_stamp(gpointer key, gpointer value, gpointer data);
void foreach_source_print(gpointer key, gpointer value, gpointer data);

void add_qso_to_index(struct qso *q, int qsort_if_needed);
void remove_qso_from_index(struct qso *q);
gchar *get_latests_str(void);
int compare_stamp(const void *a, const void *b);
void compute_qrbqtf(struct qso *q);
GPtrArray *get_band_qs(struct band *band, gchar *str);
GPtrArray *get_oband_qs(struct band *band, gchar *str);
gchar *find_wwl_by_oband(struct band *oband, gchar *call);
int load_ctest_from_mem(struct contest *ctest, gchar *datedir, GHashTable *hash);
void qso_mark_as_error(struct band *b, gint i);
int get_psect_int(char *psect);
void dump_qso(struct qso *q, char *desc);
void invalidate_tmpqso(struct band *b, struct qso *q);


/* edi.c */
int save_all_bands_txt(int is_autosave);
int check_autosave(void);
void load_contest_edi(gchar *date, int edi);
void add_qso_str1(GString *gs, struct qso *q, struct band *b);
void add_qso_str2(GString *gs, struct qso *q, struct band *b);
void add_qso_str3(GString *gs, struct qso *q, struct band *b);
void import_edi (struct session *ses, char *filename);
void import_swap(struct session *ses, char *filename);
void dump_all_sources(struct contest *ctest);


/* adif.c */

int export_all_bands_adif(void);
void import_adifx(struct session *ses, char *filename);
int import_adif(struct session *ses, char *filename);

/* regex.c */

#define MAX_MATCHES 10

int regcmp(char *string, char *regex);
int regcmpi(char *string, char *regex);
int regmatch(char *string, char *regex, ...);


/* subwin.c */

enum sw_type { SWT_QSOS, SWT_LOG, SWT_PIPE, SWT_TALK, 
               SWT_DXC, SWT_SKED, SWT_SWAP, SWT_UNFI,
               SWT_STAT};

struct subwin {
    gchar *title;
    enum sw_type type;
    gint x,y,w,h,hh;
    gint offset,cur,ho;
    gint ontop,focus;
    gint titl1,titl2;

    int  (*kbd_func)(struct subwin *, struct event *ev, int fw);
    int  (*mouse_func)(struct subwin *, struct event *ev, int fw);
    void (*redraw)(struct subwin *);
    void (*check_bounds)(struct subwin *);
    void (*raise)(struct subwin *);
    GPtrArray *lines;
    int eol, maxlen, dirty;
    
    struct inputln *il; /* optional */
    
      /* subwins having pipes */
    gint read_fd, write_fd; 
    gint pid;
    struct winsize ws;
    GPtrArray *high; /* of gchar* */

    gchar *command;
    gint respawn_time;

    /* fifo is foreign key mostly to global variable */
    struct fifo *fifo;
    
};

struct config_subwin{
    int nr;
    enum sw_type type;
    gchar *command;
    gchar *autorun;
    int respawn_time;
};


struct subwin *new_subwin(struct session *ses, enum sw_type type, gchar *title,
         /* optional */ void (*enter)(void *,gchar *));
void free_subwin(struct session *ses, struct subwin *sw);

int sw_add_line(struct subwin *sw, gchar *line, int eol);
int sw_add_block(struct subwin *sw, gchar *data);


int sw_default_func(struct subwin *sw, struct event *ev, int fw);
int sw_all_func(struct session *ses, struct event *ev, int fw);
int sw_focus_func(struct session *ses, struct event *ev, int fw);
int sw_ontop_func(struct session *ses, struct event *ev, int fw);
struct subwin *find_sw_ontop(struct session *ses);
void sw_set_focus(struct session *ses ); 
void sw_unset_focus(struct session *ses);
struct subwin *sw_set_ontop(struct session *ses, int n); /* n abs */
struct subwin *sw_totop_next(struct session *ses, int n); /* n = +-1 */
void sw_set_dirty(struct fifo *fifo);
void sw_unset_dirty(struct fifo *fifo);
struct config_subwin *get_config_sw_by_number(GPtrArray *sws, int nr);

void sw_default_redraw(struct subwin *sw);
void sw_check_len(struct subwin *sw);
void draw_titles(struct session *ses, int col_active, int col_passive);
int sw_line_is_highlighted(struct subwin *sw, gchar *c);


int  sw_qsos_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_qsos_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_qsos_redraw(struct subwin *sw);
void sw_qsos_check_bounds(struct subwin *sw);
int show_qs(void);
void sw_qs_redraw(void);

/*int  sw_il_kbd_func(struct subwin *sw, struct event *ev, int fw);
void sw_il_redraw(struct subwin *sw);
void sw_il_check_bounds(struct subwin *sw);
void sw_il_enter(void *enterdata, gchar *str);
*/
int  sw_fifo_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_fifo_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_fifo_redraw(struct subwin *sw);
void sw_fifo_check_bounds(struct subwin *sw);
  
int  sw_pipe_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_pipe_redraw(struct subwin *sw);
void sw_pipe_check_bounds(struct subwin *sw);
void sw_pipe_enter(void *enterdata, gchar *str);
int  sw_pipe_run(struct subwin *sw, char *cmd);
void sw_pipe_read_handler(void *data);
void sw_pipe_write_handler(void *data);
void sw_pipe_exception_handler(void *data);
void sw_pipe_kill(struct subwin *sw);
void sw_pipe_match(gpointer acall, gpointer nic, gpointer astr);
int sw_pipe_hihglight(struct subwin *sw, char *str);
int sw_pty_run(struct subwin *sw, char *cmd);
int sw_pipe_run(struct subwin *sw, char *cmd);
  
void sw_talk_enter(void *enterdata, gchar *str);
void sw_talk_read(gchar *);

int sw_dxc_kbd_func(struct subwin *sw, struct event *ev, int fw);
int sw_dxc_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_dxc_redraw(struct subwin *sw);
void sw_dxc_check_bounds(struct subwin *sw);
    
void sw_sked_read(gchar *str, int from_my);
  
int  sw_unfi_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_unfi_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_unfi_redraw(struct subwin *sw);
void sw_unfi_check_bounds(struct subwin *sw);

int  sw_stat_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_stat_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_stat_redraw(struct subwin *sw);
void sw_stat_check_bounds(struct subwin *sw);
void sw_stat_raise(struct subwin *sw);

  
    /* cwdb.c */
  
extern struct cw *cw;  
  
struct cw_item{
   gchar *wwl0, *wwl1;    
   gint stamp0, stamp1;
   gint qrv;                /* bit array, lsb = A = 50MHz etc. Since 1.15 */
};

struct wc_item{
   gchar *call0, *call1;    
   gint stamp0, stamp1;
};

struct cw{
    THashTable *cw; /* key=call, value=cw_item */
    GHashTable *wc;
    int latest;
};

struct qs{
    GPtrArray *result;
    gchar *str;
}; 

struct cw *init_cw(void);
void free_cw(struct cw *cw);

gint get_cw_size(struct cw *cw);
gint get_wc_size(struct cw *cw);

void load_one_cw(struct cw *cw, gchar *s);
int load_cw_from_file(struct cw *cw, gchar *filename);
void read_cw_files(struct cw *cw);
int save_cw_string(struct cw *cw, GString *gs);
int save_cw_into_file(struct cw *cw, gchar *filename);

void add_cw(struct cw *cw, gchar *call, gchar *wwl, gint stamp, gchar *qrv);
gchar *find_wwl_by_call(struct cw *cw, gchar *call);

void add_wc(struct cw *cw, gchar *wwl, gchar *call, gint stamp);
gchar *find_call_by_wwl(struct cw *cw, gchar *wwl);

gchar *find_qrv_str_by_call(struct cw *cw, gchar *call);

GPtrArray *get_cw_qs(GPtrArray *result, gchar *str);
int compare_gstring(const void *a, const void *b);

void update_cw_from_band(struct cw *cw, struct band *band);
void update_cw_from_ctest(struct cw *cw, struct contest *ctest);

char *my_strstr(const char *, const char *);
char *my_strcasestr(const char *phaystack, const char *pneedle);

   /* dwdb.c */

extern struct dw *dw;

struct dw_item{
    gchar *wwl0, *wwl1;   /* center of activity (optional),  */
                            /* center of dxcc (geometric)     */
    GHashTable *wwls;      /* all wwls valid for this dxcc */
};

struct wd_item{
    gchar *dxc0, *dxc1;
};

struct dw{
    GHashTable *pd;  /* key=prefix "DF", value=dxcc (main prefix) "DL" */
    GHashTable *dw;  /* key=dxcc "DL", value=dw_item */
    GHashTable *wd;  /* key=big wwl, "JN69" */
};


struct dw *init_dw(void);
void free_dw(struct dw *dw);

gint get_pd_size(struct dw *dw);
gint get_dw_size(struct dw *dw);
gint get_wd_size(struct dw *dw);

gchar *safe_fgets(GString *gs, FILE *f, int stripcomment);
void add_pd(struct dw *dw, gchar *prefix, gchar *dxc);
struct dw_item *add_dxc(struct dw *dw, gchar *dxc, gchar *wwl0, gchar *wwl1);
void add_dw(struct dw_item *dxci, gchar *dxc, gchar *wwl);
void add_wd(struct dw *dw, gchar *wwl, gchar *dxc);
    
int load_dw_from_file(struct dw *dw, gchar *filename);
int load_cty_from_file(struct dw *dw, gchar *filename);
void read_dw_files(struct dw *dw);


int wwl_is_ok_by_call(struct dw *dw, gchar *wwl, gchar *call);
int get_susp(struct cw *cw, struct dw *dw, gchar *call, gchar *wwl);
gchar *find_wwl_by_dxc(struct dw *dw,  gchar *dxc);
gchar *find_dxc_by_wwl(struct dw *dw, gchar *wwl);
char *get_dxcc(struct dw *dw, char *buf, char *call);

gboolean free_gpointer_item(gpointer key, gpointer value, gpointer user_data);


/* net.c */

#define C0(item) (item?item:"")

extern struct net *net;

enum net_state { 
    NS_INIT=0, 
    NS_CONNECTING,
    NS_CONNECTED,
    NS_WAIT_ACK,
    NS_DISCONNECTED,
    NS_DEAD,  /* conn removed immediately */
};

extern char *ns_desc[];

struct conn{
    struct sockaddr_in sin;   /* {sin_port, sin_addr.s_addr } */
    int sock; 
    enum net_state state;
    GString *wrbuf, *rdbuf;
    int relseq;
    int timer;
    gchar *remote_id;
    gchar *remote_ac;
    gchar *operator;
    int is_same_ctest;
    int replicating;     /* replicating from other station in progress, huge amout of QSOs */
};

struct net{
    struct sockaddr_in my; /* IP of first interface (except lo) in alphab. order. host byteorder */
    gchar *myid; /* 0.0.0.0:0 or 192.168.1.97:55555 */
    struct sockaddr_in global; /* global master */
    time_t global_expire; 
    int udpsock;   /* listen for announcement, -1 unused */
    int tcpsock;   /* listen for slaves, -1 unused */
    int udptimer_id; 
    int udptimer_period;
    struct sockaddr bcast_addr[MAX_INTERFACES];
    int max_addrs;

    struct conn *master;
    GPtrArray *peers; /* struct conn[] */
    gchar *allpeers; /* separated by semicolon */
    void (*peerfunc)(void);

};

struct net *init_net(void);
void free_net(struct net *net);

int init_net_udp (struct net *net);
int init_net_tcp (struct net *net);
int init_net_ifaces(struct net *net);
void free_net_udp(struct net *net);
void free_net_tcp(struct net *net);
void free_net_ifaces(struct net *net);
void free_conn(struct conn *conn);

void udp_read_handler(void *);
void udp_exception_handler(void *);
void udp_timer(void *data);

void tcp_read_handler(void *);
void tcp_write_handler(void *);
void tcp_exception_handler(void *);
void tcp_accept_handler(void *);

void rel_write(struct conn *conn, gchar *s);
void rel_write_all(gchar *s);
void rel_read(struct conn *conn, gchar *s);

void tcp_set_state(struct conn *conn, enum net_state state);

void tcp_connect(struct conn *conn);
void tcp_disconnect(struct conn *conn);
void tcp_kill(struct conn *conn);
int cmp_sin(struct sockaddr_in *a, struct sockaddr_in *b);
void net_send_id(void);
void net_send_ac(void);
void net_send_operator(void);
void net_test_same_contest(struct conn *conn, gchar *ac_text);
void compare_remote_with_me(gpointer key, gpointer value, gpointer data);
void qso_from_net(struct conn *conn, gchar *c);
void replicate_qso(struct conn *conn, struct qso *q);
gchar *get_timer_str(struct conn *conn);
void send_config_request(struct terminal *term, int no, struct session *ses);
void send_cwdb_request(struct terminal *term, int no, struct session *ses);
int conn_prod_state(struct conn *conn);
int some_replicating(struct net *net);
struct conn *find_conn_by_remote_id(gchar *remote_id);

    /* loc.c */
struct gfx;

double qth(char *qth,int width);
char *compute_wwl4(char *s, double h, double w);
char *mkwwl4(char *buf, int w, int h);
char *hw2loc(char *buf, double w, double h);
char *x2gramin(char *buf, double x, char *signs);

int qrbqtf(char *myqth,char *recqth,double *qrb,double *qtf,char *str);
int hw2qrbqtf(double h1, double w1, double h2, double w2, double *qrb, double *qtf);

int qrbqtf2hw(double h1, double w1, double qrb, double qtf, double *h2, double *w2);
#ifdef HAVE_SDL
int xy2qrbqtf(struct gfx *gfx, int x, int y, double *qrb, double *qtf);
int xy2hw(struct gfx *gfx, int x, int y, double *h, double *w);
#endif

int qsopwr( char *myqth, char *recqth);
int qthwr(char *qth,int width);
void qrb_qtf_int(gchar *wwl, int *qrb_int, int *qtf_int);
int iaru_round(double qrb);



    /* fifo.c */ 
struct fifo{
    int x,y,w,h,maxlen,ho;
    int withouttime;
    GPtrArray *items;
};

#define log_adds(s) fifo_adds(glog, s) 

extern struct fifo *glog, *gtalk, *gsked;
struct fifo *init_fifo(int maxlen);
void fifo_resize(struct fifo *log, int x, int y, int w, int h);
void free_fifo(struct fifo *fifo);
void drop_fifo(struct fifo *fifo);
void fifo_adds(struct fifo *fifo, gchar *str);
void fifo_addf(struct fifo *fifo, char *m, ...); 
void fifo_addfq(struct fifo *fifo, char *m, ...); 
void log_addf(char *m, ...); 
int fifo_len(struct fifo *fifo);
gchar *fifo_index(struct fifo *fifo, int);
int save_fifo_to_file(struct fifo *fifo, gchar *filename);
int load_fifo_from_file(struct fifo *fifo, gchar *filename, int drop);
void log_draw(struct fifo *fifo);


    /* wizz.c */

struct wizz_item{
    gchar *tname,*pexch;
    gint rstused,qsoused,wwlused,wwltype/* ? */,excused;
    gint shorttonormal, insertpexch;
    gchar *pexchtype;
    gint qsomult, minqsop, maxqsop, qsop_method;
    gint wwlbonu, wwlmult, dxcbonu, dxcmult;
    gint excbonu, excmult, total_method;
};

struct wizz{
    GPtrArray *items; /* struct wizz_item */
};

extern struct wizz *wizz;

struct wizz *init_wizz(void);
void free_wizz_item(struct wizz_item *wi);
void free_wizz(struct wizz *wizz);
struct wizz_item *find_wizz(struct wizz *wizz, gchar *tname);

int load_wizz_from_file(struct wizz *wizz, gchar *filename);
void read_wizz_files(struct wizz *wizz);

struct wizz_item *get_wizz(struct wizz *wizz, int i);
struct wizz_item *find_wizz(struct wizz *wizz, gchar *tname);

    /* cwdaemon.c */

struct cwdaemon {
    int sock;
    gint speed, weight;
    gint spkvol, spkdev;
};

extern struct cwdaemon *cwda;

struct cwdaemon *init_cwdaemon(void);
void free_cwdaemon(struct cwdaemon *cwda);

void cwdaemon_read_handler (struct cwdaemon *cwda);
void cq_timer_cw1(void *data);
void cq_cw_wait(struct cq *cq);
void cq_timer_cw2(void *data);
void cwdaemon_send_defaults(struct cwdaemon *cwda);
void cwdaemon_cw_string(struct cwdaemon *cwda, gchar *text);
void cwdaemon_cw_char(struct cwdaemon *cwda, gchar c);
void cwdaemon_abort(struct cwdaemon *cwda);
void cwdaemon_safe_abort(struct cwdaemon *cwda);
void cwdaemon_ptt(struct cwdaemon *cwda, int ptt);
void cwdaemon_ssbway(struct cwdaemon *cwda, int ssbway);
void cwdaemon_speed(struct cwdaemon *cwda, int wpm);
void cwdaemon_qrq(struct cwdaemon *cwda, int qrq);
void cwdaemon_qrs(struct cwdaemon *cwda, int qrq);
void cwdaemon_tone(struct cwdaemon *cwda, int tone);
void cwdaemon_weight(struct cwdaemon *cwda, int weight);


struct cq{
    int nr;
    int type; /* MOD_CW_CW, MOD_SSB_SSB */

    gchar *cw_str;
    int    cw_speed;  /* 0 = unused */
    int    cw_repeat; /* 0 or 1 */
    int    cw_ts;     /* tenth of second */
    int    cw_allowifundef;
    
    gchar *ssb_file;
    int    ssb_repeat;/* 0 or 1 */
    int    ssb_ts;    /* tenth of second */
};       

struct cq *init_cq(void);
struct cq *get_cq_by_number(GPtrArray *cqs, int nr);
void free_cq (struct cq *cq);

int cq_run_cw(struct cq *cq);
int cq_run_ssb(struct cq *cq);
int cq_run_by_number(int no);
int cq_abort(int abort_rec);
void cq_timer_cw(void *data);
void cq_timer_ssb1(void *data);
void cq_ssb_wait(struct cq *cq);
void cq_timer_ssb2(void *data);

gchar *convert_cq(struct cq *cq);
gchar *convert_esc(gchar *format, int *undef); 
        

    /* cwwindow.c */

void cwwindow_func(struct window *win, struct event *ev, int fwd);


    /* ssbd.c */
struct ssbd {
    int sock;
    int recording;

    char *user;
    int umask;
};

extern struct ssbd *ssbd;

struct ssbd *init_ssbd(void);
void free_ssbd(struct ssbd *ssbd);

void ssbd_play_file(struct ssbd *ssbd, gchar *filename);
void ssbd_rec_file(struct ssbd *ssbd);
void ssbd_abort(struct ssbd *ssbd, int abort_rec);
void ssbd_safe_abort(struct ssbd *ssbd);
int ssbd_recording(struct ssbd *ssbd);
int ssbd_callsign(struct ssbd *ssbd, char *call);


    /* cor.c */
        
#ifdef HAVE_SDL 

#define COR_H 36
#define COR_W 18


struct cpoint{
  short int w,h;
  char c;
}__attribute__((packed));

struct corarray{
    struct cpoint *data;
    int len;
    int size;
};

struct cor{
    struct corarray *hash[COR_H][COR_W];
};

struct corarray *corarray_new(void);
void corarray_add(struct corarray *ca, struct cpoint *cp);
void corarray_free(struct corarray *ca);

struct cor *load_cor(char *filename);   
void free_cor(struct cor *cor);
void compute_gfxstats(struct band *b);
extern double maxcnt;
extern double gst[360];

#endif
	
    /* gfx.c */


#define MY_PI 3.14159265358979323846
#define R_EARTH (111.2*180.0/MY_PI)
/* 6371.2907 */
/* #define R_EARTH 6373.4 */
#define FONT_TRANSP 1
#define FONT_CENTER 2 

#ifdef HAVE_LIBPNG
#define SHOTEXT "png"
#define SHOTSAVE do_png_save
#else
#define SHOTEXT "bmp"
#define SHOTSAVE SDL_SaveBMP
#endif

#define sqr(x) ((x)*(x))       

struct takeoff{
    int from, to;
    int value;
};

#ifdef HAVE_SDL

struct zoom{
    int id;
    double value;
    SDL_Surface *bkg;
    double qrbring;
    int showbigwwls;
};

struct gfx{
    int is_graphics;
    int func_timer_id;
    struct cor *cor;  
    SDL_Surface *screen,*mapcache;
    SDL_Rect *scr; /* clipping rect, pointer inside screen (FK) */
    SDL_Rect *info;
    SDL_Rect *title;
    SDL_Rect *map;
    int dirty,dirtyrot;      
    int lines, qsos, gain, wwls, wwlnames, cors, star, qrv, workedwwl, shrot;
    /*  L      O     G     W     N         B     S     V    K */

    int konec;
    int gr[16];
    int yellow,green,red,magenta,mapbg,wkmap;
    int bpp, draw;
    SDL_Color colors[256];

    struct zoom *zoom;
    int zoomint;

	double myh, myw;
    gchar *pwwlo;
    struct qso *minq;

    int m_x, m_y;
    int o_x, o_y;
    
    /*gchar *title_str;*/
    SDL_Surface *icon;
    
};

/* gfx_png.c */
int do_png_save(SDL_Surface * surf, char * fname);

/* public */
extern struct gfx *gfx;
extern void (*fast_putpixel)(SDL_Rect *clip, int x, int y, int color);

struct gfx *init_gfx(void);
void free_gfx(void);
int gfx_func(void *xxx);
int gfx_reload(struct gfx *gfx);
int gfx_add_qso(struct qso *qso);
int gfx_set_title(gchar *title);
int makecol(int r, int g, int b);

/* private */        
void compute_cache(struct qso *qso);
struct qso *find_nearest(struct band *b, int mouse_x, int mouse_y);
void invalidate_cache(struct band *b);
void invalidate_bkg(struct zoom *zoom);

int plot_cor(void);
int plot_grid(void);
int plot_star(void);
void plot_cross(int x, int y, int color);
int plot_qso(struct qso *qso);
int plot_info(struct qso *qso);
int plot_qrb_qth(void);
void plot_gfxstats(void);

int gfx_redraw(void);
void gfx_update_qth(void);
void mouse_moved(void);
void clear_gfxstats(void);
int fontwidth(char *text);
int fontheight(char *text);
int for_printing(struct gfx *gfx, int on);
int fast_getpixel32(int x, int y);

int FilterEvents(const SDL_Event *ev);
/*void textout(SDL_Rect *clip, int x, int y, int color, int transparent, char *s); */


/* font.c */

#define FONT_TRANSP 1
#define FONT_CENTER 2
#define FONT_RIGHT  4
#define FONT_SYNC   8

void fontout(SDL_Rect *clip, int x, int y, int color, int flags, char *s);
void fontoutf(SDL_Rect *clip, int x, int y, int color, int flags, char *m, ...);

#define q0(item) (item)?(item):""

#endif /* HAVE_SDL */


/*struct GHT                                                              
{                                                                               
  gint size;                                                                    
  gint nnodes;                                                                  
  guint frozen;                                                                 
  gpointer **nodes;                                                            
  GHashFunc hash_func;                                                          
  GCompareFunc key_compare_func;                                                
};*/                                                                              



/* dxc.c */

struct spot{
    double qrg;
    gchar *callsign,*from,*text;
    int zulu;
    time_t expire,endbold;
    struct spot *prev,*next;
};

struct spotdb{
    struct spot **first;
    struct spot **cur;
    int timer_id;
};

extern struct spotdb *spotdb;

struct spotdb *init_spotdb(void);
void free_spotdb(struct spotdb *spotdb);

struct spot *dxc_parse_spot(gchar *str);
void free_spot(struct spot *spot);
int dxc_read_spot(gchar *str);
void dxc_seek(struct spotdb *spotdb, int value);

void dxc_assert_spot(struct spot *spot);
void dxc_assert(struct spotdb *spotdb, int bi);
int dxc_remove_expired(void);
void dxc_timer(void *xxx);

    /* namedb.c */
  
struct namedb{
    GHashTable *names; /* key=rawcall, value=name */
    GHashTable *dummy;
};

extern struct namedb *namedb;  
  
struct namedb *init_namedb(void);
void free_namedb(struct namedb *namedb);
void read_namedb_files(struct namedb *namedb);
gchar *find_name_by_call(struct namedb *namedb, gchar *call);
int save_namedb_into_file(struct namedb *namedb, gchar *filename);
void add_namedb(struct namedb *namedb, gchar *call, gchar *name);
gint get_namedb_size(struct namedb *namedb);

   
/* ebw.c */

struct dbfhdr{
    char ver; /* mostly 03 */
    char year,month,day;
    guint32 records;
    guint16 hdrsize, recsize;
    char padding[20];
    /* total 32 bytes */
}__attribute__((packed));


struct dbffield{
    char name[11]; /* \0 terminated */
    char type; /* Char,Date YYYYMMDD,Float,Logical TFYN,Memo,Numeric */ 
    guint32 disaplacement;
    char len, decimal;
    char padding[14];
    /* total 32 bytes */
}__attribute__((packed));


int load_ebw_from_file(struct cw *cw, struct namedb *namedb, char *filename);
int read_ebw_files(struct cw *cw, struct namedb *namedb);

/* sdev.c */

#define SDINIT char sdlen=0;int sdret;char sdbuf[256]
#define SDADD(a) sdbuf[sdlen++]=(a)
#define SDADD2(a) sdbuf[sdlen++]=(a)&0xff;sdbuf[sdlen++]=(a)>>8
#define SDPLUS(sd,cmd) sdret=sd_protplus((sd),(cmd),sdbuf,&sdlen)

#define SDMAXLEN 300
#define SDFCE   1
#define SDADR   2
#define SDLEN   3

enum conntype{
    CT_TTYS, CT_UDP, CT_TCP
};

struct sdev;

struct sjob{
    int retry; 
    void (*callback)(struct sjob *sjob);
    void *param;
    int fce;
    char *req;
    unsigned char *data;
    int len,ret;
    int timer_id;       
    int state;
    struct sdev *sdev;          /*foreign*/
    struct sjob *prev,*next;    /*foreign*/
};

struct sconn{
    enum conntype type;
    int fd;
    int refcnt;

    gchar *ttys_filename;
    gchar *ip_hostname;
    int ip_port;
    
    struct sjob *sjob;  /* double linked list */
                         /* !=NULL means busy */

    int rawi;    /* members for read handler */
    unsigned char rawdata[SDMAXLEN];
    void *param;
};

struct sdev{
    struct sconn *sconn;
    char saddr;
    int timeout_ms;
};

struct sdevlist{
    GPtrArray *sdevs;   /*of struct sdev*/
    GPtrArray *sconns;  /*of struct sconn*/
};

struct sdevlist *sdevlist;

struct sdevlist *init_sdevlist(void);
int free_sdevlist(struct sdevlist *sdevlist);
void check_sdevlist(struct sdevlist *sdevlist);

struct sdev *sd_open_ttys(struct sdevlist *sdevlist, char saddr, char *filename, int timeout_ms);
struct sdev *sd_open_udp(char *hostname, int udpport);
struct sdev *sd_open_udp(char *hostname, int tcpport);
int free_sd(struct sdevlist *sdevlist, struct sdev *sd);

char *sd_err(int err);
int sd_send(struct sdev *sd, char fce, char *data, char len);
int sd_aprot(struct sdev *sd, char fce, char *data, char len, void (*callback)(struct sjob *sjob), void *param);
void sc_read_handler(struct sconn *scon);
void sc_timeout(struct sconn *sc);

void remove_sjob(struct sjob *sjob);
int free_sjob(struct sjob *sjob);

/* rotar.c */

struct sdev;

struct config_rotar{
    gint nr;

    gint rot_type,rot_port,rot_saddr,rot_timeout_ms,rot_beamwidth;
    gchar *rot_filename,*rot_hostname,*rot_desc;
};

struct rotar{
    /* config */
    struct sdev *sdev;
    int step;
    int rotchar; /* A, B, ... */
    gchar *desc;
    int beamwidth; /* in degrees */
    
    /* device versions */
    int verh, verl, identa;
    
    /* state */
    int qtf, elev;
    int timer_id; /* time between two command to prevent high cpu load */

    int color; /* color of arrow in polar map */
};

GPtrArray *rotars;
struct rotar *rotar;


int init_rotars(void);
int free_rotars(void);

struct rotar *init_rotar(struct config_rotar *cfg);
void free_rotar(struct rotar *rot);
int rot_seek(struct rotar *rot, int uhel);
struct config_rotar *get_config_rotar_by_number(GPtrArray *rotars, int nr);
struct rotar *get_rotar(int nr);
void menu_rotar(struct terminal *term, void *xxx, struct session *ses);
int rot_update_colors(struct gfx *gfx);
void rotar_timer(void *xxx);

/* hash.c */

void hash_safe_insert(GHashTable *table, gchar *key, gchar *value);
gboolean free_gstr(gpointer key, gpointer value, gpointer user_data);
void free_hash(GHashTable *hash);


/* control.c */

enum wt_type{
    WT_CLEAR=0,
    WT_CALLSIGN,
    WT_RSTS,
    WT_RSTR,
    WT_QSONRS,
    WT_QSONRR,
    WT_EXC,
    WT_LOCATOR,
    WT_OPERATOR,
    WT_REMARK       /* unused */
};

struct spypeer{
    gchar *callsign;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark, *operator;
    
    gint peertx;
    gchar *inputline;

    gchar *peerid;
};


void menu_forcerun(struct terminal *term, void *d, struct session *ses);
void menu_spy(struct terminal *term, void *d, struct session *ses);
int can_tx(struct band *b);
int can_cq(struct band *b);
void menu_grabband(struct terminal *term, void *d, struct session *ses);
void net_grab(struct band *b, enum ccmd ccmd, char *netid);
void ctrl_back(struct band *b);
void wkd_tmpqso(struct band *band, enum wt_type type, gchar *call);
void peer_tx(struct band *band, int tx); 
void send_inputline(struct band *band);
struct spypeer *init_spypeer(GPtrArray *sps, gchar *peerid);
struct spypeer *get_spypeer_by_peerid(GPtrArray *sps, gchar *peerid);
void free_spypeers(GPtrArray *sps);
void clear_spypeer(struct spypeer *sp);
void send_spypeer_request(struct terminal *term, int no, struct session *ses);


/* html.c */
gchar *qh(GString *gs, gchar *s);


#endif /* __HEADER_H */     
