/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

/******************** MISC OPTIONS *******************************/


char loglines_str[MAX_STR_LEN],skedshift_str[MAX_STR_LEN],startbandchar_str[MAX_STR_LEN];
char gfx_x_ch_str[MAX_STR_LEN],gfx_y_ch_str[MAX_STR_LEN];
char gfx_x_px_str[MAX_STR_LEN],gfx_y_px_str[MAX_STR_LEN];

void refresh_misc_opts(void *xxx)
{
    struct config_band *confb;
    int gfx_x_ch, gfx_y_ch, gfx_x_px, gfx_y_px;
    int new_x, new_y, resize;

    STORE_SINT(cfg,loglines);
    STORE_SINT(cfg,skedshift);

    confb=get_config_band_by_bandchar(startbandchar_str[0]);
    if (confb){
        CONDGFREE(cfg->startband);
        cfg->startband=g_strdup(confb->pband);
    }
    gfx_x_ch=atoi(gfx_x_ch_str);
    gfx_y_ch=atoi(gfx_y_ch_str);
    gfx_x_px=atoi(gfx_x_px_str);
    gfx_y_px=atoi(gfx_y_px_str);
    
    new_x=800;
    new_y=600;
    resize=0;
    if (gfx_x_ch>10 && gfx_y_ch>10){
        if (gfx_x_ch*FONT_W!=cfg->gfx_x ||
            gfx_y_ch*FONT_H!=cfg->gfx_y){
            new_x=gfx_x_ch*FONT_W;
            new_y=gfx_y_ch*FONT_H;
            resize++;
        }
    }
    if (gfx_x_px>100 && gfx_y_px>100){
        if (gfx_x_px!=cfg->gfx_x ||
            gfx_y_px!=cfg->gfx_y){
            new_x=gfx_x_px;
            new_y=gfx_y_px;
            resize++;
        }
    }
    if (resize && new_x<=2048 && new_y<=2048) {
        cfg->gfx_x=new_x;
        cfg->gfx_y=new_y;
#ifdef HAVE_SDL        
        sdl_setvideomode(new_x, new_y, 0);
#endif
        resize_terminal(CBA0);
    }
}

char *misc_opts_msg[] = {
    CTEXT(T_LOGLINES),  /* 0 */
    CTEXT(T_SKEDSHIFT),
    CTEXT(T_STARTBAND),
    CTEXT(T_GFX_X_CH),
    CTEXT(T_GFX_Y_CH),
    CTEXT(T_GFX_X_PX),  /* 5 */
    CTEXT(T_GFX_Y_PX),
    "", /* OK */       
    "", /* Cancel */
};
void misc_opts_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, misc_opts_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, misc_opts_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, misc_opts_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, misc_opts_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, misc_opts_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, misc_opts_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, misc_opts_msg + 3, dlg->items + 3, 2, &max);
    min_group_width(term, misc_opts_msg + 3, dlg->items + 3, 2, &min);
    max_group_width(term, misc_opts_msg + 5, dlg->items + 5, 2, &max);
    min_group_width(term, misc_opts_msg + 5, dlg->items + 5, 2, &min);
    
    max_buttons_width(term, dlg->items + 7, 2, &max);
    min_buttons_width(term, dlg->items + 7, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, misc_opts_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, misc_opts_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, misc_opts_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, misc_opts_msg + 3, dlg->items + 3, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, misc_opts_msg + 5, dlg->items + 5, 2, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +7, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, misc_opts_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, misc_opts_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, misc_opts_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, misc_opts_msg + 3, dlg->items + 3, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, misc_opts_msg + 5, dlg->items + 5, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +7, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}



void misc_opts(union cba_t cba)
{
    struct dialog *d;
    int i;
    struct config_band *confb;

    g_snprintf(loglines_str, MAX_STR_LEN, "%d", cfg->loglines);
    g_snprintf(skedshift_str, MAX_STR_LEN, "%d", cfg->skedshift);
    
    confb=get_config_band_by_pband(cfg->startband);
    if (!confb) confb=(struct config_band *)g_ptr_array_index(cfg->bands,0);
    startbandchar_str[0]=toupper(confb->bandchar);
    startbandchar_str[1]='\0';

    dbg("gfx_x=%d gfx_x=%d %%=%d %d\n", cfg->gfx_x, cfg->gfx_y, cfg->gfx_x%FONT_W, cfg->gfx_y%FONT_H);
    if (cfg->gfx_x%FONT_W!=0 || cfg->gfx_y%FONT_H!=0){
        strcpy(gfx_x_ch_str, "");
        strcpy(gfx_y_ch_str, "");
    }else{
        g_snprintf(gfx_x_ch_str, MAX_STR_LEN, "%d", cfg->gfx_x/FONT_W);
        g_snprintf(gfx_y_ch_str, MAX_STR_LEN, "%d", cfg->gfx_y/FONT_H);
    }

    g_snprintf(gfx_x_px_str, MAX_STR_LEN, "%d", cfg->gfx_x);
    g_snprintf(gfx_y_px_str, MAX_STR_LEN, "%d", cfg->gfx_y);


    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_MISCOPTS);
    d->fn = misc_opts_fn;
    d->refresh = (void (*)(void *))refresh_misc_opts;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = loglines_str;
    d->items[i].maxl = 3;
    
    d->items[i=1].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = skedshift_str;
    d->items[i].maxl = 3;
    
    d->items[i=2].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = startbandchar_str;
    d->items[i].maxl = 3;
    
    d->items[i=3].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_x_ch_str;
    d->items[i].maxl = 5;
    
    d->items[i=4].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_y_ch_str;
    d->items[i].maxl = 5;
    
    d->items[i=5].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_x_px_str;
    d->items[i].maxl = 5;
    
    d->items[i=6].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_y_px_str;
    d->items[i].maxl = 5;
    
    d->items[++i].type = D_BUTTON;   /* 7 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}

