/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef HAVE_SDL

#define INFO_W (20*sdl->font_w)


static int olddragx, olddragy;

/* only EV_KBD */
int sw_map_kbd_func(struct subwin *sw, struct event *ev, int fw){
    int lmx,lmy,step;
    double stepd;

    if (!sdl) return 0;
    step = (SDL_GetModState() & KMOD_SHIFT)!=0 ? 1 : 10;
    /*dbg("\nsw_map_kbd_func [%d,%d,%d,%d]\n",ev->ev,ev->x,ev->y,ev->b);*/
    switch(kbd_action(KM_MAIN,ev)){
        case ACT_ESC:
            return 0;
            break;
        case ACT_LEFT:
            sw->ox+=10;
            move_map(sw, +step, 0);
            return 1;
        case ACT_RIGHT:
            sw->ox-=10;
            move_map(sw, -step, 0);
            return 1;
        case ACT_UP:
            sw->oy+=10;
            move_map(sw, 0, +step);
            return 1;
        case ACT_DOWN:
            sw->oy-=10;
            move_map(sw, 0, -step);
            return 1;

    }
   /* dbg("sw_map_kbd_func: %c %d\n", ev->x, ev->y);*/

    stepd = (SDL_GetModState() & KMOD_SHIFT)!=0 ? 1.05 : 1.3;
    switch(ev->x){
        case '+':
        case '=':
            lmx = sw->x * FONT_W + sw->screen->w/2;
            lmy = sw->y * FONT_H + sw->screen->h/2;
            zoom(sw, stepd, lmx, lmy);   
            break;
        case '-':
            lmx = sw->x * FONT_W + sw->screen->w/2;
            lmy = sw->y * FONT_H + sw->screen->h/2;
            zoom(sw, 1/stepd, lmx, lmy);
            break;
/*        case '1':
            sw->ox+=20;
            sw->oy+=20;
            move_map(sw, +20, +20);
            break;*/
        case 'r':
            sw->gdirty=1;
            qrv_recalc_wkd(qrvdb);
            qrv_recalc_qrbqtf(qrvdb);
            qrv_recalc_gst(qrvdb);
            map_recalc_gst(sw);
            sw_map_redraw(sw, 0);
            break;
        case 'p':
            map_for_photo(sw);
            break;
        case 'c':
            sw->ox=sw->map.w/2; 
            sw->oy=sw->map.h/2; 
            sw->gdirty=1;
            redraw_later();

            break;
        
        
    }
    return 0;
}

void zoom(struct subwin *sw, double factor, int centerx, int centery){
    int oldzoom;    
    int kx, ky;
    
    px2km(sw, centerx, centery, &kx, &ky);
    
    oldzoom=sw->zoom;
    sw->zoom =(int)(sw->zoom * factor);
    if (sw->zoom>20000-2) sw->zoom=20000;
    if (sw->zoom<80) sw->zoom=80;
    if (sw->zoom==oldzoom) return;

    pxkm2o(sw, centerx, centery, kx, ky, &sw->ox, &sw->oy);
	sw->gdirty=1;
    redraw_later();
    dbg("zoom=%d\n", sw->zoom);
}

int sw_map_mouse_func(struct subwin *sw, struct event *ev, int fw){
    int dx,dy, lmx, lmy;
    double stepd;
    
    if (!sdl) return 0;
    /*dbg("sw_qsos_mouse_func\n");*/
  /*  if ((ev->b & BM_ACT)!=B_DOWN) return 0; */
    {
        int kx, ky, x, y;
        lmx = ev->mx - sw->x * FONT_W;
        lmy = ev->my - sw->y * FONT_H;
        px2km(sw, lmx, lmy, &kx, &ky);
        x = lmx - sw->ox;
        y = lmy - sw->oy;
//        dbg("mouse:  lx=%d ly=%d  +ox=%d %d  kx=%d ky=%d\n", lmx, lmy, x, y, kx, ky);
    }
    if (ev->b & B_MOVE){
        plot_nearest_qso(sw);
        plot_nearest_qrv(sw);
        plot_qrb_qth(sw, sw->screen, sdl->mouse_x, sdl->mouse_y);
        return 1;
    }
    if (ev->b & B_DRAG){
        switch (ev->b & BM_EBUTT){
            case B_LEFT:
         /*   dbg("drag %d %d\n", ev->mx, ev->my);*/
            dx=ev->mx - olddragx;
            dy=ev->my - olddragy;
            if (dx==0 && dy==0) break;
            olddragx=ev->mx;
            olddragy=ev->my;
            sw->ox+=dx;
            sw->oy+=dy;
            /*redraw_later(); */
            move_map(sw, dx, dy);
            return 1;
        }
        return 1;
    }
    
    stepd = (SDL_GetModState() & KMOD_SHIFT)!=0 ? 1.05 : 1.3;
    switch (ev->b & BM_EBUTT){
        case B_LEFT:
    /*        dbg("left %d %d\n", ev->mx, ev->my);*/
            olddragx=ev->mx;
            olddragy=ev->my;
            return 1;
        case B_MIDDLE:
        /*    dbg("middle\n");*/
            break;
        case B_RIGHT:
            /*dbg("right\n");*/
            break;
        case B_WHUP:
            /*dbg("wheel up\n");*/
            lmx = ev->mx - sw->x * FONT_W;
            lmy = ev->my - sw->y * FONT_H;
            zoom(sw, stepd, lmx, lmy);
            return 1;
        case B_WHDOWN:
            /*dbg("wheel down\n");*/
            lmx = ev->mx - sw->x * FONT_W;
            lmy = ev->my - sw->y * FONT_H;
            zoom(sw, 1/stepd, lmx, lmy);
            return 1;
    }
    return 0;
}

void move_map(struct subwin *sw, int dx, int dy){
    SDL_Rect dst, r;
    
//    dbg("\nmove_map(%d, %d)\n", dx, dy);
    dst.x=dx;
    dst.y=dy;
    dst.w=sw->map.w;
    dst.h=sw->map.h;
    
    //SDL_SetAlpha(sw->l2rot, SDL_SRCALPHA, SDL_ALPHA_OPAQUE);
    
    SDL_SetClipRect(sw->l1map, &sw->map);
    memcpy(&r, &dst, sizeof(r));
    SDL_BlitSurface(sw->l1map, &sw->map, sw->l1map, &r); 
    
/*    SDL_SetClipRect(sw->l2rot, &sw->map);
    memcpy(&r, &dst, sizeof(r));
    SDL_BlitSurface(sw->l2rot, &sw->map, sw->l2rot, &r); 
*/    
    SDL_SetClipRect(sw->screen, &sw->map);
    memcpy(&r, &dst, sizeof(r));
    SDL_BlitSurface(sw->screen, &sw->map, sw->screen, &r); 

    if (dx>0){
        dst.x=0;
        dst.w=dx;
        dst.y=0;
        dst.h=sw->map.h;
        sw_map_redraw_rect(sw, &dst, 0);
    }
    if (dx<0){
        dst.x=sw->map.w+dx;
        dst.w=-dx;
        dst.y=0;
        dst.h=sw->map.h;
        sw_map_redraw_rect(sw, &dst, 0);
    }
    if (dy>0){
        dst.x=0;
        dst.w=sw->map.w;
        dst.y=0;
        dst.h=dy;
        sw_map_redraw_rect(sw, &dst, 0);
    }
    if (dy<0){
        dst.x=0;
        dst.w=sw->map.w;
        dst.y=sw->map.h+dy;
        dst.h=-dy;
        sw_map_redraw_rect(sw, &dst, 0);
    }

    plot_nearest_qso(sw); 
    plot_nearest_qrv(sw); 
//    dbg("move_map ox=%d oy=%d\n", sw->ox, sw->oy);
}


void sw_map_redraw_rect(struct subwin *sw, SDL_Rect *area, int flags){
    int fp = flags & HTML_FOR_PHOTO;

//    dbg("sw_map_redraw_rect: %dx%d%+d%+d\n", area->x, area->y, area->w, area->h);
    SDL_SetClipRect(sw->l1map, area);
    SDL_FillRect(sw->l1map, area, makecol(0, 35, 35));
   /* col%=16; */
   /* rect(sw->screen, area->x, area->y, area->x+area->w-1, area->y+area->h-1, 0x4000); */
    /*SDL_FillRect(sw->screen, &sw->map, sdl->termcol[1]);
    SDL_FillRect(sw->screen, &sw->info, sdl->termcol[2]);*/
    
    plot_cor(sw, sw->l1map, area);
//        dumpbitmap(sw->l1map);
    if (ctest && qrvdb && !fp) {
        plot_qrvs(sw, sw->l1map, area);
        plot_gst(sw, sw->l1map, area, qrvdb->gst, makecol(13, 121, 66));
    }
    if (ctest && ctest->wwlused) {
        plot_qsos(sw, sw->l1map, area);
        if (!fp) plot_gst(sw, sw->l1map, area, sw->gst, makecol(209, 205, 52));
    }
    
//    sw_map_update_rotar(sw, area);
//  dbg("                    %dx%d%+d%+d\n", area->x, area->y, area->w, area->h);
    
    sw_map_redraw_rotar(sw, area, flags);
}


void sw_map_redraw_rotar(struct subwin *sw, SDL_Rect *area, int flags){
    SDL_Rect rotarea;
    SDL_Rect r;
    
//    SDL_FillRect(sw->l2rot, area, makecol(0, 0, 0));
//    dbg("rotarea= %dx%d%+d%+d\n", rotarea.x, rotarea.y, rotarea.w, rotarea.h);
    
    //rect2(sw->l2rot, &rotarea, makecol(250, 0, 0));
    
    SDL_SetClipRect(sw->screen, area);
    memcpy(&r, area, sizeof(r));
    SDL_BlitSurface(sw->l1map, &r, sw->screen, &r);
    if ((flags & HTML_FOR_PHOTO) == 0) plot_rotars(sw, sw->screen, area, &rotarea);
    
   // SDL_SetAlpha(sw->l2rot, SDL_SRCALPHA|SDL_RLEACCEL, 128);
//    memcpy(&r, rotarea, sizeof(r));
    //dbg("r= %dx%d%+d%+d\n", r.x, r.y, r.w, r.h);
  //  SDL_BlitSurface(sw->l2rot, &r, sw->screen, &r);
   // dbg("r= %dx%d%+d%+d\n", r.x, r.y, r.w, r.h);
    //dbg("                    %dx%d%+d%+d\n", area->x, area->y, area->w, area->h);
}

void sw_map_update_rotar(struct subwin *sw){
    SDL_Rect r;

//    dbg("\nsw_map_update_rotar)\n");
    r.x = 0;
    r.y = 0;
    r.w = sw->screen->w;
    r.h = sw->screen->h;

    sw->gdirty=1;
    sw_map_redraw_rotar(sw, &r, 0);
} 

void sw_map_redraw(struct subwin *sw, int flags){
    struct qso *odx;
    if (!sdl) return;
	//dbg("sw_map_redraw(gdirty=%d)\n", sw->gdirty);

    fill_area(sw->x, sw->y, sw->w, sw->h, 0);
	if (!sw->gdirty) return;
	sw->gdirty=0;

    //ST_START; 

    sw_map_redraw_rect(sw, &sw->map, flags);

    if ((flags & HTML_FOR_PHOTO) && (odx = aband->stats->odx) != NULL){
        struct qso *oldminqso = sw->minqso;
        sw->minqso = odx;
        plot_qso(sw, sw->screen, odx);
        plot_info_qso(sw, sw->screen, odx);
        plot_info_qrv(sw, sw->screen, NULL);
        plot_qrb_qth(sw, sw->screen, -1, -1);
        sw->minqso = oldminqso;
        return;
    }
    plot_info_qso(sw, sw->screen, sw->minqso);
    plot_info_qrv(sw, sw->screen, qrv_get(qrvdb, sw->minqrvcall));
    plot_qrb_qth(sw, sw->screen, sdl->mouse_x, sdl->mouse_y);
//	ST_STOP; 
    
}

void sw_map_check_bounds(struct subwin *sw){

    if (!sdl) return;
    if (!aband) return;
}

void sw_map_raise(struct subwin *sw){
    sw->gdirty=1;      
}

/* km -> pixels */
void km2px(struct subwin *sw, int kx, int ky, int *px, int *py){
    *px = sw->ox + (kx * sw->zoom)/10000;    
    *py = sw->oy + (ky * sw->zoom)/10000;    
}

/* pixels -> km */
void px2km(struct subwin *sw, int px, int py, int *kx, int *ky){
    *kx = ((px - sw->ox) * 10000)/sw->zoom;
    *ky = ((py - sw->oy) * 10000)/sw->zoom;
}

void pxkm2o(struct subwin *sw, int px, int py, int kx, int ky, int *ox, int *oy){
    *ox = px - (kx * sw->zoom)/10000;    
    *oy = py - (ky * sw->zoom)/10000;    
}


void hw2km(double h1, double w1, double h2, double w2, int *kx, int *ky){
	double qrb, qtf;
    
	hw2qrbqtf(h1, w1, h2, w2, &qrb, &qtf);
/*    dbg("qrb=%f qtf=%f\n", qrb, qtf);*/
    *kx = (int)(  qrb*sin(qtf));
    *ky = (int)(- qrb*cos(qtf));
}

void km2qrbqtf(int kx, int ky, double *qrb, double *qtf){
    int dx, dy;
    
    dx=kx;
    dy=ky;
    
    *qrb=sqrt(sqr(dx)+sqr(dy));
    *qtf=atan2(dx,-dy);   
    if (*qtf<0) *qtf+=2*MY_PI;
/*    dbg("km2qrbqtf(%d, %d)=%d, %d\n",kx, ky, (int)*qrb, (int)(*qtf*180.0/MY_PI));*/
}

static int dashcnt;
static void dashfce(SDL_Surface *surface, int x, int y, int d) {
    if (dashcnt++%6<3) return;
    fast_putpixel(surface, x, y, d);
}


void plot_cor(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area){
    gpointer key;
    int ikx, iky, px, py, kx, ky, oldpx=0, oldpy=0, c, color=0, i;
    struct kmarray *kma;
    struct kmpoint *kmp;
    int minkx, minky, maxkx, maxky;
    
   /* ST_START; */
	//	rect2(surface,area, 0x000080);
    px2km(sw, area->x, area->y, &minkx, &minky);
    px2km(sw, area->x+area->w-1, area->y+area->h-1, &maxkx, &maxky);
    /*px2km(sw, 0, 0, &minkx, &minky);
    px2km(sw, sw->screen->w, sw->screen->h, &maxkx, &maxky);*/
    //   dbg("\nplot_cor: area=%dx%x+%d+%d kx=%d..%d ky=%d..%d  \n", area->x, area->y, area->w, area->h, minkx, maxkx, minky, maxky);
    minkx &= COR_KM_MASK;
    minky &= COR_KM_MASK;
    maxkx &= COR_KM_MASK;
    maxky &= COR_KM_MASK;
    if (minkx<COR_KM_MIN) minkx=COR_KM_MIN;
    if (maxkx>COR_KM_MAX) maxkx=COR_KM_MAX;
    if (minky<COR_KM_MIN) minky=COR_KM_MIN;
    if (maxky>COR_KM_MAX) maxky=COR_KM_MAX;
 /*   dbg("kx=%d-%d ky=%d-%d\n", minkx, maxkx, minky, maxky);*/
    
    
    /* big wwls (JN69) */
    for (iky=minky; iky<=maxky; iky+=COR_KM_STEP)
        for (ikx=minkx; ikx<=maxkx; ikx+=COR_KM_STEP){
            km2px(sw, ikx, iky, &px, &py);
            //dbg("ikx=%d iky=%d px=%d py=%d\n", ikx, iky, px, py);
#if 0        
            int px2, py2;
            km2px(sw,ikx+COR_KM_STEP, iky+COR_KM_STEP, &px2, &py2);
            rect(surface, px, py, px2-2,py2-2 , makecol(0, 128, 0));
#endif                
            key=k2key(ikx, iky);
            if (sw->zoom<1000){ 
                kma=g_hash_table_lookup(cor->wwl2, key);
            }else{
                kma=g_hash_table_lookup(cor->wwl4, key);
            }
            if (!kma) continue;
            for (i=0,kmp=kma->data;i<kma->len;i++,kmp++){
                kx=kmp->kx;
                ky=kmp->ky;
                km2px(sw, kx, ky, &px, &py);
                
                if (kmp->c<0) {
                    oldpx = px;
                    oldpy = py;
                    switch((int)kmp->c){
                        case -128: 
                            color=makecol(184, 159, 255);
                            break;
                        case -127: 
                            color=makecol(145, 125, 122);
                            break;
                        default:
                            color=makecol(255, 159, 255);
                        /*    dbg("unknown char %d\n", (int)kmp->c);    
                            return;  */
                            break;
                            
                    }
                    continue;
                }

                c = color;
                if (overlapped_line(area, oldpx, oldpy, px, py))
                    line(surface, oldpx, oldpy, px, py, c);
                        
                /*fast_putpixel(surface, oldpx, oldpy, makecol(255,0,0));
                fast_putpixel(surface, px, py, makecol(255,0,0));*/
                oldpx = px;
                oldpy = py;
            }
        }
    /*ST_STOP; */
    /*ST_START; */

    /* cor */
    for (iky=minky; iky<=maxky; iky+=COR_KM_STEP)
        for (ikx=minkx; ikx<=maxkx; ikx+=COR_KM_STEP){
            km2px(sw, ikx, iky, &px, &py);
                
            key=k2key(ikx, iky);
            kma=g_hash_table_lookup(cor->km, key);
            if (!kma) continue;
            for (i=0,kmp=kma->data;i<kma->len;i++,kmp++){
                kx=kmp->kx;
                ky=kmp->ky;
                km2px(sw, kx, ky, &px, &py);
                
                if (kmp->c<0) {
                    oldpx = px;
                    oldpy = py;
                    switch((int)kmp->c){
                        case -128: /* coast */
                            color=makecol(0, 255, 255);
                            break;
                        case -127: /* isle */
                            color=makecol(0, 255, 255);
                            break;
                        case -126: /* lake */
                            color=makecol(0, 95, 195);
                            break;
                        case -125: /* border */
                            color=makecol(0, 255, 255);
                            break;
                        case -100: 
                            color=makecol(255,0,0);
                            break;
                        case -101: 
                            color=makecol(0,255,0);
                            break;
                        default:
                            dbg("unknown char %d\n", (int)kmp->c);    
                            return;
                            break;
                            
                    }
                    continue;
                }

                c = color;
/*                if (abs(oldpx-px) + abs(oldpy-py) < 100)  */
                if (oldpx!=px || oldpy!=py)               
                    line(surface, oldpx, oldpy, px, py, c);
               /* if (oldpx==px && oldpy==py) stejne++;
                else ruzne++;*/

                oldpx = px;
                oldpy = py;
            }
        }

  /*  dbg("stejne=%d ruzne=%d\n", stejne, ruzne);*/
    /*ST_STOP; */
}

void plot_qrv(struct subwin *sw, SDL_Surface *surface, struct qrv_item *qi){
    int kx, ky, px, py, color1, color2;
    SDL_Rect outline;

    outline.w=3;
    outline.h=3;
    kx =   qi->kx;
    ky =   qi->ky;
    km2px(sw, kx, ky, &px, &py);
    outline.x = px - 1; 
    outline.y = py - 1; 
    if (!overlapped_rect(&surface->clip_rect, &outline)) {
           // dbg("clipped qi\n"); 
        return;
    }
    //dbg("kreslim qi %s [%d,%d]\n", qi->call, qi->kx, qi->ky); 
    //dbg("q->call=%s sw->minqrvcall=%s\n", qi->call, sw->minqrvcall);
    if (sw->minqrvcall && strcmp(qi->call, sw->minqrvcall) == 0){
        color1=makecol(193, 21, 107);
        color2=makecol(121, 13, 67);
    }else{
        int bi = toupper(aband->bandchar) - 'A';
        if (qi->wkd[bi] > 0){
            color1=makecol(21, 193, 106);
            color2=makecol(13, 121, 66);
        }else{
            color1=makecol(107, 107, 107);
            color2=makecol(67, 67, 67);
        }
    }

    pip(surface, px, py, color1, color2, sw->zoom);
}

void plot_qrvs(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area){
    int skip;
    int i, bi;

    if (!qrvdb) return;
    if (!aband) return;
    bi = toupper(aband->bandchar) - 'A';

    for (i = 0; i < qrvdb->qrvs->len; i++){
        struct qrv_item *qi = (struct qrv_item*)g_ptr_array_index(qrvdb->qrvs, i);
        
        skip = qrv_skip(qi, bi);
//        dbg("plot_qrvs('%s') skip=%d, bands=%d, wkd=%d\n", q->call, skip, q->bands, q->bands_wkd);
        if (skip) continue;
        plot_qrv(sw, surface, qi);
    }
}

void plot_gst(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area, double gst[360], int c){
    int i,ii, x, y, oldx=0,oldy=0;
    double rad, r;
    

    if (sw->map.w > sw->map.h)
        r = sw->map.h / 2.3;
    else
        r = sw->map.w / 2.3;


    for (i=-1; i<360;i++) {
        ii = i>=0 ? i : 359;
        rad = MY_PI * (double)(i - 90) / 180.0;
        x = (int)(sw->ox + r * gst[ii] * cos(rad));
        y = (int)(sw->oy + r * gst[ii] * sin(rad));
        if (i >= 0){
            //if (overlapped_line(area, oldx, oldy, x, y))
                line(surface, oldx, oldy, x, y, c);
        }
        oldx=x;
        oldy=y;
    }
}


void plot_qso(struct subwin *sw, SDL_Surface *surface, struct qso *qso){
    int kx, ky, px, py, color;
    SDL_Rect outline;

    outline.w=9;
    outline.h=9;
    kx =   qso->kx;
    ky =   qso->ky;
    km2px(sw, kx, ky, &px, &py);
    outline.x = px - 4; 
    outline.y = py - 4; 
    if (!overlapped_rect(&surface->clip_rect, &outline)) {
/*            dbg("clipped qso\n"); */
        return;
    }
/*       dbg("kreslim qso\n"); */
    color=qso==sw->minqso?sdl->red:sdl->yellow;
    if (qso==&aband->tmplocqso) color=sdl->green;
    cross(surface, px, py, color, sw->zoom);
}

void map_add_qso(struct qso *qso){
    if (ctest && !ctest->wwlused) return;
    if (gses->ontop->type!=SWT_MAP) return;
    SDL_SetClipRect(gses->ontop->screen, &gses->ontop->map);
    plot_qso(gses->ontop, gses->ontop->screen, qso);
}

void plot_qsos(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area){
    int i;
    struct qso *qso;
    
    if (!aband) return;
    
    for (i=0;i<aband->qsos->len;i++){
        qso=(struct qso*)g_ptr_array_index(aband->qsos, i);
        if (qso->error) continue;
        plot_qso(sw, surface, qso);
    }
    if (aband->tmplocqso.locator && *aband->tmplocqso.locator)
        plot_qso(sw, surface, &aband->tmplocqso);
}

void plot_rotars(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area, SDL_Rect *outarea){
    struct rotar *rot;
    int i;
    double rad,r;
    int vx,vy,vx1,vy1,vx2,vy2;
    
    
    if (sw->map.w > sw->map.h)
        r = sw->map.h / 2.3;
    else
        r = sw->map.w / 2.3;

    outarea->x = (int)(sw->ox - r);
    outarea->y = (int)(sw->oy - r);
    outarea->w = (int)(2 * r + 1);
    outarea->h = (int)(2 * r + 1);

 /*   for (i=0; i<16; i++){
        SDL_Rect q;
        q.x = sw->ox-20;
        q.y = sw->oy-r+i*10;
        q.w = 20;
        q.h = 10;
        SDL_FillRect(surface, &q, sdl->termcol[i]);
    }*/

    MUTEX_LOCK(rotars2);
    for (i=0; i<rotars2->len; i++){
        rot = (struct rotar *)g_ptr_array_index(rotars2, i);
        
        rad = MY_PI * (double)(rot->qtf - 90) / 180.0;
        vx  = (int)(sw->ox + r * cos(rad)); 
        vy  = (int)(sw->oy + r * sin(rad));
        vx1 = (int)(sw->ox + 0.95 * r * cos(rad + 0.02));
        vy1 = (int)(sw->oy + 0.95 * r * sin(rad + 0.02));
        vx2 = (int)(sw->ox + 0.95 * r * cos(rad - 0.02));
        vy2 = (int)(sw->oy + 0.95 * r * sin(rad - 0.02));
    
        line(surface, sw->ox, sw->oy, vx, vy, rot->color);
        triangle(surface, vx, vy, vx1, vy1, vx2, vy2, rot->color);

        if (rot->beamwidth<=0) continue;
        
        rad = MY_PI * (double)(rot->qtf - 90 + rot->beamwidth / 2) / 180.0;
        vx1 = (int)(sw->ox + 0.9 * r * cos(rad)); 
        vy1 = (int)(sw->oy + 0.9 * r * sin(rad));
        dashcnt=0;
        do_line(surface, sw->ox, sw->oy,  
                vx1, vy1, rot->color, dashfce);

        rad = MY_PI * (double)(rot->qtf - 90 - rot->beamwidth / 2) / 180.0;
        vx2 = (int)(sw->ox + 0.9 * r * cos(rad)); 
        vy2 = (int)(sw->oy + 0.9 * r * sin(rad));
        dashcnt=0;
        do_line(surface, sw->ox, sw->oy,  
                vx2, vy2, rot->color, dashfce);
        
        do_line(surface, vx1, vy1, vx2, vy2, rot->color, dashfce);
    }
    MUTEX_UNLOCK(rotars2);
}

void map_update_layout(struct subwin *sw){
/*    dbg("map_update_layout\n");*/

    sw->map.x = 0;
    sw->map.y = 0;
    sw->map.w = sw->w * FONT_W - INFO_W;
    sw->map.h = sw->h * FONT_H;

    sw->info.x = sw->w * FONT_W - INFO_W;
    sw->info.y = 0;
    sw->info.w = INFO_W;
    sw->info.h = sw->h * FONT_H;

}

int map_update_qth(struct subwin *sw){
    gchar *pwwlo;

//    dbg("map_update_qth\n");
    if (!sdl) return 0;

    
    if (ctest && ctest->pwwlo) {
        pwwlo=ctest->pwwlo;
    }else{
        pwwlo = cfg->pwwlo;
    }
    if (!pwwlo) internal_("Undefined locator");
    
    if (sw->pwwlo && strcmp(sw->pwwlo, pwwlo)==0) {
        /*dbg("map_update_qth(%s (same) )\n", sw->pwwlo);*/
        return 0;
    }
    
    CONDGFREE(sw->pwwlo);
    sw->pwwlo = g_strdup(pwwlo);
    /*dbg("map_update_qth(%s)\n", sw->pwwlo);*/

    sw->ox=sw->map.w/2; 
    sw->oy=sw->map.h/2; 
	
    sw->myh = qth(sw->pwwlo, 0);
	sw->myw = qth(sw->pwwlo, 1);
 //   dbg("   %s=%d %d\n", sw->pwwlo, sw->myh, sw->myw);
    
    cor_recalc(sw, sw->pwwlo);

    return 1;
}


int maps_reload(){
    int i;
    struct subwin *sw=NULL;
    
    if (!sdl) return 0;
    /*dbg("maps_reload\n");*/
    
    for (i=0;i<gses->subwins->len;i++){
        sw=(struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type!=SWT_MAP) continue;
        sw->gdirty=1;
        sw->minqso=NULL;
        CONDGFREE(sw->minqrvcall);
        map_update_qth(sw);
    }
    
/*    invalidate_bkg(NULL);   in map_update_qth
    invalidate_cache(aband);
    clear_gfxstats();
    gfx->dirty=1;
    gfx->draw=1;*/
    if (gses && gses->ontop && gses->ontop->type==SWT_MAP) sw_map_redraw(gses->ontop, 0);
    return 0;
}

void map_clear_qso(struct qso *qso){
    int kx, ky, px, py;
    SDL_Rect outline;
    struct subwin *sw;
    
    if (!sdl) return;
    if (ctest && !ctest->wwlused) return;
    
    if (gses->ontop->type!=SWT_MAP) goto x;
    
    if (!qso->locator || !*qso->locator) goto x;
    sw = gses->ontop;
    kx =   qso->kx;
    ky =   qso->ky;
    km2px(sw, kx, ky, &px, &py);
    outline.x = px - 4; 
    outline.y = py - 4; 
    outline.w = 9;
    outline.h = 9;
    if (!overlapped_rect(&sw->map, &outline)) goto x;
    
    sw_map_redraw_rect(sw, &outline, 0);
x:;    
    if (qso==&aband->tmplocqso) CONDGFREE(qso->locator);

}

void map_recalc_cors(){
    int i;
    struct subwin *sw;
    
    for (i=0;i<gses->subwins->len;i++){
        sw=(struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type!=SWT_MAP) continue;
        cor_recalc(sw, ctest->pwwlo);
        break; /* fixme more maps with different pwwlo. but why? */
    }
} 


struct qso *find_nearest_qso(struct band *b, int mouse_x, int mouse_y){
    int i;
    struct qso *minq, *q;
    gdouble d, min;
    int px, py, kx, ky;
    struct subwin *sw;

    if (!b) return NULL;
    sw=gses->ontop;
    if (sw->type!=SWT_MAP) return NULL;
    
    px=mouse_x-sw->x*FONT_W;
    py=mouse_y-sw->y*FONT_H;
    px2km(sw, px, py, &kx, &ky);
    

    min=G_MAXDOUBLE;
    minq=NULL;
    for (i=0; i<b->qsos->len; i++){
        q = (struct qso *)g_ptr_array_index(b->qsos, i);
        if (q->error) continue;
        
        /*compute_cache(q); */
        d = sqrt((double)(sqr(q->kx-kx)+sqr(q->ky-ky)));
/*        dbg("  %s %d %d %6.3f\n", q->callsign, q->gfx_x-mouse_x,  q->gfx_y-mouse_y, d);*/
        if (d<min){
            min=d;
            minq=q;
        }
    }
    /*if (minq) dbg("nearest: %s %s\n", minq->callsign, minq->locator);
    else dbg("nearest: NULL\n"); */
    return minq;
}

gchar *find_nearest_qrv(struct qrvdb *qrvdb, int mouse_x, int mouse_y){
    struct qrv_item *minqrv;
    gdouble d, min;
    int px, py, kx, ky;
    struct subwin *sw;
    int i, bi;

    if (!qrvdb) return NULL;
    if (!aband) return NULL;

    sw=gses->ontop;
    if (sw->type!=SWT_MAP) return NULL;
    
    px=mouse_x-sw->x*FONT_W;
    py=mouse_y-sw->y*FONT_H;
    px2km(sw, px, py, &kx, &ky);
    

    min=G_MAXDOUBLE;
    minqrv=NULL;
    bi = toupper(aband->bandchar) - 'A';

    for (i = 0; i < qrvdb->qrvs->len; i++){
        struct qrv_item *qi = (struct qrv_item*)g_ptr_array_index(qrvdb->qrvs, i);

        if (qrv_skip(qi, bi)) continue;
        
        /*compute_cache(q); */
        d = sqrt((double)(sqr(qi->kx-kx)+sqr(qi->ky-ky)));
        //dbg("  %s %d %d %6.3f\n", q->call, q->kx-kx,  q->ky-ky, d);
        if (d<min){
            min=d;
            minqrv=qi;
        }
    }
   // if (minqrv) dbg("nearest_qrv: %s %s\n", minqrv->call, minqrv->wwl);
   // else dbg("nearest_qrv: NULL\n"); 
	if (!minqrv) return NULL;
    return minqrv->call;
}

void plot_nearest_qso(struct subwin *sw){
    struct qso *oldminqso;

    if (!sdl) return;
    oldminqso=sw->minqso;          
    sw->minqso=find_nearest_qso(aband, sdl->mouse_x, sdl->mouse_y);
    /*dbg("sw->minq=%s  oldminq=%s\n", sw->minq->callsign, oldminq->callsign); */
    if (sw->minqso==oldminqso) return;
/*        dbg("minq changed %s->%s\n", oldminq->locator, sw->minq->locator); */
    SDL_SetClipRect(sw->screen, &sw->map);
/*       dbg("clip_rect %dx%d%+d%+d\n", surface->clip_rect.x, surface->clip_rect.y, surface->clip_rect.w, surface->clip_rect.h); */
    if (oldminqso) plot_qso(sw, sw->screen, oldminqso);
    if (sw->minqso) {
        plot_qso(sw, sw->screen, sw->minqso);
        plot_info_qso(sw, sw->screen, sw->minqso);
    }else{
        plot_info_qso(sw, sw->screen, NULL);
    }
}
    
void plot_nearest_qrv(struct subwin *sw){
    gchar *minqrvcall, *oldminqrvcall;

    if (!sdl) return;
    minqrvcall=find_nearest_qrv(qrvdb, sdl->mouse_x, sdl->mouse_y);
    //dbg("sw->minqrv=%s  oldminqrv=%s\n", sw->minqrv->call, oldminqrv->call); 
    if (sw->minqrvcall && strcmp(minqrvcall, sw->minqrvcall)==0) return;

    SDL_SetClipRect(sw->screen, &sw->map);

    oldminqrvcall = sw->minqrvcall;
    sw->minqrvcall = g_strdup(minqrvcall);
    if (oldminqrvcall) plot_qrv(sw, sw->screen, qrv_get(qrvdb, oldminqrvcall));
    CONDGFREE(oldminqrvcall);

    if (minqrvcall) {
        struct qrv_item *qi = qrv_get(qrvdb, minqrvcall);
        plot_qrv(sw, sw->screen, qi);
        plot_info_qrv(sw, sw->screen, qi);
    }else{
        plot_info_qrv(sw, sw->screen, NULL);
    }
}

void plot_info_qso(struct subwin *sw, SDL_Surface *surface, struct qso *qso){
    char s[10];
    int x,y;
    SDL_Rect rect;
 
//    dbg("plot_info_qso('%s')\n", qso ? qso->callsign : "");
    rect.x=sw->info.x;
    rect.y=sw->info.y;
    rect.w=sw->info.w;
    rect.h=sw->info.y+(11*FONT_H)+12;
    
    SDL_SetClipRect(surface, &rect);
    SDL_FillRect(surface, &rect, makecol(0,0,35)) ;
    if (!qso) return;

    x=sw->info.x+4;
    y=sw->info.y+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GCALL), q0(qso->callsign)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GWWL),  q0(qso->locator)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQRB),  (int)qso->qrb); y+=FONT_H+4;   
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQTF),  qso->qtf); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GSEN),  q0(qso->rsts), q0(qso->qsonrs)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GRCV),  q0(qso->rstr), q0(qso->qsonrr)); y+=FONT_H+4;
    strcpy(s,qso->time_str);
    s[5]=s[4];
    s[4]=s[3];
    s[3]=s[2];
    s[2]='.';
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GTIM),  s); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GOPE),  q0(qso->operator_)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GREM),  q0(qso->remark)); y+=FONT_H+4;
    return;                      
}

void plot_info_qrv(struct subwin *sw, SDL_Surface *surface, struct qrv_item *qi){
    int x,y, bi;
    SDL_Rect rect;
    int color;
    //char s[256];
 
   // dbg("plot_info_qrv(%s)\n", qrv?qrv->call:"-");

    x=sw->info.x+4;
    y=sw->info.y+4+18*FONT_H;

    rect.x=sw->info.x;
    rect.y=y;
    rect.w=sw->info.w;
    rect.h=sw->y - y;
    
    
    SDL_SetClipRect(surface, &rect);
    SDL_FillRect(surface, &rect, makecol(0,0,35)) ;
    if (!qi) return;

    color=makecol(21, 193, 106);

	fontoutf(surface, x, y, color, FONT_TRANSP, VTEXT(T_GCALL), q0(qi->call)); y+=FONT_H+4;
    fontoutf(surface, x, y, color, FONT_TRANSP, VTEXT(T_GWWL),  q0(qi->wwl)); y+=FONT_H+4;
    fontoutf(surface, x, y, color, FONT_TRANSP, VTEXT(T_GREM),  q0(qi->text)); y+=FONT_H+4;
    if (!aband) return;
    bi = toupper(aband->bandchar) - 'A'; 
    fontoutf(surface, x, y, color, FONT_TRANSP, VTEXT(T_GWKD),  qi->wkd[bi]); y+=FONT_H+4;
    return;                      
}

int plot_qrb_qth(struct subwin *sw, SDL_Surface *surface, int mouse_x, int mouse_y){
    double qrb,qtf, h2, w2; 
    SDL_Rect rect;
    char buf[100];
    int x, y, kx, ky;
 
    x=sw->info.x+4;
    y=sw->info.y+(11*FONT_H)+12;
    
/*    dbg("plot_qtb_qtf\n");*/
    rect.x=sw->info.x;
    rect.y=y;
    rect.w=sw->info.w;
    rect.h=6 * FONT_H + 8 ;
    
    px2km(sw, mouse_x - sw->x*FONT_W, mouse_y - sw->y*FONT_H, &kx, &ky);
    km2qrbqtf(kx, ky, &qrb, &qtf);
    
    SDL_SetClipRect(surface, &rect);
/*    SDL_FillRect(surface, &sw->info, makecol(0,0,175)) ; */
    SDL_FillRect(surface, &rect, makecol(0,0,35)) ;
    if (mouse_x < 0) return 0;


    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQRB), (int)(qrb));y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQTF), (int)(qtf*180/MY_PI)); y+=FONT_H+4;
   /* fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GINC), (int) (gst[(int)(qtf*180/MY_PI)%360]/400*100));y+=FONT_H+4; */

    if (qrbqtf2hw(sw->myh, sw->myw, qrb, qtf, &h2, &w2)==0){
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLON), h2*180.0/MY_PI, x2gramin(buf, h2*180/MY_PI, "EW")); y+=FONT_H+4;
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLAT), w2*180.0/MY_PI, x2gramin(buf, w2*180/MY_PI, "NS")); y+=FONT_H+4;
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLOC), hw2loc(buf, h2*180/MY_PI, w2*180/MY_PI)); y+=FONT_H+4;
    }
    
    return 0;
}
        

void map_for_photo(struct subwin *sw){
    struct qso *q;
    int i, minkx, minky, maxkx, maxky, px, py, lmx, lmy;
    int dx, dy;
	double z, z1, z2;
    
    if (!ctest) return;
    if (!sdl) return;

    minkx = minky = 0;
    maxkx = maxky = 0;

    for (i=0; i<aband->qsos->len; i++){
        q = (struct qso *)g_ptr_array_index(aband->qsos, i);
        if (q->error) continue;

        if (q->kx < minkx) minkx = q->kx;
        if (q->ky < minky) minky = q->ky;
        if (q->kx > maxkx) maxkx = q->kx;
        if (q->ky > maxky) maxky = q->ky;
    }

    if (minkx > maxkx) return;  // no qso
    if (minkx == 0 || minky == 0) return; // one qso 
 //   dbg("x=%d..%d y=%d..%d  prumer x=%d y=%d\n", minkx, maxkx, minky, maxky, (maxkx+minkx)/2, (maxky+minky)/2);
    km2px(sw, (maxkx+minkx)/2, (maxky+minky)/2, &px, &py);
    dx = sw->map.w/2 - px;
    dy = sw->map.h/2 - py;
 //   dbg("px=%d py=%d   map/2=%d %d   sw->ox=%d sw->oy=%d   dx=%d dy=%d\n", px, py, sw->map.w/2, sw->map.h/2, sw->ox, sw->oy, dx, dy);
    sw->ox += dx; 
    sw->oy += dy;
    move_map(sw, dx, dy);

    //px = sw->map.x + 20;
    //py = sw->map.y + 20;
//    px2km(sw, px, py, &kx, &ky);
    z1 = ((sw->map.w - 20) * 10000.0) / (maxkx - minkx); 
    z2 = ((sw->map.h - 20) * 10000.0) / (maxky - minky); 
    z = z1 < z2 ? z1 : z2;
//    dbg("kx=%d %d  px=%d %d    %d %d %d\n", kx, ky, px, py, (int)z1, (int)z2, (int)z);
    lmx = sw->map.w/2;//sw->x * FONT_W + sw->screen->w/2;
    lmy = sw->map.h/2;//sw->y * FONT_H + sw->screen->h/2;
    zoom(sw, z/sw->zoom, lmx, lmy);
}

void map_recalc_gst(struct subwin *sw){
    int i, j;
    int qtf2;
	double max;
                   
    sw->beamwidth = 10;
    for (i=0;i<=180;i++){
        sw->antchar[i]=cos(MY_PI/180.0*(double)i*120.0/sw->beamwidth);
       /* dbg("i=%3d %5.3f\n", i, antchar[i]);*/
        if (sw->antchar[i]<=0) break;
    }
    for (;i<=180;i++) sw->antchar[i]=0;
    
    for (i=0; i<360; i++) sw->gst[i]=0.0;
    
    if (!aband) return;

    for (i = 0; i < aband->qsos->len; i++){
        struct qso *q = (struct qso *)g_index_array_index(aband->qsos, i);
        if (q->qtf<=0 || q->qtf>=360) continue;
        
        for (j=0;j<=180;j++){
            qtf2 = q->qtf + j;
            if (sw->antchar[j] == 0) break;
            if (qtf2<0) qtf2 += 360;
            sw->gst[qtf2%360] += q->qrb * sw->antchar[j];
        }
        for (j=1;j<180;j++){
            qtf2 = q->qtf - j;
            if (sw->antchar[j] == 0) break;
            if (qtf2<0) qtf2 += 360;
            sw->gst[qtf2%360] += q->qrb * sw->antchar[j];
        }
    }
    max = 0;
    for (i=0; i<360; i++) if (sw->gst[i] > max) max = sw->gst[i];
    if (!max) return;
    for (i=0; i<360; i++) sw->gst[i] = sw->gst[i] / max; 
} 

#else
int sw_map_kbd_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

int sw_map_mouse_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

void sw_map_redraw(struct subwin *sw, int flags){
}

void sw_map_check_bounds(struct subwin *sw){
}

void sw_map_raise(struct subwin *sw){
}

int maps_reload(){
    return 0;
}

void map_clear_qso(struct qso *qso){
}

void map_add_qso(struct qso *qso){
}
#endif
