#include <algorithm>
#include <tulip/SuperGraph.h>
#include <tulip/LayoutProxy.h>
#include <tulip/SizesProxy.h>
#include "TreeTools.h"

//====================================================================
node searchRoot(const SuperGraph* tree) {
    node            root;
    Iterator<node>* itNode = tree->getNodes();
    while (itNode->hasNext()) {
        node currentNode = itNode->next();
        if (tree->indeg(currentNode) == 0) {
            root = currentNode;
            break;
        }
    }
    delete itNode;
    return root;
}

//====================================================================
int getTreeDepth(const SuperGraph* tree, node root) {
    int depthMax           = 0;
    Iterator<node>* itNode = tree->getOutNodes(root);
    while (itNode->hasNext())
        depthMax = std::max(getTreeDepth(tree, itNode->next()), depthMax);
	delete itNode;
    return depthMax + 1;
}

//====================================================================
bool isLeaf (const SuperGraph* tree, node n) {
    return tree->outdeg(n) == 0;
}

//====================================================================
float getNodeX(LayoutProxy* pLayout, node current) {
    return pLayout->getNodeValue(current).getX();
}

//====================================================================
float getNodeY(LayoutProxy* pLayout, node current) {
    return pLayout->getNodeValue(current).getY();
}

//====================================================================
float getNodeHeight(SizesProxy* size, node current) {
    return size->getNodeValue(current).getH();
}

//====================================================================
float getNodeWidth(SizesProxy* size, node current) {
    return size->getNodeValue(current).getW();
}
