//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef QtProgress_TULIP
#define QtProgress_TULIP
#include <string>
#include <tulip/PluginProgress.h>
#include <tulip/View.h>
#include "QtProgressData.h"


namespace tlp {

  class TLP_QT_SCOPE QtProgress : public QDialog, public Ui::QtProgressData, public tlp::PluginProgress {
    
    Q_OBJECT
      
  public:
    QtProgress(QWidget* parent, std::string text, View *view=0);
    virtual ~QtProgress();
    void progress_handler(int i,int j);
    void setComment(std::string msg);
    void showPreview(bool);
  public slots:
    void stopCompute();
    void cancelCompute();
    void changePreview(bool);

  public:
    bool firstCall;
    std::string label;
    QWidget* parent;
    View *view;
  };
}

#endif
