# Using RuleDispatch:

import datetime

import dispatch
import sqlobject
from simplejson import JSONEncoder

try:
    import decimal
except ImportError:
    # Python 2.3
    decimal = None

def jsonify(obj):
    """
    Return an object that can be serialized with JSON, i.e., it
    is made up of only lists, dictionaries (with string keys),
    and strings, ints, and floats.
    """
    raise NotImplementedError
jsonify = dispatch.generic()(jsonify)

def jsonify_datetime(obj):
	return str(obj)
jsonify_datetime = jsonify.when(
        'isinstance(obj, datetime.datetime) or '
        'isinstance(obj, datetime.date)')(jsonify_datetime)

def jsonify_sqlobject(obj):
    result = {}
    result['id'] = obj.id
    for name in obj.sqlmeta.columns.keys():
        result[name] = getattr(obj, name)
    return result
jsonify_sqlobject = jsonify.when(
        'isinstance(obj, sqlobject.SQLObject)')(jsonify_sqlobject)

def jsonify_decimal(obj): 
    return float(obj) 
if decimal is not None: 
    jsonify_decimal = jsonify.when('isinstance(obj, decimal.Decimal)')( 
        jsonify_decimal) 

def jsonify_explicit(obj):
    return obj.__json__()
jsonify_explicit = jsonify.when('hasattr(obj, "__json__")')(jsonify_explicit)

def jsonify_select_results(obj):
    return list(obj)
jsonify_select_results = jsonify.when(
        'isinstance(obj, sqlobject.SQLObject.SelectResultsClass)')(
                jsonify_select_results)

class GenericJSON(JSONEncoder):

    def default(self, obj):
        return jsonify(obj)

_instance = GenericJSON()

def encode(obj):
    return _instance.encode(obj)
