<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup bug
 * @module bug_ins
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'location.pinc';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","new");

 $gotourl = "bug_new.php";
 $msg = "";

 $b = new bug($dbconn);
 if ( isset($_POST['id']) ) {
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id']);
   $b->read($_POST['id']);
 }

 if ( empty($_POST['name']) || !isset($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugID']) ."<br>";
 } else {
   $name = StripSlashes($_POST['name']);
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($name));
 }

 if ( (empty($_POST['description']) || !isset($_POST['description']) ) && ($b->id < 0 )) {
   $msg .= sprintf($lang['Err0009'],$lang['BugAdditional']) ."<br>";
 } else {
   $description = StripSlashes($_POST['description']);
   $gotourl= addUrlParameter($gotourl,"description=". UrlEncode($description));
 }

 if ( empty($_POST['short']) || !isset($_POST['short']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugShort']) ."<br>";
 } else {
   $short = StripSlashes($_POST['short']);
   $gotourl= addUrlParameter($gotourl,"short=". UrlEncode($short));
 }

 if ( isset($_POST['pid']) ) {
   $gotourl= addUrlParameter($gotourl,"pid=". $_POST['pid']);
   $oldparent = $b->parent;
   $b->setParent(getObject($dbconn,$_POST['pid']));
 } else {
   $msg .= sprintf($lang['Err0009'],$lang['Product']) ."<br>";
 }

 if ( empty($_POST['state']) || !isset($_POST['state']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugState']) ."<br>";
 } else {
   $state = $_POST['state'];
   $gotourl= addUrlParameter($gotourl,"state=". $state);
 }
 if ( empty($_POST['class']) || !isset($_POST['class']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugClass']) ."<br>";
 } else {
   $class = $_POST['class'];
   $gotourl= addUrlParameter($gotourl,"class=". $class);
 }

 if ( isset($_POST['sfn']) ) {
   $solver = check_field($_POST['sfn'],"sfn","sl");
 } else {
   if ( isset($_POST['sid']) ) {
     $solver = getObject($dbconn,$_POST['sid']);
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$b,$gotourl);

 if ( $msg != "" ) {
   $_SESSION['MSGID'.$b->id] = UrlEncode($msg);
   $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $b->id);
   $gotourl = addSessionKey($gotourl);
   Header("Status: 302 Moved Temporarily");
   Header("Location:". getBaseUrl() . $gotourl);
   return;
 }

 #
 # Old Bug
 #
 if ( $b->id > 0 )  {
   $newlines = "";
   if ( !empty($description) ) {
     $newlines = sprintf("<b>%s -- Added by %s</b>\n%s" ,Date($lang['DateTimePHP']),$current_user->getFullname() , myentities($description));
   }
   #
   # Solver Change
   #
   if ( $b->solver->id != $solver->id ) {
     if ( ($solver->id > 0) && ($b->solver->id > 0 ) ) {
       $newlines = sprintf("<b>%s -- Solver changed from <i>%s</i> to <i>%s</i> by %s</b>\n%s" ,Date($lang['DateTimePHP']),$b->solver->getFullName(),$solver->getFullName(),$current_user->getFullname() , $newlines);
     } else {
       $newlines = sprintf("<b>%s -- Solver changed by %s</b>\n%s" ,Date($lang['DateTimePHP']),$current_user->getFullname() , $newlines);
     }
     $b->setSolver($solver);
   }
   #
   # Parent Change
   #
   if (($oldparent != -1) && ($b->parent->id != $oldparent->id) ) {
     $newlines = sprintf("<b>%s -- Reference changed from <i>%s</i> to <i>%s</i> by %s</b>\n%s" ,Date($lang['DateTimePHP']),$oldparent->getFullName(),$b->parent->getFullName(),$current_user->getFullname() , $newlines);
   }
   #
   # State Change
   #
   if ( $b->state != $state ) {
     $newlines = sprintf("<b>%s -- State changed from <i>%s</i> to <i>%s</i> by %s</b>\n%s" ,Date($lang['DateTimePHP']),$b->getState(),$b->getState($state),$current_user->getFullname() , $newlines);
   }
   #
   # Class Change
   #
   if ( $b->class != $class ) {
     $newlines = sprintf("<b>%s -- Class changed from <i>%s</i> to <i>%s</i> by %s</b>\n%s" ,Date($lang['DateTimePHP']),$b->getClass(),$b->getClass($class),$current_user->getFullname() , $newlines);
   }
   if ( $b->short != $short ) {
     $newlines = sprintf("<b>%s -- ShortDescription changed from <i>%s</i> to <i>%s</i> by %s</b>\n%s" ,Date($lang['DateTimePHP']),$b->short,$short,$current_user->getFullname() , $newlines);
   }
   if ( !empty($newlines) ) {
     $b->description = sprintf("%s\n%s" ,rtrim($b->description) , $newlines);
   }
 } else {
   #
   # New Bug
   #
   $b->description = myentities($description);

   if ( $b->parent->getType() == "product" ) {
     $b->parent->readroles();
     if ( count($b->parent->role[PROD_ROLE_MANAGER]) > 0 ) {
       $b->setSolver(current($b->parent->role[PROD_ROLE_MANAGER]));
     } else if ( count($b->parent->role[PROD_ROLE_MANAGER2]) > 0 ) {
       $b->setSolver(current($b->parent->role[PROD_ROLE_MANAGER2]));
     } else {
       $b->setSolver($current_user);
     }
   } else if ( $b->parent->getType() == "installation" ) {
     $b->parent->product->readroles();
     if ( count($b->parent->product->role[PROD_ROLE_MANAGER]) > 0 ) {
       $b->setSolver(current($b->parent->product->role[PROD_ROLE_MANAGER]));
     } else if ( count($b->parent->product->role[PROD_ROLE_MANAGER2]) > 0 ) {
       $b->setSolver(current($b->parent->product->role[PROD_ROLE_MANAGER2]));
     } else {
       $b->setSolver($current_user);
	 }
   } else {
     $b->setSolver($current_user);
   }
 }
 $b->setName($name);
 $b->setShort($short);
 $b->setState($state);
 $b->setClass($class);

 $dbconn->Begin("WORK");
 $msg .= $b->save();
 $dbconn->Commit("WORK");


 $gotourl = $b->getURL();
 $_SESSION['MSGID'.$b->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $b->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: bug_ins.php,v 1.32.2.6 2003/10/01 15:45:59 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
