<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_select
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","select");
 loadlayout();

 /**
  * display a bug selection form
  */
 class bug_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     echo "<br><br><center>\n";

     echo "<form name=\"bugsearch\" method=\"get\" action=\"bug_overview.php\">\n";
     DoubleTableStart();

     echo "<tr>\n";
     if ( $this->ext == 0 ) {
       echo "<th colspan=\"3\">". $lang['SearchForBug'] ."</th>\n";

       echo "</tr><tr>\n";

       echo $this->showfieldc($lang['AdrName'],0,"name");
       echo " <td align=\"center\"><input id=\"name\" type=\"text\" value=\"\" name=\"name\"></td>\n";
       echo " <td align=\"center\">\n";
       echo " <input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForBug'] ."\"></td>\n";
       echo "</tr><tr>\n";
       echo " <td colspan=\"2\" align=\"center\"><font size=\"-1\">". $lang['BugSelInfo'] ."</font></td>\n";
       echo " <td align=\"center\">". makelink("bug_select.php?ext=1",$lang['extended']) ."</td>\n";
     } else {
       echo "<th colspan=\"3\">". $lang['SearchForBugExt'] ."</th>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['AdrName'],0,"name");
       echo " <td>&nbsp;<input id=\"name\" type=\"text\" value=\"\" name=\"name\">";
       echo " </td>\n";
       echo " <td align=\"center\"><input type=\"submit\" value=\"". $lang['Search'] ."\" TITLE=\"". $lang['SearchForBugExt'] ."\"></td>\n";
       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['BugState'],0,"state");
       echo " <td colspan=\"2\">&nbsp;<b>". BugAskState($this->state,2) ."</b>&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['BugClass'],0,"class");
       echo " <td colspan=\"2\">&nbsp;<b>". BugAskClass($this->class,1) ."</b>&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo " <td class=\"desc\" rowspan=\"2\">". $lang['BugBetween'] ."&nbsp;</td>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->from->EnterDate("f",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->to->EnterDate("t",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc(sprintf($lang['UserBugSearch'],$this->user->getLink()),0,"solverid");
       echo "<td><input id=\"solverid\" type=\"checkbox\" name=\"solverid\" value=\"". $this->user->id ."\">";
       echo "&nbsp;</td>\n";
     }

     echo "</tr>\n";
     DoubleTableEnd();
     hiddenFormElements();
     echo "</form>\n";
     echo "</center>\n";
     echo $this->setfocus("bugsearch.name");
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    *
    */
   Function prepare() {
     global $lang,$tutos;
     $this->name =  $lang['BugsSearch'];

     # Defaults for search
     $this->from = new DateTime(0);
     $this->to = new DateTime(0);
	 
     if ( isset($_SESSION['bugsearchfrom']) ) {
       $this->from->setDateTime($_SESSION['bugsearchfrom']);
     }
     if ( isset($_SESSION['bugsearchto']) ) {
       $this->to->setDateTime($_SESSION['bugsearchto']);
     }
     if ( isset($_SESSION['bugsearchclass']) ) {
       $this->class = $_SESSION['bugsearchclass'];
     } else {
       $this->class = -1;
     }
     if ( isset($_SESSION['bugsearchstate']) ) {
       $this->state = $_SESSION['bugsearchstate'];
     } else {
       $this->state = -1;
     }
     if ( ! isset($_GET['ext']) ) {
       $this->ext = 0;
     } else {
	   $this->ext = $_GET['ext'];
     }
     if ( ! $this->user->feature_ok(usebugtracking,PERM_SEL) ) {
       $this->stop = true;
	 }
     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       $x = array( url => "bug_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['CreateNewBug'],
                   category => array("bug","new","obj")
                 );
       $this->addMenu($x);
	 }
   }
 }

 $l = new bug_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_select.php,v 1.24 2002/12/23 10:01:34 gokohnert Exp $
    $Author: gokohnert $
-->