<?php
/**
 * Copyright 2001 - 2004 by Gero Kohnert
 *
 * A calendar for one week
 *
 * @modulegroup appointment
 * @module calendar_week
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'calendar.p3';
 include_once 'task.pinc';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('appointment','show');


 /**
  * display a calendar dfor a week
  */
 class calendar_week extends layout {
   /**
    * A one week calendar sheet
    */
   Function info() {
     global $lang,$tutos;

     $weeks = array_reverse(cal_week($this->user, $this->t));
     $wdays = $weeks[0]['wdays'];
     // $this->debug($weeks);
     
     $this->assign('weeks', $weeks);
     
     $this->assign('last_week', $weeks[0]['last']);
     $this->assign('next_week', $weeks[0]['next']);
     
     $this->assign('week', $lang['week']);
     $this->assign('wdays', $weeks[0]['wdays']);
     $this->assign('calendar', $lang['Calendar']);

     $this->template('calendar');
   }

   /**
    * naviagte
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $tutos, $lang;

     $this->name = $lang['Calendar'];
     if ( ! $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->team = $this->user->get_prefteam();
     $this->teamname = "";
     $this->uids = cal_parse_options($this->user,$this->teamname);
     $this->t = $_GET['t'];

     // menu
     // App modules are not ready
     /*
     $m = appointment::getSelectLink($this->user);
     $m[category][] = "obj";
     $this->addmenu($m);
     $m = appointment::getAddLink($this->user,$this->user);
     $this->addMenu($m);
     */
   }
 }

# info($_GET['t'],$current_user->get_prefteam(),$teamname,$uids);

 $l = new calendar_week($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: calendar_week.php,v 1.41.2.3 2005/01/11 14:44:29 tapoueh Exp $
    $Author: tapoueh $
-->