<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup company
 * @module company_ins
 * @package company
 */
 include_once "webelements.p3";
 include_once "permission.p3";

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('company','ins');

 $gotourl = "company_new.php";
 $msg = "";
 $c = new company($dbconn);
 # Location 
 $l = new location($dbconn);

 if ( isset($_POST['id']) ) {
   $gotourl = addUrlParameter($gotourl,"id=". $c->id,true);
   $c->read($_POST['id']);
   if ( ! $c->mod_ok() ) {
     # Not allowed
     $msg .= sprintf($lang['Err0024'],$lang[$c->getType()],true);
   }
 }

 if ( isset($_POST['loc_id']) ) {
   $gotourl= addUrlParameter($gotourl,"loc_id=". $_POST['loc_id'],true);
   $l->read($_POST['loc_id']);
   if ( ! $l->mod_ok() ) {
     # Not allowed
     $msg .= sprintf($lang['Err0024'],$lang[$l->getType()],true);
   }
 }

 if ( !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) || empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Company']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode($name),true);
 }

 if ( $msg == "" ) {
   if ( ($c->id < 0) || ($name != $c->name) ) {
     $q = "SELECT * FROM ". $c->tablename ." WHERE ". $dbconn->Like2("name", $name);
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new company($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0044'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # location
 $lmsg = $l->parseform();
 if ($l->used || ($l->id >0)) {
   $msg .= $lmsg;
 }

 # other modules
 $msg .= module_parseforms($current_user,$c,$gotourl);

 if ( $msg == "" ) {
   $c->setName($name);

   $dbconn->Begin("WORK");
   $msg = $c->save();
   $l->adr_id = $c->id;
   if ($l->used || ($l->id >0)) {
     $msg = $l->save();
#     $gotourl= addUrlParameter($gotourl,"loc_id=". $l->id,true);
   }
   $dbconn->Commit("WORK");

   $gotourl = $c->getURL();
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 /* Go back to user mask */
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl );
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: company_ins.php,v 1.25 2003/10/01 15:26:11 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>