<?php
/*
 * Copyright 2001 - 2003 by Gero Kohnert
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("database","new");
 loadlayout();

 /**
  * change/modify a database
  */
 class database_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"dbadd\" action=\"database_ins.php\" method=\"post\">\n";
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";
     if ( $this->obj->id != -1 ) {
       $this->addHidden("id",$this->obj->id);
       echo "<tr>\n";
       echo " <td colspan=\"4\" align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBName'],1,"name");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"3\"><input size=\"20\" maxlength=\"". $table['database']["name"][size] ."\" name=\"name\" value=\"".  myentities($this->obj->name) ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->name,3);
       $this->addHidden("name",$this->obj->name);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBAlias'],0,"alias");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"1\"><input size=\"20\" maxlength=\"". $table['database']["dbalias"][size] ."\" name=\"alias\" value=\"". $this->obj->alias ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->alias,1);
       $this->addHidden("alias",$this->obj->alias);
     }
     echo $this->showfieldc($lang['AdminDBPrefix'],0,"prefix");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"1\"><input size=\"20\" maxlength=\"". $table['database']["prefix"][size] ."\" name=\"prefix\" value=\"". $this->obj->prefix ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->prefix,1);
       $this->addHidden("prefix",$this->obj->prefix);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBHost'],0,"host");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"1\"><input size=\"20\" maxlength=\"". $table['database']["dbhost"][size] ."\" name=\"host\" value=\"". $this->obj->host ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->host,1);
       $this->addHidden("host",$this->obj->host);
     }
     echo $this->showfieldc($lang['AdminDBPort'],0,"port");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td><input size=\"6\" maxlength=\"6\" id=\"port\" name=\"port\" value=\"". $this->obj->port ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->port,1);
       $this->addHidden("port",$this->obj->port);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBType'],1,"type");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"3\"><select size=\"1\" name=\"type\">\n";
       @reset($this->obj->tlist);
       while ( list ($i,$f) = @each ($this->obj->tlist) ) {
         echo "<option value=\"". $i ."\"". ($this->obj->type == $i ? " selected":"") .">". myentities($f) ."</option>\n";
       }
       echo "</select></td>\n";
     } else {
       echo $this->showdata($this->obj->tlist[$this->obj->type],3);
       $this->addHidden("type",$this->obj->type);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBUser'],1,"user");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"1\"><input size=\"10\" maxlength=\"". $table['database']["dbuser"][size] ."\" name=\"user\" value=\"". $this->obj->user ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->user,1);
       $this->addHidden("user",$this->obj->user);
     }
     echo $this->showfieldc($lang['AdminDBPass'],0,"pass");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"1\"><input size=\"10\" maxlength=\"". $table['database']["dbpass"][size] ."\" name=\"pass\" value=\"". $this->obj->pass ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->pass,1);
       $this->addHidden("pass",$this->obj->pass);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBRep'],0,"rep");
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["repository"][size] ."\" name=\"rep\" value=\"". myentities($this->obj->repository) ."\"></td>\n";
     } else {
       echo $this->showdata($this->obj->repository,3);
       $this->addHidden("rep",$this->obj->repository);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdminDBHome'],0,"home");
     echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["dbhome"][size] ."\" name=\"home\" value=\"". myentities($this->obj->home) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['CfgLogo'],0,"logo");
     echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["logo"][size] ."\" name=\"logo\" value=\"". $this->obj->logo ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['CfgLogoLink'],0,"logolink");
     echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["logolink"][size] ."\" name=\"logolink\" value=\"". $this->obj->logolink ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['CfgBugAutoName'],0,"bugautoname");
     echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["bugautoname"][size] ."\" name=\"bugautoname\" value=\"". $this->obj->bugautoname ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['CfgInvAutoName'],0,"invautoname");
     echo "<td colspan=\"3\"><input size=\"50\" maxlength=\"". $table['database']["invautoname"][size] ."\" name=\"invautoname\" value=\"". $this->obj->invautoname ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['CfgVATlist'],0,"vatlist");
     echo "<td colspan=\"3\"><input size=\"30\" maxlength=\"". $table['database']["vatlist"][size] ."\" name=\"vatlist\" value=\"". $this->obj->vatlist ."\"></td>\n";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     echo "<tr>\n";
     if ($this->obj->id > 0 ) {
       submit_reset(0,1,1,1,1,0);
     } else {
       submit_reset(0,-1,1,1,1,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";

     echo $lang['FldsRequired'] ."\n";
     if ( ($this->obj->id > 1000) || ($this->obj->id == -1) ) {
       echo $this->setfocus("dbadd.name");
     } else {
       echo $this->setfocus("dbadd.home");
     } 
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>\n";
     if ( $this->obj->del_ok() && ($this->obj->id > 0) ) {
       echo confirmlink("database_del.php?id=".$this->obj->id, $lang['Delete'],sprintf($lang['Delete'],$this->obj->getFullName())) ."<br>\n";
     }
     if ( ($this->user->admin == 1) ) {
       echo menulink("database_new.php",$lang['NewEntry'],$lang['DBCreate']) ."<br>";
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new database($this->dbconn);
     if ( isset($_GET['id']) && ($_GET['id'] > -1) ) {
       $this->name = $lang['DBModify'];
       $this->obj->read($_GET['id']);
       if ( ($this->obj->id < 0) ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       $this->name = $lang['DBCreate'];
       $this->obj->name = $lang['PlsChangeName'];
	   if ( !$this->user->isadmin()) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
	   }
     }
     if ( !empty($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( !empty($_GET['alias']) ) {
       $this->obj->alias = StripSlashes($_GET['alias']);
     }
     if ( !empty($_GET['prefix']) ) {
       $this->obj->prefix = StripSlashes($_GET['prefix']);
     }
     if ( !empty($_GET['user']) ) {
       $this->obj->user = StripSlashes($_GET['user']);
     }
     if ( !empty($_GET['pass']) ) {
       $this->obj->pass = StripSlashes($_GET['pass']);
     }
     if ( !empty($_GET['host']) ) {
       $this->obj->host = StripSlashes($_GET['host']);
     }
     if ( !empty($_GET['port']) ) {
       $this->obj->port = StripSlashes($_GET['port']);
     }
     if ( !empty($_GET['type']) ) {
       $this->obj->type = StripSlashes($_GET['type']);
     }
     if ( !empty($_GET['logo']) ) {
       $this->obj->logo = StripSlashes($_GET['logo']);
     }
     if ( !empty($_GET['logolink']) ) {
       $this->obj->logolink = StripSlashes($_GET['logolink']);
     }
     if ( !empty($_GET['bugautoname']) ) {
       $this->obj->bugautoname = StripSlashes($_GET['bugautoname']);
     }
     if ( !empty($_GET['invautoname']) ) {
       $this->obj->invautoname = StripSlashes($_GET['invautoname']);
     }
     if ( !empty($_GET['vatlist']) ) {
       $this->obj->vatlist = StripSlashes($_GET['vatlist']);
     }
     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $x = database::getOverviewLink($this->user);
     $x[category][] = "obj";
     $this->addmenu($x);
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new database_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: database_new.php,v 1.26 2003/08/04 20:11:56 gokohnert Exp $
    $Author: gokohnert $
-->