<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup team
 * @module team_show
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'address_tools.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","show");

 function member_sort(&$a,&$b) {
   if ( ($a->gettype() == 'team') && ($b->gettype() != 'team') ) {
     return 1;
   }
   if ( ($b->gettype() == 'team') && ($a->gettype() != 'team') ) {
     return -1;
   }
   # both are the same type, so we can compare
   return ($a->getFullName() < $b->getFullName()) ? -1 : 1;
 }


 class team_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang;

     $this->assign('name', array('label' => $lang['Team'],
				 'value' => $this->obj->name));

     $this->assign('creation',
		   array('label' => $lang['TeamCreation'],
			 'value' => $this->obj->creation->getLinkDate()));

     $this->assign('manager',
		   array('label' => $lang['TeamManager'],
			 'value' => $this->obj->owner->getFullName(),
			 'title' => $this->obj->owner->getFullName(),
			 'link'  => $this->obj->owner->getUrl()));

     $this->assign('email',
		   array('label' => $lang['AdrEmail'],
			 'value' => AsEmail($this->obj->email,
					    $this->obj->email,
					    $this->obj->getFullName())));

     $this->assign('TeamDetail', $lang['TeamDetail']);

     $members = array();
     usort($this->obj->member,"member_sort");

     foreach ($this->obj->member as  $obj) {
       if ($obj->getType() == "team") {
	 $members[] = array('label' => $lang[$obj->getType()],
			    'value' => $obj->getFullName(),
			    'title' => $obj->getFullName(),
			    'link'  => $obj->getUrl());
       }
       else {
	 $members[] = array('label' => $obj->getFullName(),
			    'title' => $obj->getFullName(),
			    'link'  => $obj->getUrl(),
			    'email' => AsEmail($obj->default_email(),
					       $obj->default_email(),
					       $obj->getFullName()));
       }
     }	
     $this->assign('members', $members);

     $this->template('team_show');
   }

   /**
    *
    */
   Function navigate() {
     $this->menuPrint("task", True);
   }

   /**
    *
    */
   Function prepare() {
     global $lang,$msg;

     $this->name = $lang['TeamDetail'];

     $this->obj = new team($this->dbconn);
     if ( isset ($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .= ": ".$this->obj->getFullName();
       $this->obj->read_member();
     }


     // menu
     $x = team::getSelectLink($this->user,$lang['Search']);
     $x['image'] = 'search';
     $x['category'][] = "obj";
     $this->addMenu($x);

     if ( $this->user->isAdmin() ) {
       $x = array('url'   => "team_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['TeamCreateI'],
		  'image' => 'new',
                  'category' => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array('url'   => $this->obj->getModURL(),
                  'text'  => $lang['Modify'],
                  'info'  => sprintf($lang['TeamModifyI'],$this->obj->name),
		  'image' => 'modify',
                  'category' => array("team","new","obj")
                 );
       $this->addMenu($x);
     }

     if( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("acl","obj")
                 );
       $this->addMenu($x);
     }
     
     $this->link1 = "team_show.php?id=".$this->obj->id;
     $l = addUrlParameter($this->link1,"format=paper");
     $x = array('url'   => $l,
                'text'  => $lang['Printable'],
                'info'  => $lang['PrintableInfo'],
		'image' => 'teams',
                'category' => array("view","bug")
               );

     $this->addMenu($x);       
     
     if ( ($this->obj->id > 0)
	  && $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $x = array('url'  => "timetrack_overview.php?worker=".$this->obj->id,
                  'text' => $lang['TimetrackBooked'],
                  'info' => sprintf($lang['TimetrackBookedI'],
				    $this->obj->getFullName()),
		  'image' => 'timetrack',
                   'category' => array("timetrack","module")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0)
	  && $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
       $x = array('url'   => "task_overview.php?id=".$this->obj->id,
                  'text'  => $lang['TaskOverview'],
                  'info'  => sprintf($lang['TaskOverviewInfo'],
				     $this->obj->getFullName()),
		  'image' => 'task',
                  'category' => array("task","module")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) 
          && $this->user->feature_ok(usetaskmanagement,PERM_SEE) 
          && $this->user->feature_ok(usetimetrack,PERM_SEE) 
          ) {
       $x = array('url'   => "res_cal.php?id=".$this->obj->id,
                  'text'  => $lang['ResCal'],
                  'info'  => $lang['ResCal'],
		  'image' => 'resource',
                  'category' => array("timetrack","task","module")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0) {
       $x = $this->obj->getMailLink($this->user);
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0)
	  && $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $x = $this->obj->getCalLink($this->user);
       $this->addMenu($x);
     }

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     // $this->addtohistory();
     web_StackStartLayoutObj($this);
   }
 }

 $l = new team_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_show.php,v 1.51.2.3 2004/09/29 16:23:54 tapoueh Exp $
    $Author: tapoueh $
-->