<?php
/**
 * Copyright 2003 by Gero Kohnert
 *
 * display a overview o some urls
 *
 * @modulegroup url
 * @module url_overview
 * @package url
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('url','overview');
 loadmodule('url');

 /**
  * change/modify a url
  */
 class url_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();

     echo $this->actionformStart("url_overview.php");
     echo $this->OverviewTableStart();

     echo "<tr>\n";
     echo $this->orderHeader("",$lang['Reference'],$this->link2);
     echo $this->orderHeader("name",$lang['URLName'],$this->link2);
     echo $this->orderHeader("url",$lang['URL'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

	 $this->filter['name'] = prepare_regpattern($this->filter['name']);
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new url($this->dbconn);
       $c->read_result($this->result,$a);
       $a++;
       if ( ! $c->see_ok() ) {
         continue;
       }
       $c->ref = getObject($this->dbconn,$c->link_id);
       echo $this->OverviewRowStart($line);
       echo "<td valign=\"top\">";
       if ($c->ref != -1) {
         echo $c->ref->getLink();
       } else {
         echo "&nbsp;";
       }
       echo "</td>\n";
       $x = myentities($c->name);
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo "<td valign=\"top\">". $c->getLink($x) ."</td>";

       $x = $c->url;
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo "<td valign=\"top\">". $x ."</td>";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $c->del_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
     }

     echo $this->list_navigation($this->link1,3 + $tutos[massupdate],$this->start,$a,$n);
     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(2);
       echo sprintf($lang['withmarked'],$lang['URL']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option VALUE=\"-2\">". $lang['Delete'] ."</option>\n";
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }


     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("url_overview.php");
     $this->result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $b = new url($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= $lang['URLDel'] .": ". myentities($b->name) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= myentities($b->name) .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = "../". acl_action();
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['URLOverview'];

     if ( ! $this->user->feature_ok(useurl,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
	 }

     $this->link1 = "url/url_overview.php";
     $this->filter = array();

     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."urls";
     $pre = " WHERE ";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre ."(". $this->dbconn->Like("name",$_GET['name']);
       $this->q .= " or ". $this->dbconn->Like("url",$_GET['name']) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
       $this->filter['name'] = $_GET['name'];
       $this->addHidden("name",$_GET['name']);
     } else {
       $this->filter['name'] = "";
	 }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "url_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     # menu
     $x = url::getSelectLink($this->user,$lang['Search']);
     $x[category][] = "obj";
     $this->addMenu($x);
   }
 }

 $l = new url_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: url_overview.php,v 1.4.2.1 2005/04/07 16:43:25 tapoueh Exp $
    $Author: tapoueh $
-->
