<html>
<title>TWIG Language Generation</title>

<body>
<H1>TWIG Language Generation</H1>

<?php

Function GenerateLanguage( $language )
	{
	include( "strings.layout.php3" );

	include( "SourceFiles/english.strings.php3" );
	
	$EnglishTWIGphrase = $TWIGphrase;

	include( "SourceFiles/" . $language . ".strings.php3" );

	echo "Generating files for " . $language . "...<BR>\n";
		
	for( $i = 0, $j = count( $StringFiles ); $i < $j; $i++ )
		{
		if( !file_exists( "Output/" . $StringFiles[$i] . "/." ) ) { mkdir( "Output/" . $StringFiles[$i], 0777 ); }
		$fname = "Output/" . $StringFiles[$i] . "/" . $language . ".strings.php3";
		$newFile = fopen( $fname, "w" );

		echo "&nbsp;&nbsp;&nbsp;&nbsp;" . $fname . "<BR>\n";

		if( !$newFile ) { echo "open file error!"; exit; }

		fwrite( $newFile, "<?php\n" );
		fwrite( $newFile, "\n" );
		fwrite( $newFile, "  //--------------------------------------------------------\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // This is a Language Phrases file. \n" );
		fwrite( $newFile, "  // \n" );
		fwrite( $newFile, "  // Created by: " . $FileInfo["Created"] . "\n" );
		fwrite( $newFile, "  // Email: " . $FileInfo["Email"] . "\n" );
		fwrite( $newFile, "  // \n" );
		fwrite( $newFile, "  // Language: " . $FileInfo["Language"] . "\n" );
		fwrite( $newFile, "  // Translated by: " . $FileInfo["Created"] . "\n" );
		fwrite( $newFile, "  // Email: " . $FileInfo["Email"] . "\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // Current to TWIG version: " . $FileInfo["Version"] . "\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // Please refer to the code specification for instructions\n" );
		fwrite( $newFile, "  // on modifying and/or translating language files.\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  //--------------------------------------------------------\n" );
		fwrite( $newFile, "\n" );

		if( is_array( $StringLayout[$StringFiles[$i]]["config"] ) )
			{
			for( $k = 0, $l = count( $StringLayout[$StringFiles[$i]]["config"] ); $k < $l; $k++ )
				{
				$tag = $StringLayout[$StringFiles[$i]]["config"][$k];
				if( is_array( $config[$tag] ) )
					{
					$ostring = "  \$config[\"" . $tag . "\"]";
					$ostring = sprintf( "%-40s= array(", $ostring );
					fwrite( $newFile, $ostring );

					$first = 1;

					while( list( $key, $val ) = each( $config[$tag] ) ) 
						{
						if( !$first ) { fwrite( $newFile, "," ); }
						fwrite( $newFile, " \"" . $key . "\"=>\"" . $val . "\"" );
						$first = 0;
						}

					if( !$first ) { fwrite( $newFile, " " ); }
					fwrite( $newFile, ");\n" );
					}
				else
					{
					$config[$tag] = str_replace( "\"", "\\\"", $config[$tag] );

					$ostring = "  \$config[\"" . $tag . "\"]";
					$ostring = sprintf( "%-40s", $ostring );
					fwrite( $newFile, $ostring . "= \"" . $config[$tag] . "\";\n" );
					}
				}
			
			fwrite( $newFile, "\n" );
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["TWIGphrase"] ) )
			{
			for( $k = 0, $l = count( $StringLayout[$StringFiles[$i]]["TWIGphrase"] ); $k < $l; $k++ )
				{
				$tag = $StringLayout[$StringFiles[$i]]["TWIGphrase"][$k];

				$ostring = "  \$TWIGphrase[\"" . $tag . "\"]";
				$ostring = sprintf( "%-40s", $ostring );

				if( !$TWIGphrase[$tag] ) { $TWIGphrase[$tag] = $EnglishTWIGPhrase[$tag]; }
				$TWIGphrase[$tag] = str_replace( "\\", "\\\\", $TWIGphrase[$tag] );

				fwrite( $newFile, $ostring . "= \"" . $TWIGphrase[$tag] . "\";\n" );
				}
			
			fwrite( $newFile, "\n" );
			}
		
		if( is_array( $StringLayout[$StringFiles[$i]]["dayNamesShort"] ) )
			{
			$ostring = "  \$dayNamesShort";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNamesShort ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $dayNamesShort ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["dayNames"] ) )
			{
			$ostring = "  \$dayNames";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNames ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $dayNames ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["monthNames"] ) )
			{
			$ostring = "  \$monthNames";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNames ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $monthNames ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			
			fwrite( $newFile, "\n" );
			}

		fwrite( $newFile, "?>\n" );

		fclose( $newFile );
		}
	}
?>
Please select the language you wish to generate:
<form>

<select name=genlang>
<option>ALL</option>
<?php
		$handle = opendir( "SourceFiles/" );

		while( ( $file = readdir( $handle ) ) !== false ) 
			{
			if( strstr( $file, ".strings.php3" ) )
				{
				$lang = str_replace( ".strings.php3", "", $file );
				echo "<option>$lang</option>\n";
				}
			}

		closedir( $handle );
?>
</select>
<input type=submit value=GO>

</form>

<?php
if( $genlang )
	{
	echo "<H2>Status:</H2>\n";
	if( $genlang == "ALL" )
		{
		$handle = opendir( "SourceFiles/" );

		while( ( $file = readdir( $handle ) ) !== false ) 
			{
			if( strstr( $file, ".strings.php3" ) )
				{
				$lang = str_replace( ".strings.php3", "", $file );
				GenerateLanguage( $lang );
				}
			}

		closedir( $handle );
		}
	else
		{
		GenerateLanguage( $genlang );
		}
	}
?>

</body>

</html>