# -*- test-case-name: twisted.web2.test.test_httpauth -*-

from twisted.cred import credentials, error
from twisted.internet.defer import succeed, fail
from twisted.web2.auth.interfaces import ICredentialFactory

from zope.interface import implements

class BasicCredentialFactory(object):
    """
    Credential Factory for HTTP Basic Authentication
    """

    implements(ICredentialFactory)

    scheme = 'basic'

    def __init__(self, realm):
        self.realm = realm


    def getChallenge(self, peer):
        """
        @see L{ICredentialFactory.getChallenge}
        """
        return succeed({'realm': self.realm})


    def decode(self, response, request):
        """
        Decode the credentials for basic auth.

        @see L{ICredentialFactory.decode}
        """
        try:
            creds = (response + '===').decode('base64')
        except:
            raise error.LoginFailed('Invalid credentials')

        creds = creds.split(':', 1)
        if len(creds) == 2:
            return succeed(credentials.UsernamePassword(*creds))
        else:
            return fail(error.LoginFailed('Invalid credentials'))
