/* network.c - network  for typespeed

   thanks goto Steinar H. Gunderson <sgunderson@bigfoot.com>
   for the basic functions which we got from him
   
 */

#include "typespeed.h"

int close_network() {

	close(ttss);
	ttss=0;

return 0;
}

int init_network(char *serv,int graph)
{
	int one = 1;
	int sock = 0;
	int i;

	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	
	if (sock == -1) {
		if (graph) endcursestuff();
		perror("socket()");
		exit(1);
	}
	if (opt.client) {
		struct sockaddr_in s;

		s.sin_family = AF_INET;
		s.sin_addr.s_addr = inet_addr(serv);
		s.sin_port = htons(opt.port);

		if (s.sin_addr.s_addr == -1) {
			struct hostent *he;

			if (graph) {
				mvprintw(10,30,"Looking up %s...",serv);
				refresh();
			} else {
				printf("Looking up %s...\n", serv);
			}
			he = gethostbyname(serv);

			if (he == NULL) {
				if (graph) endcursestuff();
				perror(serv);
				exit(1);
			}
			bcopy(he->h_addr, (char *) &s.sin_addr, he->h_length);
		}

		if (graph) {
			mvprintw(10,30,"Connecting to typespeed server at %s (port %d)...\n",
			       inet_ntoa(s.sin_addr),opt.port);
			refresh();
		} else {
			printf("Connecting to typespeed server at %s (port %d)...\n",
			       inet_ntoa(s.sin_addr),opt.port);
		}

		if (connect(sock, (struct sockaddr *) &s, sizeof(s)) == -1) {
			if (graph) endcursestuff();
			perror(serv);
			exit(1);
		}
		i=net_ident(sock,0,graph);
		if(i!=0) return i;		

	} else {
		int ss;
		struct sockaddr_in addr;
		int one = 1;
		unsigned int len;

		bzero((char *) &addr, sizeof(addr));

		addr.sin_family = AF_INET;
		addr.sin_addr.s_addr = INADDR_ANY;
		addr.sin_port = htons(opt.port);

                while(1) {
                    
                ss = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
		if (ss == -1) {
			if (graph) endcursestuff();
			perror("socket()");
			exit(1);
		}
		setsockopt(ss, SOL_SOCKET, SO_REUSEADDR, &one, sizeof(one));
		if (bind(ss, (struct sockaddr *) &addr, sizeof(struct sockaddr)) == -1) {
			if (graph) endcursestuff();
			perror("cannot bind to port");
			exit(1);
		}

	        if (listen(ss, 1) == -1) {
			if (graph) endcursestuff();
		        perror("listen");
        		exit(1);
        	}

		if (graph) {
			mvprintw(10,30,"Waiting for connections...");
			refresh();
		} else {
			printf("Waiting for connections...\n");
		}

		sock = accept(ss, (struct sockaddr *) &addr, &len);

		if (sock == -1) {
			if (graph) endcursestuff();
			perror("accept()");
			exit(1);
		}

		ttss=ss;
		i=net_ident(sock,ss,graph);
                if(i!=0) {close(ss); return i;}
                if(i==0) {break;}
                
		}
	}
	ioctl(sock, FIONBIO, &one);

	return sock;
}


int net_ident(int typesock,int tss,int graph) {

	char buf[60];
	int i;

	sprintf(buf,"TYPESPEED %s\n",TVERSION);
	send(typesock, buf, strlen(buf), 0);	

	strcpy(buf,"                                                           ");

	if (graph) {
		mvprintw(10,30,"Connect.");
		mvprintw(10,30,"Waiting for other party to identify...");
		refresh();
	} else {
		printf("Connect.\n");
		printf("Waiting for other party to identify...\n");
	}

        i = recv(typesock, buf, 60, MSG_PEEK);
        if (i == -1 && errno != EWOULDBLOCK) {
		if (graph) endcursestuff();
		perror("recv()");
                exit(1);
        }
        if (i > 0) {
                recv(typesock, buf, strlen(buf) + 1, 0);
                if(strstr(buf,"TYPESPEED") > 0) {
			if (graph) {
				mvprintw(10,30,"Remote is using: %s",buf);
				refresh();
			} else {
				printf("Remote is using: %s\n",buf);
			}
		} else {
			if (graph) {
				mvprintw(10,30,"Remote is not TYPESPEED");
				refresh();
			} else {
				printf("Remote is not TYPESPEED\n");
			}		
		close(tss);
		return -69;
		}
        } else {
            return -69;
        }
return 0;
}


void net_waitgame(int typesock) {

	char buf[60];
	int i;

	sprintf(buf,"TYPESPEED %s\n",TVERSION);

	i=send(typesock, buf, strlen(buf), 0);	

	strcpy(buf,"                                                           ");

	while(1) {

	        i = recv(typesock, buf, 60, MSG_PEEK);
        	if (i == -1 && errno != EWOULDBLOCK) {
			endcursestuff();
			perror("recv()");
                	exit(1);
        	}
        	if (i > 0) {
                	recv(typesock, buf, strlen(buf) + 1, 0);
                	if(strstr(buf,"TYPESPEED") > 0) {
			break;
			}
		}
	}

}



void net_swapscore(int typesock, stats_struct *stat,stats_struct *stat2)
{

        char buf[60];
        int x,i;
        char *temp,*temp2;
        char *number;

	sprintf(buf,"SCORE: %d %f %f %f\n",stat->score,stat->speed,stat->totalspeed,stat->ratio);

	i=send(typesock, buf, strlen(buf), 0);	

	strcpy(buf,"                                                           ");

        while(1) {

                i = recv(typesock, buf, 60, MSG_PEEK);
                if (i == -1 && errno != EWOULDBLOCK) {
			endcursestuff();
                        perror("recv()");
                        exit(1);
                }
                if (i > 0) {
                        recv(typesock, buf, strlen(buf) + 1, 0);
		        if(strstr(buf,"SCORE:") > 0) {
				break;
			}
                }
        }

        number=malloc(10*sizeof(char));
        temp=malloc(80*sizeof(char));

        i=0;
        for(x=7;x<=strlen(buf);x++) {
          temp[i]=buf[x];
          i++;
        }


        strncpy(number,temp,strcspn(temp," "));
        stat2->score=strtol(number, NULL, 10);
        free(number);
	
        temp2=malloc(80*sizeof(char));

        i=0;
        for(x=strcspn(temp," ")+1;x<=strlen(temp);x++) {
          temp2[i]=temp[x];
          i++;
        }
        free(temp);

        number=malloc(10*sizeof(char));
        strncpy(number,temp2,strcspn(temp2," "));
        stat2->speed=(float) atof(number);
        free(number);
        temp=malloc(80*sizeof(char));

        i=0;
        for(x=strcspn(temp2," ")+1;x<=strlen(temp2);x++) {
          temp[i]=temp2[x];
          i++;
        }
        free(temp2);

        number=malloc(10*sizeof(char));
        strncpy(number,temp,strcspn(temp," "));
        stat2->totalspeed= (float) atof(number);
        temp2=malloc(80*sizeof(char));

        i=0;
        for(x=strcspn(temp," ")+1;x<=strlen(temp);x++) {
          temp2[i]=temp[x];
          i++;
        }

        stat2->ratio= (float) atof(temp2);
	free(temp);
	free(temp2);

}

