
/*
   misc.c - misc functions
 */

#include "typespeed.h"

int r(int range)
{				/* better random (?) */
	return (int) ((float) rand() / (float) RAND_MAX * (float) range);
}

/* returns the current time in hundreths of seconds. */
clock_t timenow(void)
{
	struct timeval tval;
	gettimeofday(&tval, NULL);
	return ((clock_t) ((tval.tv_sec * 100) + (tval.tv_usec / 10000)));
}

 /* yet another purkka by jaakko ..
    (no mvgetnstr support in jaakko's ncurses) */

void liima_mvgetnstr(int y, int x, char *buf, int maxlen)
{
	int curlen = 0;
	int merkki;

	memset(buf, 0, maxlen + 1);
	noecho();
	for (;;) {
		refresh();
		move(y, x + curlen);
		addstr("      ");

		move(y, x);
		if (curlen != 0) {
			addstr(buf);
		}
		refresh();

		merkki = getch();
		if (merkki == '\n' || merkki == KEY_ENTER) {
			break;
		}
		switch (merkki) {
		case 27:{
				flushinp();
			}
			break;
		case 8:
		case 127:
		case KEY_BACKSPACE:
		case 4:
			if (curlen != 0) {
				echochar(merkki);
				curlen--;
				buf[curlen] = '\0';
			}
			break;

		default:
			if (curlen != maxlen) {
				buf[curlen] = merkki;
				curlen++;
			}
			break;
		}
	}
	echo();
}



/* using this 'coz debian and others(?) didn't had it in ncurses
   thanks ras (timo sirainen) */

void dcolor_set(unsigned char col, void *ptr)
{
	register unsigned long bcol = 0;
	if (opt.usecolors == 1) {
		if ((col & 0x0f) == 8) {
			attroff(A_BOLD);
			bcol = A_DIM;
		} else {
			attroff(A_DIM);
			if (col & 8)
				bcol |= A_BOLD;
			else
				attroff(A_BOLD);
		}
		if ((col & 0x77) == 0)
			col |= 7;
		if (col & 128)
			bcol |= A_BLINK;
		else
			attroff(A_BLINK);
		attron(COLOR_PAIR((col & 7) + (col & 0x70) / 2) | bcol);
	}
}

int clower(int lchar)
{
	switch (lchar) {
	case -60:
		lchar = -28;
		break;
	case -59:
		lchar = -27;
		break;
	case -42:
		lchar = -10;
		break;
	default:
		lchar = tolower(lchar);
		break;
	}
	return lchar;
}

int typorankkaus(float typorate)
{

	int typorankki = 0;
	/* if you get a negative typorate here, you must
	   be as good as my frend xmunkki */
	/* and btw. thanks to xmunkki for his 
	   "OverHumanly debugging without compiler" */
	if (typorate < 0)
		typorankki = 0;
	if (typorate == 0)
		typorankki = 1;
	if ((typorate > 0) && (typorate < 2))
		typorankki = 2;
	if ((typorate >= 2) && (typorate < 4))
		typorankki = 3;
	if ((typorate >= 4) && (typorate < 6))
		typorankki = 4;
	if ((typorate >= 6) && (typorate < 8))
		typorankki = 5;
	if ((typorate >= 8) && (typorate < 11))
		typorankki = 6;
	if ((typorate >= 11) && (typorate < 15))
		typorankki = 7;
	if ((typorate >= 15) && (typorate < 20))
		typorankki = 8;
	if ((typorate >= 20) && (typorate < 30))
		typorankki = 9;
	if ((typorate >= 30) && (typorate < 50))
		typorankki = 10;
	if (typorate >= 50)
		typorankki = 11;

	if (typorate < 6)
		dcolor_set(6, NULL);
	if ((typorate >= 6) && (typorate < 11))
		dcolor_set(1, NULL);
	if ((typorate >= 11) && (typorate < 20))
		dcolor_set(7, NULL);
	if (typorate >= 20)
		dcolor_set(3, NULL);

	return (typorankki);

}

void endcursestuff()
{
	clear();
	refresh();
	endwin();
}

void initcursestuff()
{
	initscr();

	start_color();
	flushinp();

	init_pair(1, COLOR_GREEN, COLOR_BLACK);
	init_pair(2, COLOR_WHITE, COLOR_BLACK);
	init_pair(3, COLOR_RED, COLOR_BLACK);
	init_pair(4, COLOR_MAGENTA, COLOR_BLACK);
	init_pair(5, COLOR_CYAN, COLOR_BLACK);
	init_pair(6, COLOR_BLUE, COLOR_BLACK);
	init_pair(7, COLOR_YELLOW, COLOR_BLACK);

}

int level(int pointsit)
{
	int leveli = 0;

	if (pointsit <= 0)
		leveli = 0;
	if ((pointsit > 0) && (pointsit < 100))
		leveli = 1;
	if ((pointsit > 99) && (pointsit < 200))
		leveli = 2;
	if ((pointsit > 199) && (pointsit < 300))
		leveli = 3;
	if ((pointsit > 299) && (pointsit < 400))
		leveli = 4;
	if ((pointsit > 399) && (pointsit < 500))
		leveli = 5;
	if ((pointsit > 499) && (pointsit < 600))
		leveli = 6;
	if ((pointsit > 599) && (pointsit < 700))
		leveli = 7;
	if ((pointsit > 699) && (pointsit < 800))
		leveli = 8;
	if ((pointsit > 799) && (pointsit < 900))
		leveli = 9;
	if (pointsit > 899)
		leveli = 10;
	if (pointsit < 400)
		dcolor_set(6, NULL);
	if ((pointsit > 399) && (pointsit < 600))
		dcolor_set(1, NULL);
	if ((pointsit > 599) && (pointsit < 700))
		dcolor_set(7, NULL);
	if (pointsit > 699)
		dcolor_set(3, NULL);

	return (leveli);

}
