//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: ImplicitSignal.cc,v 1.19 1999/03/09 22:52:04 dmartin Exp $
//
//---------------------------------------------------------------------------

template <class Type>
inline
ImplicitSignal<Type>::ImplicitSignal(){
  fanDest = NULL;
  source = NULL;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  allAttributes.sigtype = drvVal.get_universal_kind();
}

template <class Type>
inline
ImplicitSignal<Type>::ImplicitSignal(const int i){
  fanDest = NULL;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  allAttributes.sigtype = drvVal.get_universal_kind();
  source = NULL;
  drvVal = Type(i);
  effVal = Type(i);
}

// template <class Type>
// ImplicitSignal<Type>::ImplicitSignal(const char value){
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(value);
//   effVal = Type(value);
// }

// template <class Type>
// ImplicitSignal<Type>::ImplicitSignal(const double value){
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(value);
//   effVal = Type(value);
// }

// template <class Type>
// ImplicitSignal<Type>::ImplicitSignal(const bool value){
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(value);
//   effVal = Type(value);
// }

template <class Type>
inline
ImplicitSignal<Type>::ImplicitSignal(const VHDLData& val){
  source = NULL;
  fanDest = NULL;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  this->operator=(val);
  allAttributes.sigtype = drvVal.get_universal_kind();
}


template <class Type>
inline
ImplicitSignal<Type>::ImplicitSignal(const char* newname) : SignalBase(newname) {
  fanDest = NULL;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  source = NULL;
}


template <class Type>
inline void
ImplicitSignal<Type>::updateDriver(const int, const int, VHDLData*, const ArrayInfo*,
				       const ArrayInfo*) {
  // An implicit signal will not have any driver.  So there is no need to
  // update it.
  return;
}


template <class Type>
inline VHDLType*
ImplicitSignal<Type>::readDriver(int) {
  // An implicit signal does not have any driver.
  return NULL;
}


template <class Type>
inline void
ImplicitSignal<Type>::updateDrvVal(const VHDLData* data, const ArrayInfo*,
				       const ArrayInfo*) {
  drvVal = *(Type*)data;
}


template <class Type>
inline VHDLData*
ImplicitSignal<Type>::readDrvVal() {
  return &drvVal;
}


template <class Type>
inline void
ImplicitSignal<Type>::updateEffVal(const VHDLData* data, const ArrayInfo*,
				       const ArrayInfo*) {
  effVal = *(const Type*)data;
}

template <class Type>
inline void
ImplicitSignal<Type>::updateEffVal(const VHDLData& data, const ArrayInfo*,
				       const ArrayInfo*) {
  effVal = (const Type &)data;
}

template <class Type>
inline VHDLData*
ImplicitSignal<Type>::readEffVal() {
  return &effVal;
}


template <class Type>
inline VTime&
ImplicitSignal<Type>::readTimeVal() {
  return timeval;
}


template <class Type>
inline VTime&
ImplicitSignal<Type>::updateTimeVal(const VTime& v) {
  timeval = v;
  return timeval;
}

template <class Type>
inline ObjectBase&
ImplicitSignal<Type>:: operator=(const ObjectBase& s) {
  // ImplicitSignal<Type> sig = (ImplicitSignal<Type>&) s;

  SignalBase::operator=((const SignalBase &) s);
  
  timeval = ((ImplicitSignal<Type> &) s).timeval;
  source  = ((ImplicitSignal<Type> &) s).source;
  drvVal  = ((ImplicitSignal<Type> &) s).drvVal;
  effVal  = ((ImplicitSignal<Type> &) s).effVal;
  
  // Yes, these make multiple pointers to the same memory.  Since the
  // contents of this memory never change, it is allocated once at the
  // beginning of the simulation, and deleted at the end.  SO, everyone
  // looks at the same memory, and it never needs to be
  // newd/deleted/copied.
  //fanDest = sig.fanDest;
  //attributeList = sig.attributeList;
  return *this;
}

template <class Type>
inline ObjectBase&
ImplicitSignal<Type>:: operator=(const VHDLData& s) {
  //This function is used only during initialization
  // source = s;
  drvVal = s;
  effVal = s;
  return *this;
}

// if you can figure out how to make operator<< link for this, do it!
template <class Type>
inline void 
ImplicitSignal<Type>::print(ostream& os) const {
  register int i;

  os << "ImplicitSignal \"" << name << "\" (ID " << id << ") of type " 
     << type << ":" << endl;
  os << " driving value: " << drvVal << endl << " effective value: " 
     << effVal << endl;
  os << endl;
  os << "   current timeval: " << timeval << endl;

  if (fanout > 0) {
    os << "    fanouts: ";
    for (i = 0; i < fanout; i++) {
      os << fanDest[i] << " ";
    }
    os << endl;
  }
  if (numAttributes > 0) {
    os << "    Attributes: ";
    for (i = 0; i < numAttributes; i++) {
      os << attributeList[i] << " ";
    }
    os << endl;
  }
}
